package com.elitesland.fin.application.service.writeoff;

import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyRecHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecHeadSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecHeadVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecHeadDO;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecHeadRepo;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecHeadRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyRecHeadServiceImpl implements FinArRecVerApplyRecHeadService {

    private final FinArRecVerApplyRecHeadRepoProc finArRecVerApplyRecHeadRepoProc;

    private final FinArRecVerApplyRecHeadRepo finArRecVerApplyRecHeadRepo;

    @Override
    public Long create(Long masId, FinArRecVerApplyRecHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinArRecVerApplyRecHeadDO entity = FinArRecVerApplyRecHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);
        return finArRecVerApplyRecHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyRecHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinArRecVerApplyRecHeadVO> listByMasIds(Collection<Long> masIds) {
        return finArRecVerApplyRecHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyRecHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());
    }

	@Override
	public List<FinArRecVerApplyRecHeadVO> listByIds(Collection<Long> ids) {
		return finArRecVerApplyRecHeadRepoProc.listByIds(ids)
				.stream()
				.map(FinArRecVerApplyRecHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
