package com.elitesland.fin.application.service.writeoff;

import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyRecConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecDO;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyRecServiceImpl implements FinArRecVerApplyRecService {

    private final FinArRecVerApplyRecRepoProc finArRecVerApplyRecRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinArRecVerApplyRecSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        finArRecVerApplyRecRepoProc.save(saveList.stream()
                .map(e -> {
                    FinArRecVerApplyRecDO entity = FinArRecVerApplyRecConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyRecRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinArRecVerApplyRecVO> listByMasIds(Collection<Long> masIds) {
        return finArRecVerApplyRecRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyRecConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
    }

	/**
	 * 根据条件查询核销收款单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyRecVO> listByQuery(FinArRecVerApplyRecQuery query) {
		return finArRecVerApplyRecRepoProc.listByQuery(query)
				.stream()
				.map(FinArRecVerApplyRecConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方收款单号或者明细ID查询
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyRecVO> listByOutRecDocNoOrDId(FinArRecVerApplyQuery query) {
		/*if(StrUtil.isEmpty(query.getOutRecDocNo()) && StrUtil.isEmpty(query.getOutRecDId())){
			return null;
		}*/
		return finArRecVerApplyRecRepoProc.listByOutRecDocNoOrDId(query);
	}
}
