package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookOuParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSetOfBookOuVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSetOfBookVO;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/account/book")
@RequiredArgsConstructor
@Api(value = "账套", tags = {"账套"})
public class FinSetOfBookController {

    private final FinSetOfBookService finSetOfBookService;

    @PostMapping("saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinSetOfBookParam finSetOfBookParam) {
        return ApiResult.ok(finSetOfBookService.saveOrUpdate(finSetOfBookParam));
    }

    @PostMapping("page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinSetOfBookVO>> page(@RequestBody FinSetOfBookParam finSetOfBookParam) {
        return ApiResult.ok(finSetOfBookService.page(finSetOfBookParam));
    }

    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinSetOfBookParam finSetOfBookParam) {
        finSetOfBookService.enableOrDisable(finSetOfBookParam);
        return ApiResult.ok();
    }

    @PostMapping("deleteFinSetOfBookOu")
    @ApiOperation("删除账套公司")
    public ApiResult<Long> deleteFinSetOfBookOu(@RequestBody FinSetOfBookParam finSetOfBookParam) {
        finSetOfBookService.deleteFinSetOfBookOu(finSetOfBookParam);
        return ApiResult.ok();
    }

    @PostMapping("deleteFinSetOfBookLine")
    @ApiOperation("删除账套明细")
    public ApiResult<Long> deleteFinSetOfBookLine(@RequestBody FinSetOfBookParam finSetOfBookParam) {
        finSetOfBookService.deleteFinSetOfBookLine(finSetOfBookParam);
        return ApiResult.ok();
    }

    @PostMapping("/queryOuAndYear")
    @ApiOperation("查询账套下公司和期间年份")
    public ApiResult<FinSetOfBookVO> queryOuAndYear(@RequestBody FinSetOfBookParam finSetOfBookParam) {
        return ApiResult.ok(finSetOfBookService.queryOuAndYear(finSetOfBookParam));
    }

    @PostMapping("/queryOu")
    @ApiOperation("查询账套下公司")
    public ApiResult<PagingVO<FinSetOfBookOuVO>> queryOu(@RequestBody FinSetOfBookOuParam finSetOfBookParam) {
        return ApiResult.ok(finSetOfBookService.queryOu(finSetOfBookParam));
    }

}
