package com.elitesland.fin.application.web.payorder;


import com.elitesland.fin.application.facade.param.payorder.ApOrderToPaySaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.service.payorder.PayOrderDtlService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author zhiyu.he
 * @date 2022/3/16 10:34
 */
@RestController
@RequestMapping("/fin/payOrder")
@RequiredArgsConstructor
@Api(value = "付款单", tags = {"付款单"})
public class PayOrderController {

    private final PayOrderService payOrderService;

    private final PayOrderDtlService payOrderDtlService;

    @PostMapping("page")
    @ApiOperation("分页查询付款单")
    public ApiResult<PagingVO<PayOrderVO>> page(@RequestBody PayOrderPageParam param) {
        return ApiResult.ok(payOrderService.page(param));
    }

    @GetMapping("/query/{id}")
    @ApiOperation("查询付款单详细信息(无明细信息)")
    public ApiResult<PayOrderVO> queryById(@PathVariable("id") Long id) {
        return ApiResult.ok(payOrderService.queryById(id));
    }

    @PostMapping("pageDtl")
    @ApiOperation("分页查询付款单明细")
    public ApiResult<PagingVO<PayOrderDtlVO>> page(@RequestBody PayOrderDtlPageParam param) {
        return ApiResult.ok(payOrderDtlService.page(param));
    }

    @GetMapping("/queryDetails/{id}")
    @ApiOperation("查询付款单详细信息(明细集合)")
    public ApiResult<PayOrderVO> queryDetails(@PathVariable("id") Long id) {
        return ApiResult.ok(payOrderService.queryDetailsById(id));
    }

    @GetMapping("defaultValue")
    @ApiOperation("获取新增默认值")
    public ApiResult<PayOrderVO> defaultValue() {
        return payOrderService.defaultValue();
    }

    @DeleteMapping("delete")
    @ApiOperation("删除付款单")
    public ApiResult<List<Long>> delete(@RequestBody List<Long> ids) {
        return payOrderService.deleteByIds(ids);
    }

    @PostMapping("save")
    @ApiOperation("新增/修改-保存付款单")
    public ApiResult<Long> save(@RequestBody PayOrderSaveParam param) {
        return payOrderService.save(param);
    }

    @PostMapping("submit")
    @ApiOperation("新增/修改-提交付款单")
    public ApiResult<Long> submit(@RequestBody PayOrderSaveParam param) {
        return payOrderService.submit(param);
    }


    @PostMapping("savePayOrder")
    @ApiOperation("应付单生成付款单")
    public ApiResult<String> savePayOrder(@RequestBody ApOrderToPaySaveParam apTypeParam) {
        return payOrderService.saveByApOrder(apTypeParam);
    }

    @PostMapping("/red/punch/{id}")
    @ApiOperation("红冲-redPunch")
    public ApiResult<Long> redPunch(@PathVariable Long id) {
        return payOrderService.redPunch(id);
    }

    @PostMapping("/cancel")
    @ApiOperation("取消-应付单")
    public ApiResult<Void> cancel(@RequestBody List<Long> ids) {
        return payOrderService.cancelApprove(ids);
    }
    @PostMapping("writeoff/page")
    @ApiOperation("付款单待核销列表查询")
    public ApiResult<PagingVO<PayOrderVO>> writeoffPage(@RequestBody PayOrderPageParam param) {
        return ApiResult.ok(payOrderService.writeoffPage(param));
    }

}
