package com.elitesland.fin.common;

/**
 * 枚举类.
 *
 * @author shihao.ma
 * @since 2023/9/13
 */
public enum WriteoffUdcEnum {

    // 应收收款核销申请单状态
    AR_REC_VER_APPLY_STATUS_NEW("FIN", "AR_REC_VER_APPLY_STATUS", "状态", "NEW", "草稿"),
    AR_REC_VER_APPLY_STATUS_APPROVAL("FIN", "AR_REC_VER_APPLY_STATUS", "状态", "APPROVAL", "待审批"),

	AR_REC_VER_APPLY_STATUS_APPROVALING("FIN", "AR_REC_VER_APPLY_STATUS", "状态", "APPROVALING", "审批中"),
    AR_REC_VER_APPLY_STATUS_APPROVED("FIN", "AR_REC_VER_APPLY_STATUS", "状态", "APPROVED", "审批通过"),
    AR_REC_VER_APPLY_STATUS_REFUSE("FIN", "AR_REC_VER_APPLY_STATUS", "状态", "REFUSE", "审批拒绝"),

    // 应收收款核销申请单核销状态
    AR_REC_VER_APPLY_VER_STATUS_NOT("FIN", "AR_REC_VER_APPLY_VER_STATUS", "核销状态", "NOT", "未核销"),
    AR_REC_VER_APPLY_VER_STATUS_COMPLETE("FIN", "AR_REC_VER_APPLY_VER_STATUS", "核销状态", "COMPLETE", "已核销"),

	AR_REC_VER_APPLY_VER_STATUS_FAILED("FIN", "AR_REC_VER_APPLY_VER_STATUS", "核销状态", "FAILED", "核销失败"),
    AR_REC_VER_APPLY_VER_STATUS_CANCEL("FIN", "AR_REC_VER_APPLY_VER_STATUS", "核销状态", "CANCEL", "已取消"),

	AR_REC_VER_APPLY_VER_STATUS_CANCELING("FIN", "AR_REC_VER_APPLY_VER_STATUS", "核销状态", "CANCELING", "取消中"),

	AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED("FIN", "AR_REC_VER_APPLY_VER_STATUS", "核销状态", "CANCEL_FAILED", "取消失败"),



    //核销状态
    FIN_VERIFY_STATUS_PART("FIN", "VERIFY_STATUS", "核销状态", "PART", "部分核销"),
    FIN_VERIFY_STATUS_YES("FIN", "VERIFY_STATUS", "核销状态", "YES", "已核销"),
    FIN_VERIFY_STATUS_NO("FIN", "VERIFY_STATUS", "核销状态", "NO", "无需核销"),
    FIN_VERIFY_STATUS_AWAIT("FIN", "VERIFY_STATUS", "核销状态", "AWAIT", "待核销"),

    //核销标记
    FIN_VERIFY_FLAG_NORMAL("FIN", "VERIFY_FLAG", "核销标记", "NORMA", "应收单和收款单核销"),
    FIN_VERIFY_FLAG_INTERNAL("FIN", "VERIFY_FLAG", "核销标记", "INTERNAL", "应收单和应收单对冲或者收款单和收款单对冲"),
    FIN_VERIFY_FLAG_CANCEL("FIN", "VERIFY_FLAG", "核销标记", "CANCEL", "取消核销"),

    FIN_VER_MODE_MANUAL("FIN", "VER_MODE", "核销方式", "MANUAL", "手动"),
    FIN_VER_MODE_AUTOMATIC("FIN", "VER_MODE", "核销方式", "AUTOMATIC", "自动"),

    FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK("FIN", "WRITEOFF_ORDER", "核销顺序", "BUDATE_FRONT_BACK", "按业务日期从前往后"),
    FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT("FIN", "WRITEOFF_ORDER", "核销顺序", "BUDATE_BACK_FRONT", "按业务日期从后往前")


    //核销方式

    ;

    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    WriteoffUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }
}
