package com.elitesland.fin.domain.entity.inputinv;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/5/6 9:06
 */
@Data
public class InputInv {

    private Long id;

    private String sourceNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private BigDecimal taxRate;

    private String invRegNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private String openBank;

    private String bankAccount;

    private String suppAddress;

    private String suppRemark;

    private Long suppId;

    private String suppName;

    private String suppCode;

    private String suppTel;

    private String invUser;

    private String recUser;

    private String revUser;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private String auditRejection;

    private String createMode;

    private String taxNumber;

    private String creator;

    private LocalDateTime createTime;

    private String remark;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<InputInvDtl> dtlList;


    public void checkInvNo() {
        List<String> invNo = dtlList.stream().map(InputInvDtl::getInvNo).distinct().collect(Collectors.toList());
        if (invNo.size() < dtlList.size()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "发票号码存在重复,请检查!");
        }
    }

    public void count() {
        for (InputInvDtl inputInvDtl : dtlList) {
            //含税金额=含税单价*数量；
            BigDecimal totalAmount = inputInvDtl.getPrice().multiply(inputInvDtl.getQty()).setScale(2, RoundingMode.HALF_UP);
            if (totalAmount.compareTo(inputInvDtl.getTotalAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额不相等!");
            }
            // 含税金额本位币=含税金额*汇率；
            BigDecimal totalCurAmount = totalAmount.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            if (totalCurAmount.compareTo(inputInvDtl.getTotalCurAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额本位币不相等!");
            }
            // 税额=round(((数量*含税单价)*税率/(1+税率)),2)；
            BigDecimal taxAmt = totalAmount.multiply(inputInvDtl.getTaxRate()).divide(new BigDecimal(1).add(inputInvDtl.getTaxRate()), 2, RoundingMode.HALF_UP);
            if (taxAmt.compareTo(inputInvDtl.getTaxAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额不相等!");
            }
            // 税额本位币=税额*汇率；
            BigDecimal taxCurAmt = taxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            if (taxCurAmt.compareTo(inputInvDtl.getTaxCurAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额本位币不相等!");
            }
            //不含税金额=含税金额-税额；
            BigDecimal exclTaxAmt = totalAmount.subtract(taxAmt).setScale(2, RoundingMode.HALF_UP);
            if (exclTaxAmt.compareTo(inputInvDtl.getExclTaxAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额不相等!");
            }
            // 不含税金额本位币=含税金额本位币-税额本位币；
            BigDecimal excelCurAmt = totalCurAmount.subtract(taxCurAmt).setScale(2, RoundingMode.HALF_UP);
            if (excelCurAmt.compareTo(inputInvDtl.getExclTaxCurAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额本位币不相等!");
            }
        }
        BigDecimal totalAmount = dtlList.stream().map(InputInvDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        if (this.totalAmt.compareTo(totalAmount) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细总金额与单据总金额不相等!");
        }
    }

    public void checkOrderState() {
        if (!this.orderState.equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "只能编辑单据为草稿状态的单据!");
        }
    }

    public void checkNotNull() {

        if (this.createMode.equals(UdcEnum.FIN_PINV_CREATE_MODE_GR.getValueCode())) {
            Assert.notNull(this.totalAmt, "开票总金额");
            Assert.notNull(this.localCurrCode, "本位币不能为空");
            Assert.notEmpty(this.localCurrName, "本位币名称不能为空");
            Assert.notNull(this.taxRate, "税率不能为空");
            Assert.notNull(this.taxNumber, "纳税人识别号");
            Assert.notNull(this.suppAddress, "详细地址不能为空");
            Assert.notNull(this.suppTel, "供应商电话不能为空");
            Assert.notNull(this.openBank, "开户银行不能为空");
            Assert.notNull(this.bankAccount, "银行账号不能为空");
        }

        Assert.notNull(this.ouId, "公司ID不能为空");
        Assert.notNull(this.exchangeRate, "汇率不能为空");
        Assert.notNull(this.ouName, "公司名称不能为空");
        Assert.notNull(this.ouCode, "公司编码不能为空");
        Assert.notNull(this.currCode, "币种编码不能为空");
        Assert.notNull(this.currName, "币种名称不能为空");
        Assert.notNull(this.suppId, "供应商ID不能为空");
        Assert.notNull(this.suppCode, "供应商编码不能为空");
        Assert.notNull(this.suppName, "供应商名称不能为空");
        dtlList.forEach(x ->
                x.checkNotNull(this.createMode)
        );
    }
}
