package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 应收收款核销申请单-应收单.
 * @author gyj
 */
@Entity
@Table(name = "fin_ar_rec_ver_apply_ar_head")
@DynamicInsert
@DynamicUpdate
@Comment("应收收款核销申请单-应收单")
@Getter
@Setter
@Accessors(chain = true)
public class FinArRecVerApplyArHeadDO extends BaseModel {

    private static final long serialVersionUID = -1241790256610034591L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "ar_order_no", columnDefinition = "varchar(32) comment '应收单编号'")
    private String arOrderNo;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "create_mode", columnDefinition = "varchar(32) comment '单据来源'")
    private String createMode;

    @Column(name = "ar_type_id", columnDefinition = "bigint(20) comment '应收单类型定义ID'")
    private Long arTypeId;

    @Column(name = "ar_type_name", columnDefinition = "varchar(32) comment '应收单类型名称'")
    private String arTypeName;

    @Column(name = "ar_type_code", columnDefinition = "varchar(32) comment '应收单类型代码'")
    private String arTypeCode;

    @Column(name = "order_state", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;

    @Column(name = "bu_date", columnDefinition = "datetime(6) comment '业务日期'")
    private LocalDateTime buDate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(32) comment '币种'")
    private String currName;

    @Column(name = "local_curr_code", columnDefinition = "varchar(32) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(32) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核日期'")
    private LocalDateTime auditDate;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "oper_user_id", columnDefinition = "bigint(20) comment '经办人ID'")
    private Long operUserId;

    @Column(name = "operator", columnDefinition = "varchar(32) comment '经办人'")
    private String operator;

    @Column(name = "tax_flag", columnDefinition = "tinyint(1) comment '是否含税'")
    private Boolean taxFlag;

    @Column(name = "init_flag", columnDefinition = "tinyint(1) comment '是否期初'")
    private Boolean initFlag;

    @Column(name = "audit_rejection", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户名称'")
    private String custName;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '部门ID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '部门编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '部门名称'")
    private String buName;

    @Column(name = "bu_type", columnDefinition = "varchar(32) comment '业务类型'")
    private String buType;

    @Column(name = "pay_ment_name", columnDefinition = "varchar(32) comment '付款条件'")
    private String payMentName;

    @Column(name = "pay_ment_id", columnDefinition = "varchar(20) comment '付款条件id'")
    private String payMentId;

    @Column(name = "pay_ment_code", columnDefinition = "varchar(32) comment '付款条件code'")
    private String payMentCode;

    @Column(name = "ver_state", columnDefinition = "varchar(32) comment '核销状态'")
    private String verState;

    @Column(name = "ver_amt", columnDefinition = "decimal(18,8) comment '已核销金额'")
    private BigDecimal verAmt;

    // 组织
    @Column(name = "org_id", columnDefinition = "bigint(20) comment '组织ID'")
    private Long orgId;

    @Column(name = "org_code", columnDefinition = "varchar(32) comment '组织编码'")
    private String orgCode;

    @Column(name = "org_name", columnDefinition = "varchar(32) comment '组织名称'")
    private String orgName;

    @Column(name = "sale_user_id", columnDefinition = "bigint(20) comment '销售业务员ID'")
    private Long saleUserId;

    @Column(name = "sale_user", columnDefinition = "varchar(32) comment '销售业务员'")
    private String saleUser;

    @Column(name = "salesman_name", columnDefinition = "varchar(32) comment '销售业务员'")
    private String salesmanName;

    @Column(name = "ar_order_type", columnDefinition = "varchar(32) comment '单据类型'")
    private String arOrderType;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(64) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(32) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;

    @Column(name = "doc_type", columnDefinition = "varchar(32) comment '具体订单场景'")
    private String docType;

    @Column(name = "doc_type2", columnDefinition = "varchar(32) comment 'B端订单/C端订单'")
    private String docType2;

    @Column(name = "doc_cls", columnDefinition = "varchar(32) comment '传SO代表正向，传RSO代表退货负向'")
    private String docCls;

    @Column(name = "settlement_type", columnDefinition = "varchar(32) comment '结算方式'")
    private String settlementType;

    @ApiModelProperty("订单客户")
    @Column(name = "order_customer", columnDefinition = "varchar(32)  comment '订单客户'")
    private String orderCustomer;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("开票日期")
    @Column(name = "inv_date", columnDefinition = "datetime(6)  comment '开票日期'")
    private LocalDateTime invDate;

    @ApiModelProperty("发票类型")
    @Column(name = "inv_type", columnDefinition = "varchar(32)  comment '发票类型'")
    private String invType;

    @ApiModelProperty("起算日期")
    @Column(name = "start_date", columnDefinition = "datetime(6)  comment '起算日期'")
    private LocalDateTime startDate;

    @ApiModelProperty("红冲标志")
    @Column(name = "red_flush_sign", columnDefinition = "tinyint(1)  comment '红冲标志'")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    @Column(name = "third_payment_assistance", columnDefinition = "varchar(32)  comment '第三方支付辅助'")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    @Column(name = "consumer_card_ssistance", columnDefinition = "varchar(32)  comment '消费卡辅助'")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    @Column(name = "credit_card_assistance", columnDefinition = "varchar(32)  comment '信用卡辅助'")
    private String creditCardAssistance;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "apply_ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmting;

    @ApiModelProperty("未核销金额")
    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

    @Column(name = "salesman_code", columnDefinition = "varchar(32)  comment '业务员编码'")
    private String salesmanCode;
}
