package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
public interface ReceiptPaymentAgreementDomainService {

    /**
     * 收付款协议保存
     *
     * @param saveParam 入参
     * @return收付款协议ID
     */
    Long save(ReceiptPaymentAgreementSaveParam saveParam);

    /**
     * 收付款协议分页查询
     *
     * @param pageParam 入参
     * @return 收付款协议信息集合
     */
    PagingVO<ReceiptPaymentAgreementPagingVO> page(ReceiptPaymentAgreementPageParam pageParam);

    /**
     * 根据ID查询主表数据
     *
     * @param id 收付款协议ID
     * @return 收付款协议主表数据
     */
    ReceiptPaymentAgreementVO findById(Long id);

    /**
     * 根据收付款协议ID查询收付款协议主表数据
     *
     * @param id 收付款协议ID
     * @return 收付款协议主表数据
     */
    ReceiptPaymentAgreementVO selectById(Long id);

    /**
     * 根据收付款协议编码查询收付款协议主表数据
     *
     * @param code 根据收付款协议编码
     * @return 收付款协议主表数据
     */
    ReceiptPaymentAgreementVO selectByCode(String code);

    /**
     * 根据入参查询收付款协议数据
     *
     * @param queryVO 入参
     * @return 收付款协议主表数据
     */
    List<ReceiptPaymentAgreementVO> selectByParam(ReceiptPaymentAgreementPageParam queryVO);

    /**
     * 校验查询编号/名称是否已经存在
     *
     * @param queryVO 入参
     * @return 收付款协议主表数据
     */
    ReceiptPaymentAgreementVO checkSelectByParam(ReceiptPaymentAgreementPageParam queryVO);

    /**
     * 根据ID批量更新状态
     *
     * @param status 状态
     * @param ids    ID集合
     * @return
     */
    void updateStatusBatch(String status, List<Long> ids);

    /**
     * 根据ID更新状态
     *
     * @param status 状态
     * @param id     ID
     * @return
     */
    void updateStatusById(String status, Long id);

    /**
     * 根据ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param ids        主表ID
     */
    void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids);

    /**
     * 批量根据协议编码查询主表数据
     * @param codes
     * @return
     */

    List<ReceiptPaymentAgreementVO> selectByCodes(List<String> codes);

}
