package com.elitesland.fin.entity.limitadjustorder;

import com.elitesland.fin.domain.entity.base.BaseWorkflowModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/2/25 9:56
 */
@Entity
@org.hibernate.annotations.Table(appliesTo = "limit_adjust_order", comment = "额度调整单")
@Table(name="limit_adjust_order")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0")
public class LimitAdjustOrderDO extends BaseWorkflowModel {

    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '单号'")
    private String docNo;

    @Column(name = "doc_state", columnDefinition = "varchar(32) comment '状态'")
    private String docState;

    @Column(name = "credit_type", columnDefinition = "varchar(32) comment '授信类型'")
    private String creditType;

    @Column(name = "adjust_type", columnDefinition = "varchar(32) comment '调整类型'")
    private String adjustType;

    @Column(name = "expire_time", columnDefinition = "datetime(6) comment '效期至'")
    private LocalDateTime expireTime;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '部门编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '部门名称'")
    private String buName;

    @Column(name = "product_line", columnDefinition = "varchar(32) comment '产品线'")
    private String productLine;

    @Column(name = "sale_user", columnDefinition = "varchar(32) comment '业务员'")
    private String saleUser;

    @Column(name = "object_type", columnDefinition = "varchar(32) comment '对象类型 客户/客户组'")
    private String objectType;

    @Column(name = "object_name", columnDefinition = "varchar(32) comment '对象名称 客户/客户组名称'")
    private String objectName;

    @Column(name = "credit_account_code", columnDefinition = "varchar(32) comment '信用账户编码'")
    private String creditAccountCode;

    @Column(name = "credit_account_name", columnDefinition = "varchar(32) comment '信用账户名称'")
    private String creditAccountName;

    @Column(name = "adjust_limit", columnDefinition = "decimal(18,8) comment '调整额度'")
    private BigDecimal adjustLimit;

    @Column(name = "adjust_reason", columnDefinition = "varchar(255) comment '调整原因'")
    private String adjustReason;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_time", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditTime;

    @Column(name = "audit_reject_reason", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejectReason;

    @Column(name = "file_code", columnDefinition = "varchar(256) comment '附件编码'")
    private String fileCode;

    @Column(name = "effective_time", columnDefinition = "datetime(6) comment '效期起'")
    private LocalDateTime effectiveTime;

}
