package com.elitesland.fin.infr.factory.payorder;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/3/17 9:07
 */
@RequiredArgsConstructor
@Component
public class PayOrderFactory {
    private final PayOrderRepoProc payOrderRepoProc;

    private final PayOrderDtlRepoProc payOrderDtlRepoProc;

    public PagingVO<PayOrderDTO> payOrderPage(PayOrderPageParam param) {
        if (!StringUtils.isEmpty(param.getSourceNoDtl())) {
            //查询出所有付款单ID
            List<Long> ids = payOrderDtlRepoProc.queryBySourceNo(param.getSourceNoDtl()).stream().distinct().collect(Collectors.toList());
            //如果为空直接返回空
            if (CollUtil.isEmpty(ids)) {
                return new PagingVO<>(0,new ArrayList<>());
            } else {
                //不为空加上主键ID作为查询条件
                return payOrderRepoProc.page(param, ids);
            }
        } else {
            //为空走普通查询
            return payOrderRepoProc.page(param, null);
        }
    }
    public PagingVO<PayOrderDTO> writeoffPage(PayOrderPageParam param) {
        //查询出所有付款单ID
        List<Long> ids = payOrderDtlRepoProc.queryUnverBySourceNo(param).stream().distinct().collect(Collectors.toList());
        //如果为空直接返回空
        if (CollUtil.isEmpty(ids)) {
            return new PagingVO<>(0,new ArrayList<>());
        } else {
            //不为空加上主键ID作为查询条件
            return payOrderRepoProc.page(param, ids);
        }
    }
}
