package com.elitesland.fin.infr.repo.recorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:40
 */
@Component
@RequiredArgsConstructor
public class RecOrderDtlRepoProc {


    private final JPAQueryFactory jpaQueryFactory;

    private final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;


    public List<Long> queryBySourceNo(String sourceNo) {
        return jpaQueryFactory.select(qRecOrderDtlDO.masId)
                .where(qRecOrderDtlDO.sourceNo.like("%" + sourceNo + "%"))
                .from(qRecOrderDtlDO)
                .fetch();
    }

    /**
     * condition,0:取0值，1：正值，-1：取负值，2：大于等于0，-2：小于等于0，3：所有值，4不等于0
     * @param sourceNo
     * @return
     */
    public List<Long> queryUnverBySourceNo(RecOrderPageParam param) {
        String sourceNo=param.getSourceNoDtl();
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(sourceNo)) {
            predicates.add(qRecOrderDtlDO.sourceNo.like("%" + sourceNo + "%"));
        }
        predicates.add(qRecOrderDtlDO.deleteFlag.eq(0));
        if(StringUtils.isNotBlank(param.getWriteOfFAmtCon())){
            if(FinConstant.WRITE_OFF_AMT_CON_GT.equals(param.getWriteOfFAmtCon())){
                predicates.add(qRecOrderDtlDO.unVerAmt.gt(BigDecimal.ZERO));
            }else if(FinConstant.WRITE_OFF_AMT_CON_LT.equals(param.getWriteOfFAmtCon())){
                predicates.add(qRecOrderDtlDO.unVerAmt.lt(BigDecimal.ZERO));
            }
        }else{
            predicates.add(qRecOrderDtlDO.unVerAmt.ne(BigDecimal.ZERO));
        }
        return jpaQueryFactory.select(qRecOrderDtlDO.masId)
                .where(ExpressionUtils.allOf(predicates))
                .from(qRecOrderDtlDO)
                .fetch();
    }
    public void deleteByMasId(List<Long> masId) {
        jpaQueryFactory.delete(qRecOrderDtlDO)
                .where(qRecOrderDtlDO.masId.in(masId))
                .execute();
    }

    public PagingVO<RecOrderDtlDTO> page(RecOrderDtlPageParam pageParam) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (pageParam.getMisId() != null) {
            predicates.add(qRecOrderDtlDO.masId.eq(pageParam.getMisId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIds())) {
            predicates.add(qRecOrderDtlDO.masId.in(pageParam.getMasIds()));
        }
        JPAQuery<RecOrderDtlDTO> query = select(RecOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qRecOrderDtlDO);
        return PagingVO.<RecOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
    @SysCodeProc
    public List<RecOrderDtlDTO> queryByMasId(Long masId) {
        return select(RecOrderDtlDTO.class)
                .where(qRecOrderDtlDO.masId.in(masId))
                .fetch();
    }
    public List<RecOrderDtlDTO> queryByMasIds(List<Long> masIds) {
        return select(RecOrderDtlDTO.class)
                .where(qRecOrderDtlDO.masId.in(masIds))
                .fetch();
    }
    public void deleteByMasIds(List<Long> masIds) {
        jpaQueryFactory.delete(qRecOrderDtlDO)
                .where(qRecOrderDtlDO.masId.in(masIds))
                .execute();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qRecOrderDtlDO.id,
                qRecOrderDtlDO.masId,
                qRecOrderDtlDO.recType,
                qRecOrderDtlDO.recKind,
                qRecOrderDtlDO.recBank,
                qRecOrderDtlDO.recAccount,
                qRecOrderDtlDO.recFlow,
                qRecOrderDtlDO.sourceNo,
                qRecOrderDtlDO.sourceId,
                qRecOrderDtlDO.sourceLine,
                qRecOrderDtlDO.sourceLineId,
                qRecOrderDtlDO.realRecAmt,
                qRecOrderDtlDO.realRecCurAmt,
                qRecOrderDtlDO.taxAmt,
                qRecOrderDtlDO.taxRate,
                qRecOrderDtlDO.totalAmt,
                qRecOrderDtlDO.totalCurAmt,
                qRecOrderDtlDO.expensesType,
                qRecOrderDtlDO.remark,
                qRecOrderDtlDO.taxCurAmt,
                qRecOrderDtlDO.relateId,
                qRecOrderDtlDO.verAmt,
                qRecOrderDtlDO.unVerAmt,
                qRecOrderDtlDO.applyVerAmTing
                )
        ).from(qRecOrderDtlDO);
    }

    public void updateByMasId(SendPayReq payReq, Long id) {

        jpaQueryFactory.update(qRecOrderDtlDO)
                .set(qRecOrderDtlDO.recBank,payReq.getRecBank())
                .set(qRecOrderDtlDO.recType,payReq.getRecType())
                .set(qRecOrderDtlDO.recAccount,payReq.getRecAcc())
                .where(qRecOrderDtlDO.masId.in(id))
                .execute();

    }
}
