package com.elitesland.fin.provider.aporder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.param.aporder.ApOrderPageRpcParam;
import com.elitesland.fin.param.aporder.ApOrderRpcParam;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.aporder
 * @date 2022/5/17 16:07
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ApOrderRpcService.PATH)
public class ApOrderRpcServiceImpl implements ApOrderRpcService {


    public final ApOrderDomainService apOrderDomainService;


    @Override
    public ApiResult<Long> save(ApOrderRpcParam apOrderRpcParam) {
        if (StringUtils.isBlank(apOrderRpcParam.getCreateMode())) {
            throw new BusinessException("单据来源 createMode不能为空");
        }
        // DTO转
        ApOrder apOrder = ApOrderConvert.INSTANCE.convertRpc(apOrderRpcParam);
        Long resId = apOrderDomainService.save(apOrder);
        return ApiResult.ok(resId);
    }

    @Override
    public ApiResult<ApOrderRpcDTO> queryApOrderById(Long id) {

        ApOrderDTO apOrderDTO = apOrderDomainService.getApOrderAndDtl(id);
        return ApiResult.ok(ApOrderConvert.INSTANCE.apOrderDTO2ApOrderRpcDTO(apOrderDTO));
    }

    @Override
    public ApiResult<PagingVO<ApOrderRpcDTO>> page(ApOrderPageRpcParam apOrderPageRpcParam) {
        ApOrderPageParam apOrderPageParam = ApOrderConvert.INSTANCE.convertPageParamRpc(apOrderPageRpcParam);
        PagingVO<ApOrderRpcDTO> res = ApOrderConvert.INSTANCE.convertRpcDto(apOrderDomainService.page(apOrderPageParam));
        return ApiResult.ok(res);
    }

}
