package com.elitesland.fin.provider.inputinv;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.fin.domain.entity.inputinv.InputInv;
import com.elitesland.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.fin.dto.inputinv.InputInvRpcDTO;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.fin.param.inputinv.InputInvRpcParam;
import com.elitesland.fin.service.inputinv.InputInvRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.inputinv
 * @date 2022/5/20 10:23
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + InputInvRpcService.PATH)
public class InputInvRpcServiceImpl implements InputInvRpcService {

    public final InputInvDomainService inputInvDomainService;


    @Override
    public Long save(InputInvRpcParam inputInvRpcParam) {
        if (CharSequenceUtil.isBlank(inputInvRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        InputInv inputInv = InputInvConvert.INSTANCE.convertRpc(inputInvRpcParam);
        Long resId = inputInvDomainService.save(inputInv);
        return resId;
    }

    @Override
    public ApiResult<InputInvRpcDTO> queryInputInvById(Long id) {

        InputInvDTO inputInvDTO = inputInvDomainService.queryById(id, true);
        return ApiResult.ok(InputInvConvert.INSTANCE.inputInvDTO2InputInvRpcDTO(inputInvDTO));
    }
}
