package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccountPeriodLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountPeriodLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSobAccountPeriodParam;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSobAccountPeriodDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinSobAccountPeriodRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QFinSobAccountPeriodDO qFinSobAccountPeriodDO = QFinSobAccountPeriodDO.finSobAccountPeriodDO;

    public List<FinSobAccountPeriodDTO> query(FinSobAccountPeriodParam finSobAccountPeriodParam) {

        Predicate where = whereEq(finSobAccountPeriodParam);
        JPAQuery<FinSobAccountPeriodDTO> query = select(FinSobAccountPeriodDTO.class).where(ExpressionUtils.allOf(where));

        return query.fetch();
    }


    public PagingVO<FinSobAccountPeriodDTO> page(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Predicate where = where(finSobAccountPeriodParam);
        JPAQuery<FinSobAccountPeriodDTO> query = select(FinSobAccountPeriodDTO.class).where(ExpressionUtils.allOf(where));

        finSobAccountPeriodParam.setPaging(query);
        finSobAccountPeriodParam.fillOrders(query, qFinSobAccountPeriodDO);

        List<FinSobAccountPeriodDTO> finAccountPeriodDTOList = query.fetch();

        return PagingVO.<FinSobAccountPeriodDTO>builder()
                .total(query.fetchCount())
                .records(finAccountPeriodDTOList)
                .build();
    }

    private Predicate where(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        LocalDateTime start=null;
        LocalDateTime end=null;
        if(finSobAccountPeriodParam!=null&&StringUtils.isNotBlank(finSobAccountPeriodParam.getYear())){
            try{
                int i = Integer.parseInt(finSobAccountPeriodParam.getYear());
                if(i<1000 || i>9999){
                    throw new BusinessException("请输入4位有效年");
                }
            }catch (NumberFormatException e){
                throw new BusinessException("请输入4位有效年");
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            start=LocalDateTime.parse(finSobAccountPeriodParam.getYear()+"-01-01 00:00:00",formatter);
            end=LocalDateTime.parse(finSobAccountPeriodParam.getYear()+"-12-31 23:59:59",formatter);
        }
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finSobAccountPeriodParam.getId() != null, qFinSobAccountPeriodDO.id, finSobAccountPeriodParam.getId())
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getSobCode()), qFinSobAccountPeriodDO.sobCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getSobCode()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getSobName()), qFinSobAccountPeriodDO.sobName, StringUtil.buildLikeString(finSobAccountPeriodParam.getSobName()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getAccountPeriodCode()), qFinSobAccountPeriodDO.accountPeriodCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getAccountPeriodCode()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getAccountPeriodName()), qFinSobAccountPeriodDO.accountPeriodName, StringUtil.buildLikeString(finSobAccountPeriodParam.getAccountPeriodName()))
                .andEq(Objects.nonNull(finSobAccountPeriodParam.getOuId()), qFinSobAccountPeriodDO.ouId, finSobAccountPeriodParam.getOuId())
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getOuCode()), qFinSobAccountPeriodDO.ouCode, StringUtil.buildLikeString(finSobAccountPeriodParam.getOuCode()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getOuName()), qFinSobAccountPeriodDO.ouName, StringUtil.buildLikeString(finSobAccountPeriodParam.getOuName()))
                .andLike(StringUtils.isNotEmpty(finSobAccountPeriodParam.getPeriodStyle()), qFinSobAccountPeriodDO.periodStyle, StringUtil.buildLikeString(finSobAccountPeriodParam.getPeriodStyle()))
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getStatus()), qFinSobAccountPeriodDO.status, finSobAccountPeriodParam.getStatus())
                .andGoe(start != null, qFinSobAccountPeriodDO.activeStartTime, start)
                .andLoe(end != null, qFinSobAccountPeriodDO.activeEndTime, end)
                .build();
    }

    private Predicate whereEq(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finSobAccountPeriodParam.getId() != null, qFinSobAccountPeriodDO.id, finSobAccountPeriodParam.getId())
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getSobCode()), qFinSobAccountPeriodDO.sobCode, finSobAccountPeriodParam.getSobCode())
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getAccountPeriodCode()), qFinSobAccountPeriodDO.accountPeriodCode, finSobAccountPeriodParam.getAccountPeriodCode())
                .andEq(StringUtils.isNotEmpty(finSobAccountPeriodParam.getOuCode()), qFinSobAccountPeriodDO.ouCode, finSobAccountPeriodParam.getOuCode())
                .andEq(Objects.nonNull(finSobAccountPeriodParam.getOuId()), qFinSobAccountPeriodDO.ouId, finSobAccountPeriodParam.getOuId())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinSobAccountPeriodDO.id,
                qFinSobAccountPeriodDO.accountPeriodCode,
                qFinSobAccountPeriodDO.accountPeriodName,
                qFinSobAccountPeriodDO.status,
                qFinSobAccountPeriodDO.activeStartTime,
                qFinSobAccountPeriodDO.activeEndTime,
                qFinSobAccountPeriodDO.sobCode,
                qFinSobAccountPeriodDO.sobName,
                qFinSobAccountPeriodDO.ouId,
                qFinSobAccountPeriodDO.ouCode,
                qFinSobAccountPeriodDO.ouName,
                qFinSobAccountPeriodDO.periodStyle,


                qFinSobAccountPeriodDO.createTime,
                qFinSobAccountPeriodDO.creator,
                qFinSobAccountPeriodDO.modifyTime,
                qFinSobAccountPeriodDO.updater
        )).from(qFinSobAccountPeriodDO);
    }
}
