package com.elitesland.fin.repo.writeoff;

import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArHeadDO;
import com.elitesland.fin.domain.entity.writeoff.QFinArRecVerApplyArHeadDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
@RequiredArgsConstructor
public class FinArRecVerApplyArHeadRepoProc {

    private final QFinArRecVerApplyArHeadDO QDO = QFinArRecVerApplyArHeadDO.finArRecVerApplyArHeadDO;

    private final JPAQueryFactory jpaQueryFactory;

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinArRecVerApplyArHeadDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .fetch();
    }

	public List<FinArRecVerApplyArHeadDO> listByIds(Collection<Long> ids) {
		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(QDO.id.in(ids))
				.fetch();
	}
}
