package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArDO;
import com.elitesland.fin.domain.entity.writeoff.QFinArRecVerApplyArDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinArRecVerApplyArRepoProc extends BaseRepoProc<FinArRecVerApplyArDO> {

    private static final QFinArRecVerApplyArDO QDO = QFinArRecVerApplyArDO.finArRecVerApplyArDO;

    protected FinArRecVerApplyArRepoProc() {
        super(QDO);
    }

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinArRecVerApplyArDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .orderBy(QDO.verAmt.desc())
                .fetch();
    }

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	public List<FinArRecVerApplyArVO> listByOutArDocNoOrDId(FinArRecVerApplyQuery applyQuery) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// 第三方应收单号
		if(StrUtil.isNotEmpty(applyQuery.getOutArDocNo())){
			predicate = ExpressionUtils.and(
					predicate,QDO.outArDocNo.eq(applyQuery.getOutArDocNo())
			);
		}

		// 第三方应收单明细ID
		if(StrUtil.isNotEmpty(applyQuery.getOutArDId())){
			predicate = ExpressionUtils.and(
					predicate,QDO.outArDId.eq(applyQuery.getOutArDId())
			);
		}

		return jpaQueryFactory.select(Projections.bean(
						FinArRecVerApplyArVO.class,
						QDO.id,
						QDO.masId
				))
				.from(QDO)
				.where(predicate)
				.fetch();
	}

	/**
	 * 根据条件查询核销应收单明细
	 * @param query
	 * @return
	 */
	public List<FinArRecVerApplyArDO> listByQuery(FinArRecVerApplyArQuery query) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// id
		if(CollUtil.isNotEmpty(query.getIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.id.in(query.getIds())
			);
		}

		// masIds
		if(CollUtil.isNotEmpty(query.getMasIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.masId.in(query.getMasIds())
			);
		}

		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.orderBy(QDO.verAmt.desc())
				.fetch();
	}
}
