package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecDO;
import com.elitesland.fin.domain.entity.writeoff.QFinArRecVerApplyRecDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinArRecVerApplyRecRepoProc extends BaseRepoProc<FinArRecVerApplyRecDO> {

    private static final QFinArRecVerApplyRecDO QDO = QFinArRecVerApplyRecDO.finArRecVerApplyRecDO;

    protected FinArRecVerApplyRecRepoProc() {
        super(QDO);
    }

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinArRecVerApplyRecDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .orderBy(QDO.verAmt.desc())
                .fetch();
    }

	/**
	 * 通过第三方收款单号或者明细ID查询
	 * @param applyQuery
	 * @return
	 */
	public List<FinArRecVerApplyRecVO> listByOutRecDocNoOrDId(FinArRecVerApplyQuery applyQuery) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// 第三方收款单号
		if(StrUtil.isNotEmpty(applyQuery.getOutRecDocNo())){
			predicate = ExpressionUtils.and(
					predicate,QDO.outRecDocNo.eq(applyQuery.getOutRecDocNo())
			);
		}

		// 第三方收款单明细ID
		if(StrUtil.isNotEmpty(applyQuery.getOutRecDId())){
			predicate = ExpressionUtils.and(
					predicate,QDO.outRecDId.eq(applyQuery.getOutRecDId())
			);
		}

		return jpaQueryFactory.select(Projections.bean(
						FinArRecVerApplyRecVO.class,
						QDO.id,
						QDO.masId
				))
				.from(QDO)
				.where(predicate)
				.fetch();
	}

	/**
	 * 根据条件查询核销收款单明细
	 * @param query
	 * @return
	 */
	public List<FinArRecVerApplyRecDO> listByQuery(FinArRecVerApplyRecQuery query) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// id
		if(CollUtil.isNotEmpty(query.getIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.id.in(query.getIds())
			);
		}

		// masIds
		if(CollUtil.isNotEmpty(query.getMasIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.masId.in(query.getMasIds())
			);
		}

		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.orderBy(QDO.verAmt.desc())
				.fetch();
	}
}
