package com.elitesland.fin.rpc.pur;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;
import com.elitesland.pur.provider.PurAccountProvider;

import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Supplier;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/3/8 3:01 下午
 * @version:v1.0
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class RmiPurRpcServiceImpl implements RmiPurRpcService {

    private final PurAccountProvider purAccountProvider;

    /**
     * 异常检查
     *
     * @param supplier
     * @return
     */
    private Object checkError(Supplier<ApiResult> supplier) {
        try {
            ApiResult apiResult = supplier.get();
            if (!apiResult.isSuccess()) {
                log.error("采购域调用异常:{}", apiResult.getMsg());
                throw new BusinessException(apiResult.getMsg());
            }
            return apiResult.getData();
        } catch (Exception e) {
            log.error("采购域调用异常：", e);
            throw new BusinessException("采购域报错：", e);

        }
    }

    @Override
    public void batchUpdateDocStatus(PurAccountDTO purAccountDTO) {
        this.checkError(() -> purAccountProvider.batchUpdateDocStatus(purAccountDTO));
    }

    @Override
    public void addInvoiceQty(List<PurAccountCheckQtyDTO> param) {
        log.info("调用采购域-回写采购对账单开票数量接口开始，时间：{}，入参：{}", LocalDateTime.now(), JSON.toJSONString(param));
        try {
            ApiResult<Void> apiResult = purAccountProvider.addInvoiceQty(param);
            log.info("调用采购域-回写采购对账单开票数量接口结束，时间：{}，出参：{}", LocalDateTime.now(), JSON.toJSONString(apiResult));
            if (apiResult.isFailed()) {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("purAccountCheckAddInvoiceQty error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用采购域-回写采购对账单开票数量接口失败：" + e);
        }
    }
}
