/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.InvSobAccountPeriodConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.InvSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.param.accountingengine.InvSobAccountPeriodParam;
import com.elitesland.fin.application.facade.vo.accountingengine.InvSobAccountPeriodVO;
import com.elitesland.fin.application.service.accountingengine.InvSobAccountPeriodService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookOuDO;
import com.elitesland.fin.domain.entity.accountingengine.InvSobAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.repo.accountingengine.InvSobAccountPeriodRepo;
import com.elitesland.fin.repo.accountingengine.InvSobAccountPeriodRepoProc;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvSobAccountPeriodServiceImpl
implements InvSobAccountPeriodService {
    private static final Logger log = LoggerFactory.getLogger(InvSobAccountPeriodServiceImpl.class);
    private final InvSobAccountPeriodRepo invSobAccountPeriodRepo;
    private final InvSobAccountPeriodRepoProc invSobAccountPeriodRepoProc;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinAccountPeriodRepoProc finAccountPeriodRepoProc;
    private final FinAccountPeriodLineRepo finAccountPeriodLineRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;

    @Override
    @SysCodeProc
    public PagingVO<InvSobAccountPeriodVO> page(InvSobAccountPeriodParam invSobAccountPeriodParam) {
        return InvSobAccountPeriodConvert.INSTANCE.DTOToVO(this.invSobAccountPeriodRepoProc.page(invSobAccountPeriodParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generate(InvSobAccountPeriodParam invSobAccountPeriodParam) {
        this.checkGenerateParam(invSobAccountPeriodParam);
        List<InvSobAccountPeriodDO> invSobAccountPeriodDOList = this.buildGenerateList(invSobAccountPeriodParam);
        List<InvSobAccountPeriodDTO> invSobAccountPeriodDTOList = this.invSobAccountPeriodRepoProc.query(invSobAccountPeriodParam);
        invSobAccountPeriodDOList = invSobAccountPeriodDOList.stream().filter(invSobAccountPeriodDO -> !invSobAccountPeriodDTOList.stream().filter(invSobAccountPeriodDTO -> invSobAccountPeriodDTO.getSobCode().equals(invSobAccountPeriodDO.getSobCode()) && invSobAccountPeriodDTO.getAccountPeriodCode().equals(invSobAccountPeriodDO.getAccountPeriodCode()) && invSobAccountPeriodDTO.getOuCode().equals(invSobAccountPeriodDO.getOuCode()) && invSobAccountPeriodDTO.getActiveStartTime().equals(invSobAccountPeriodDO.getActiveStartTime()) && invSobAccountPeriodDTO.getActiveEndTime().equals(invSobAccountPeriodDO.getActiveEndTime())).findFirst().isPresent()).collect(Collectors.toList());
        invSobAccountPeriodDOList.stream().forEach(invSobAccountPeriodDO -> invSobAccountPeriodDO.setStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode()));
        this.invSobAccountPeriodRepo.saveAll(invSobAccountPeriodDOList);
    }

    private void checkGenerateParam(InvSobAccountPeriodParam invSobAccountPeriodParam) {
        Assert.notEmpty((CharSequence)invSobAccountPeriodParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)invSobAccountPeriodParam.getYear(), (String)"\u5e74\u4efd\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty(invSobAccountPeriodParam.getOuCodeList(), (String)"\u516c\u53f8\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
    }

    private List<InvSobAccountPeriodDO> buildGenerateList(InvSobAccountPeriodParam invSobAccountPeriodParam) {
        FinSetOfBookDO finSetOfBookDO = this.finSetOfBookRepoProc.findBySobCode(invSobAccountPeriodParam.getSobCode());
        Assert.notNull((Object)"\u8d26\u5957\u4e0d\u5b58\u5728");
        FinAccountPeriodDO finAccountPeriodDO = this.finAccountPeriodRepoProc.findByAccountPeriodCode(finSetOfBookDO.getAccountPeriodCode());
        Assert.notNull((Object)"\u6761\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728");
        List<FinAccountPeriodLineDO> finAccountPeriodLineDOList = this.finAccountPeriodLineRepo.findAllByMasIdIn(Lists.newArrayList((Object[])new Long[]{finAccountPeriodDO.getId()}));
        List<FinSetOfBookOuDO> finSetOfBookOuDOList = this.finSetOfBookOuRepo.findAllByMasIdIn(Lists.newArrayList((Object[])new Long[]{finSetOfBookDO.getId()}));
        List<String> ouCodeList = invSobAccountPeriodParam.getOuCodeList();
        List<InvSobAccountPeriodDO> invSobAccountPeriodDOList = ouCodeList.stream().flatMap(ouCode -> finAccountPeriodLineDOList.stream().filter(finAccountPeriodLineDO -> invSobAccountPeriodParam.getYear().equals(finAccountPeriodLineDO.getYear())).map(finAccountPeriodLineDO -> {
            InvSobAccountPeriodDO invSobAccountPeriodDO = new InvSobAccountPeriodDO();
            invSobAccountPeriodDO.setSobCode(finSetOfBookDO.getSobCode());
            invSobAccountPeriodDO.setSobName(finSetOfBookDO.getSobName());
            invSobAccountPeriodDO.setAccountPeriodCode(finAccountPeriodDO.getAccountPeriodCode());
            invSobAccountPeriodDO.setAccountPeriodName(finAccountPeriodDO.getAccountPeriodName());
            invSobAccountPeriodDO.setOuCode((String)ouCode);
            FinSetOfBookOuDO finSetOfBookOuDOResult = finSetOfBookOuDOList.stream().filter(finSetOfBookOuDO -> finSetOfBookOuDO.getOuCode().equals(ouCode)).findFirst().orElse(null);
            Assert.notNull((Object)finSetOfBookOuDOResult, (String)"\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            invSobAccountPeriodDO.setOuName(finSetOfBookOuDOResult.getOuName());
            invSobAccountPeriodDO.setPeriodStyle(finAccountPeriodLineDO.getPeriodStyle());
            invSobAccountPeriodDO.setStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_NOT_OPEN.getValueCode());
            invSobAccountPeriodDO.setActiveStartTime(finAccountPeriodLineDO.getActiveStartTime());
            invSobAccountPeriodDO.setActiveEndTime(finAccountPeriodLineDO.getActiveEndTime());
            return invSobAccountPeriodDO;
        })).collect(Collectors.toList());
        return invSobAccountPeriodDOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void openOrClose(InvSobAccountPeriodParam invSobAccountPeriodParam) {
        this.checkEnableOrDisableParam(invSobAccountPeriodParam);
        List invSobAccountPeriodDOList = this.invSobAccountPeriodRepo.findAllById(invSobAccountPeriodParam.getIds());
        invSobAccountPeriodDOList.stream().forEach(item -> {
            if (StrUtil.equals((CharSequence)item.getStatus(), (CharSequence)UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_CLOSED.getValueCode()) && StrUtil.equals((CharSequence)invSobAccountPeriodParam.getStatus(), (CharSequence)UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode())) {
                throw new BusinessException("\u5df2\u5173\u95ed\u7684\u4e0d\u80fd\u518d\u6253\u5f00");
            }
            Assert.isFalse((boolean)invSobAccountPeriodParam.getStatus().equals(item.getStatus()), (String)"\u5df2\u6253\u5f00/\u5173\u95ed", (Object[])new Object[0]);
        });
        invSobAccountPeriodDOList.stream().forEach(item -> item.setStatus(invSobAccountPeriodParam.getStatus()));
    }

    private void checkEnableOrDisableParam(InvSobAccountPeriodParam invSobAccountPeriodParam) {
        Assert.notEmpty(invSobAccountPeriodParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)invSobAccountPeriodParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    public InvSobAccountPeriodServiceImpl(InvSobAccountPeriodRepo invSobAccountPeriodRepo, InvSobAccountPeriodRepoProc invSobAccountPeriodRepoProc, FinSetOfBookRepoProc finSetOfBookRepoProc, FinAccountPeriodRepoProc finAccountPeriodRepoProc, FinAccountPeriodLineRepo finAccountPeriodLineRepo, FinSetOfBookOuRepo finSetOfBookOuRepo) {
        this.invSobAccountPeriodRepo = invSobAccountPeriodRepo;
        this.invSobAccountPeriodRepoProc = invSobAccountPeriodRepoProc;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finAccountPeriodRepoProc = finAccountPeriodRepoProc;
        this.finAccountPeriodLineRepo = finAccountPeriodLineRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
    }
}

