/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountreport.AccountReportConvert;
import com.elitesland.fin.application.facade.param.accountreport.AccountReportPageParam;
import com.elitesland.fin.application.facade.vo.accountreport.AccountReportVO;
import com.elitesland.fin.application.service.accountreport.AccountReportService;
import com.elitesland.fin.application.service.excel.entity.AccountReportExportEntity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountReportExportServiceImpl
implements DataExport<AccountReportExportEntity, AccountReportPageParam> {
    private static final Logger log = LoggerFactory.getLogger(AccountReportExportServiceImpl.class);
    private final AccountReportService accountReportService;
    static final ThreadLocal<BigDecimal> availableAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> unremittedAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountUsedLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountOccupancyLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountAvailableLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> storageAccountAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> storageAccountOccupancyAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> storageAccountAvailableAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> rebateAccountAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> rebateAccountOccupancyAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> rebateAccountAvailableAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);

    public String getTmplCode() {
        return "fin_account_report_export";
    }

    public PagingVO<AccountReportExportEntity> executeExport(AccountReportPageParam queryParam) {
        PagingVO<AccountReportVO> page = this.accountReportService.page(queryParam);
        PagingVO<AccountReportExportEntity> accountReportExportEntityPagingVO = AccountReportConvert.INSTANCE.VO2ExportEntity(page);
        List records = accountReportExportEntityPagingVO.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return accountReportExportEntityPagingVO;
        }
        for (AccountReportExportEntity item : records) {
            availableAmount.set(availableAmount.get().add(item.getAvailableAmount()));
            unremittedAmount.set(unremittedAmount.get().add(item.getUnremittedAmount()));
            creditAccountLimit.set(creditAccountLimit.get().add(item.getCreditAccountLimit()));
            creditAccountUsedLimit.set(creditAccountUsedLimit.get().add(item.getCreditAccountUsedLimit()));
            creditAccountOccupancyLimit.set(creditAccountOccupancyLimit.get().add(item.getCreditAccountOccupancyLimit()));
            creditAccountAvailableLimit.set(creditAccountAvailableLimit.get().add(item.getCreditAccountAvailableLimit()));
            storageAccountAmount.set(storageAccountAmount.get().add(item.getStorageAccountAmount()));
            storageAccountOccupancyAmount.set(storageAccountOccupancyAmount.get().add(item.getStorageAccountOccupancyAmount()));
            storageAccountAvailableAmount.set(storageAccountAvailableAmount.get().add(item.getStorageAccountAvailableAmount()));
            rebateAccountAmount.set(rebateAccountAmount.get().add(item.getRebateAccountAmount()));
            rebateAccountOccupancyAmount.set(rebateAccountOccupancyAmount.get().add(item.getRebateAccountOccupancyAmount()));
            rebateAccountAvailableAmount.set(rebateAccountAvailableAmount.get().add(item.getRebateAccountAvailableAmount()));
        }
        if ((long)(queryParam.getCurrent() * queryParam.getSize() + accountReportExportEntityPagingVO.getRecords().size()) == accountReportExportEntityPagingVO.getTotal()) {
            AccountReportExportEntity accountReportExportEntity = new AccountReportExportEntity();
            accountReportExportEntity.setAvailableAmount(availableAmount.get());
            accountReportExportEntity.setUnremittedAmount(unremittedAmount.get());
            accountReportExportEntity.setCreditAccountLimit(creditAccountLimit.get());
            accountReportExportEntity.setCreditAccountUsedLimit(creditAccountUsedLimit.get());
            accountReportExportEntity.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit.get());
            accountReportExportEntity.setCreditAccountAvailableLimit(creditAccountAvailableLimit.get());
            accountReportExportEntity.setStorageAccountAmount(storageAccountAmount.get());
            accountReportExportEntity.setStorageAccountOccupancyAmount(storageAccountOccupancyAmount.get());
            accountReportExportEntity.setStorageAccountAvailableAmount(storageAccountAvailableAmount.get());
            accountReportExportEntity.setRebateAccountAmount(rebateAccountAmount.get());
            accountReportExportEntity.setRebateAccountOccupancyAmount(rebateAccountOccupancyAmount.get());
            accountReportExportEntity.setRebateAccountAvailableAmount(rebateAccountAvailableAmount.get());
            records.add(accountReportExportEntity);
            accountReportExportEntityPagingVO.setTotal(accountReportExportEntityPagingVO.getTotal() + 1L);
            availableAmount.remove();
            unremittedAmount.remove();
            creditAccountLimit.remove();
            creditAccountUsedLimit.remove();
            creditAccountOccupancyLimit.remove();
            creditAccountAvailableLimit.remove();
            storageAccountAmount.remove();
            storageAccountOccupancyAmount.remove();
            storageAccountAvailableAmount.remove();
            rebateAccountAmount.remove();
            rebateAccountOccupancyAmount.remove();
            rebateAccountAvailableAmount.remove();
        }
        return accountReportExportEntityPagingVO;
    }

    public AccountReportExportServiceImpl(AccountReportService accountReportService) {
        this.accountReportService = accountReportService;
    }
}

