/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flowrepair;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.dto.flowrepair.CreditAccountFlowRepairHandle20DTO;
import com.elitesland.fin.application.facade.dto.flowrepair.CreditAccountFlowRepairHandleDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSnapshotParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.facade.vo.flowrepair.CreditAccountFlowRepairVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flowrepair.CreditAccountFlowRepairService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountSnapshotDO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.flowrepair.CreditAccountFlowRepairDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountSnapshotRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.fin.repo.flowrepair.CreditAccountFlowRepairRepo;
import com.elitesland.fin.repo.flowrepair.CreditAccountFlowRepairRepoProc;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceContext;
import javax.persistence.StoredProcedureQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CreditAccountFlowRepairServiceImpl
implements CreditAccountFlowRepairService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountFlowRepairServiceImpl.class);
    @Autowired
    private CreditAccountFlowRepairRepo creditAccountFlowRepairRepo;
    @Autowired
    private CreditAccountFlowRepairRepoProc creditAccountFlowRepairRepoProc;
    @Autowired
    private CreditAccountFlowService creditAccountFlowService;
    @Autowired
    private CreditAccountFlowRepoProc creditAccountFlowRepoProc;
    @Autowired
    private CreditAccountFlowRepo creditAccountFlowRepo;
    @Autowired
    private CreditAccountRepoProc creditAccountRepoProc;
    @Autowired
    private CreditAccountSnapshotRepo creditAccountSnapshotRepo;
    @Autowired
    private CreditAccountService creditAccountService;
    private final RedissonClient redissonClient;
    @PersistenceContext
    private EntityManager entityManager;
    private final NamedParameterJdbcTemplate namedTemplate;
    private final TransactionTemplate transactionTemplate;

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountFlowRepairVO> page(CreditAccountFlowRepairPageParam pageParam) {
        PagingVO<CreditAccountFlowRepairVO> pagingVO = this.creditAccountFlowRepairRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(CreditAccountFlowRepairParam param) {
        if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode())) {
            this.saveFlowRepair10(param);
        } else if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_20.getValueCode())) {
            if (Objects.isNull(param.getId())) {
                this.saveFlowRepair20(param);
            } else {
                this.saveFlowRepair10(param);
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5339\u914d\u5230\u91cd\u7b97\u539f\u56e0!");
        }
    }

    private void saveFlowRepair10(CreditAccountFlowRepairParam param) {
        if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode())) {
            if (StringUtils.isBlank((CharSequence)param.getFlowNo())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (Objects.isNull(param.getActualAmount())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b9e\u9645\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
        }
        CreditAccountFlowVO flowVO = this.selectFlowByFlowNo(param.getFlowNo());
        if (Objects.isNull(param.getId())) {
            CreditAccountFlowRepairDO flowRepairDO = new CreditAccountFlowRepairDO();
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.creditAccountFlowRepairRepo.save((Object)flowRepairDO);
        } else {
            Optional flowRepairOptional = this.creditAccountFlowRepairRepo.findById(param.getId());
            if (flowRepairOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6761\u6d41\u6c34\u4fee\u590d\u6570\u636e!");
            }
            CreditAccountFlowRepairDO flowRepairDO = (CreditAccountFlowRepairDO)((Object)flowRepairOptional.get());
            if (!Objects.equals(flowRepairDO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8349\u7a3f\u72b6\u6001\u624d\u53ef\u4fee\u6539!");
            }
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.creditAccountFlowRepairRepo.save((Object)flowRepairDO);
        }
    }

    private void assembleFlowRepair(CreditAccountFlowRepairDO flowRepairDO, CreditAccountFlowRepairParam param, CreditAccountFlowVO flowVO) {
        if (StringUtils.isNotBlank((CharSequence)param.getFlowNo())) {
            flowRepairDO.setFlowNo(param.getFlowNo());
        }
        if (Objects.nonNull(param.getActualAmount())) {
            flowRepairDO.setActualAmount(param.getActualAmount());
        }
        flowRepairDO.setAmount(flowVO.getAmount());
        flowRepairDO.setOpenAccountEntityCode(flowVO.getObjectCode());
        flowRepairDO.setOpenAccountEntityName(flowVO.getObjectName());
        flowRepairDO.setAccountType(flowVO.getCreditAccountType());
        flowRepairDO.setAccountCode(flowVO.getCreditAccountCode());
        flowRepairDO.setAccountName(flowVO.getCreditAccountName());
        flowRepairDO.setSourceNo(flowVO.getSourceNo());
        flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)param.getRecalculationReason())) {
            flowRepairDO.setRecalculationReason(param.getRecalculationReason());
        }
        if (Objects.nonNull(param.getRecalculationDate())) {
            flowRepairDO.setRecalculationDate(param.getRecalculationDate());
        } else if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode()) && Objects.isNull(flowRepairDO.getRecalculationDate())) {
            flowRepairDO.setRecalculationDate(flowVO.getAuditDate());
        }
        SysUserDTO sysUserDTO = this.getUser();
        if (StringUtils.isNotBlank((CharSequence)param.getRecalculationUser())) {
            flowRepairDO.setRecalculationUser(param.getRecalculationUser());
        } else {
            flowRepairDO.setRecalculationUser(sysUserDTO.getPrettyName());
        }
        if (Objects.nonNull(param.getRecalculationUserId())) {
            flowRepairDO.setRecalculationUserId(param.getRecalculationUserId());
        } else {
            flowRepairDO.setRecalculationUserId(sysUserDTO.getId());
        }
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        if (Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u4e3a\u7a7a!");
        }
        return userDetails.getUser();
    }

    private CreditAccountFlowVO selectFlowByFlowNo(String flowNo) {
        if (StringUtils.isBlank((CharSequence)flowNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
        flowQueryParam.setFlowNo(flowNo);
        List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowService.selectListByQueryParam(flowQueryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u6d41\u6c34\u4fe1\u606f!");
        }
        if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u5b58\u5728\u591a\u6761\u6d41\u6c34\u4fe1\u606f!");
        }
        return flowVOList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        CreditAccountFlowRepairPageParam flowRepairPageParam = new CreditAccountFlowRepairPageParam();
        flowRepairPageParam.setIds(ids);
        List<CreditAccountFlowRepairVO> respVOList = this.creditAccountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List voList = respVOList.stream().filter(respVO -> !Objects.equals(respVO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            String checkResult = voList.stream().map(vo -> "\u6d41\u6c34\u53f7:" + vo.getFlowNo()).collect(Collectors.joining(";", "\u53ea\u6709\u8349\u7a3f\u53ef\u5220\u9664,[", "], \u8bf7\u68c0\u67e5"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        this.creditAccountFlowRepairRepoProc.updateDeleteFlagBatch(1, ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairRedo(CreditAccountFlowRepairRedoParam repairRedoParam) {
        CreditAccountFlowRepairPageParam flowRepairPageParam = new CreditAccountFlowRepairPageParam();
        flowRepairPageParam.setIds(repairRedoParam.getIds());
        flowRepairPageParam.setFlowNoList(repairRedoParam.getFlowNoList());
        flowRepairPageParam.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        List<CreditAccountFlowRepairVO> repairFlowVOList = this.creditAccountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(repairFlowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u7b26\u5408\u91cd\u7b97\u7684\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e!");
        }
        List flowNoCheckList = repairFlowVOList.stream().filter(repairParam -> !StringUtils.isBlank((CharSequence)repairParam.getFlowNo())).map(CreditAccountFlowRepairVO::getFlowNo).collect(Collectors.toMap(e -> e, e -> 1, (a, b) -> a + b)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(flowNoCheckList)) {
            String checkResult = flowNoCheckList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        List<String> repairFlowNoList = repairFlowVOList.stream().map(CreditAccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repairFlowNoList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u7b97\u7684\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e\u7684\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        ArrayList repairFlowNoCacheList = new ArrayList();
        repairFlowNoList.forEach(flowNo -> {
            if (StringUtils.isNotBlank((CharSequence)this.getFlowNoCache((String)flowNo))) {
                repairFlowNoCacheList.add(flowNo);
            } else {
                this.saveFlowNoCache((String)flowNo);
            }
        });
        if (CollectionUtils.isNotEmpty(repairFlowNoCacheList)) {
            String checkResult = repairFlowNoCacheList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u4fee\u590d\u91cd\u7b97\u4e2d,\u8bf7\u7a0d\u540e\u518d\u6b21\u91cd\u7b97!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        if (CollectionUtils.isNotEmpty(repairFlowVOList)) {
            List<CreditAccountFlowRepairVO> repairFlow20List;
            List<CreditAccountFlowRepairVO> repairFlow10List = repairFlowVOList.stream().filter(accountFlowRepairVO -> Objects.equals(accountFlowRepairVO.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(repairFlow10List)) {
                List<String> repairFlowNo10List = repairFlow10List.stream().map(CreditAccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                this.processingCalculation(repairFlow10List, repairFlowNo10List);
            }
            if (CollectionUtil.isNotEmpty(repairFlow20List = repairFlowVOList.stream().filter(accountFlowRepairVO -> Objects.equals(accountFlowRepairVO.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_20.getValueCode())).collect(Collectors.toList()))) {
                List<String> repairFlowNo20List = repairFlow20List.stream().map(CreditAccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                this.processingCalculation20(repairFlow20List, repairFlowNo20List);
            }
        }
    }

    @Override
    public void removeFlowNoCacheBatch(List<String> flowNoList) {
        flowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Override
    public void removeFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public String getFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            return (String)bucket.get();
        }
        return null;
    }

    @Override
    public void saveFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        bucket.set((Object)flowNo);
    }

    private void processingCalculation(List<CreditAccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        ArrayList accCodeList = new ArrayList();
        repairFlowVOList.forEach(flowRepairVO -> {
            this.transactionTemplate.setPropagationBehavior(3);
            String processingFlowNo = (String)this.transactionTemplate.execute(transactionStatus -> {
                String repairFlowNo = flowRepairVO.getFlowNo();
                try {
                    CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
                    flowQueryParam.setFlowNo(flowRepairVO.getFlowNo());
                    log.info("\u4fee\u590d\u91cd\u7b97\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowQueryParam)));
                    List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowService.selectListByQueryParam(flowQueryParam);
                    log.info("\u4fee\u590d\u91cd\u7b97\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
                    if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() == 1) {
                        if (Objects.nonNull(flowVOList.get(0))) {
                            CreditAccountFlowVO flowVO = flowVOList.get(0);
                            if (Objects.equals(flowVO.getCreditAccountType(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()) && FinConstant.CREDIT_ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                                this.repairFlow((CreditAccountFlowRepairVO)flowRepairVO, flowVO, accCodeList);
                            } else {
                                log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
                            }
                            if (accCodeList.contains(flowVO.getCreditAccountCode())) {
                                this.updateAccountAmt(Collections.singletonList(flowVO.getCreditAccountCode()), repairFlowNoList);
                                if (Objects.isNull(flowRepairVO.getRecalculationDate())) {
                                    flowRepairVO.setRecalculationDate(flowVO.getAuditDate());
                                }
                                this.updateCreditAccountSnapshot(Collections.singletonList(flowRepairVO), repairFlowNoList);
                            }
                        } else {
                            log.info("\u672a\u67e5\u8be2\u5230\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowRepairVO));
                        }
                    } else {
                        log.info("\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6709\u591a\u6761,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
                    }
                    this.removeFlowNoCache(flowRepairVO.getFlowNo());
                    return flowRepairVO.getFlowNo();
                }
                catch (Exception e) {
                    log.error("\u6d41\u6c34\u53f7(" + repairFlowNo + ")\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u4fee\u590d\u91cd\u7b97\u5931\u8d25!:{}", (Object)e.getMessage());
                    transactionStatus.setRollbackOnly();
                    repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7(" + repairFlowNo + ")\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u4fee\u590d\u91cd\u7b97\u5931\u8d25!");
                }
            });
        });
        repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void repairFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, List<String> accCodeList) {
        this.repairCurrentFlow(flowRepairVO, flowVO, accCodeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAccountAmt(List<String> accCodeList, List<String> repairFlowNoList) {
        accCodeList.forEach(accCode -> {
            CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
            flowQueryParam.setCreditAccountCode((String)accCode);
            CreditAccountFlowVO flowVO = this.creditAccountFlowRepoProc.selectPreviousRepairAmtByParam(flowQueryParam);
            CreditAccountDO accountDO = this.creditAccountRepoProc.findByCreditAccountCode((String)accCode);
            if (Objects.nonNull(flowVO) && Objects.nonNull((Object)accountDO)) {
                BigDecimal creditAccountLimit = flowVO.getCreditAccountLimit();
                BigDecimal creditAccountUsedLimit = flowVO.getCreditAccountUsedLimit();
                BigDecimal creditAccountOccupancyLimit = flowVO.getCreditAccountOccupancyLimit();
                BigDecimal creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
                accountDO.setCreditAccountLimit(creditAccountLimit);
                accountDO.setCreditAccountUsedLimit(creditAccountUsedLimit);
                accountDO.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
                accountDO.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
                this.creditAccountRepoProc.save((Serializable)((Object)accountDO));
            } else if (Objects.isNull((Object)accountDO)) {
                repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4fe1\u7528\u8d26\u6237(" + accCode + ")\u4fe1\u606f!");
            }
        });
    }

    public void repairCurrentFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, List<String> accCodeList) {
        CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairHandle(flowRepairVO, flowVO);
        if (Objects.nonNull(flowRepairHandleDTO)) {
            this.repairCalculationFlow(flowRepairHandleDTO, accCodeList);
            this.creditAccountFlowRepairRepoProc.updateAmountAndRepairStatusById(flowRepairHandleDTO.getAmount(), UdcEnum.FLOW_REPAIR_STATUS_FIXED.getValueCode(), flowRepairHandleDTO.getFlowRepairId());
            this.repairAfterFlow(flowRepairVO, flowVO, flowRepairHandleDTO, accCodeList);
        }
    }

    public void repairAfterFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, CreditAccountFlowRepairHandleDTO flowRepairCurrentHandleDTO, List<String> accCodeList) {
        List<CreditAccountFlowRepairHandleDTO> flowRepairHandleList = this.selectRepairAfterFlow(flowRepairVO, flowVO, flowRepairCurrentHandleDTO);
        if (CollectionUtils.isNotEmpty(flowRepairHandleList)) {
            flowRepairHandleList.forEach(flowRepairHandleDTO -> this.repairCalculationFlowAfter((CreditAccountFlowRepairHandleDTO)flowRepairHandleDTO, accCodeList));
        }
    }

    public List<CreditAccountFlowRepairHandleDTO> selectRepairAfterFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, CreditAccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        List<CreditAccountFlowVO> flowAfterList;
        int size = 500;
        int page = 1;
        ArrayList<CreditAccountFlowRepairHandleDTO> flowRepairHandleList = new ArrayList<CreditAccountFlowRepairHandleDTO>();
        CreditAccountFlowParam flowPageParam = new CreditAccountFlowParam();
        flowPageParam.setCreditAccountCode(flowVO.getCreditAccountCode());
        flowPageParam.setRepairTime(flowVO.getAuditDate());
        do {
            flowPageParam.setCurrent(page++);
            flowPageParam.setSize(size);
            log.info("\u67e5\u8be2\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowPageParam)));
            flowAfterList = this.creditAccountFlowService.selectRepairAfterPage(flowPageParam);
            log.info("\u67e5\u8be2\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowAfterList));
            if (CollectionUtils.isEmpty(flowAfterList)) break;
            flowAfterList.forEach(flowAfterVO -> {
                CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairAfterHandle(flowRepairVO, (CreditAccountFlowVO)flowAfterVO, flowRepairCurrentHandleDTO);
                if (Objects.nonNull(flowRepairHandleDTO)) {
                    flowRepairHandleList.add(flowRepairHandleDTO);
                } else {
                    log.info("\u6309\u7167\u4ea4\u6613\u7c7b\u578b\u672a\u5339\u914d\u5230\u4fe1\u7528\u8d26\u6237\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowAfterList));
                }
            });
        } while (flowAfterList.size() >= size);
        return flowRepairHandleList;
    }

    private CreditAccountFlowRepairHandleDTO assembleRepairHandle(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getCreditAccountLimit()) || Objects.isNull(flowVO.getCreditAccountOccupancyLimit()) || Objects.isNull(flowVO.getCreditAccountUsedLimit()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = new CreditAccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairVO.getActualAmount().subtract(flowVO.getAmount());
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getCreditAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getCreditAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getCreditAccountName());
        flowRepairHandleDTO.setTransactionType(flowVO.getTransactionType());
        flowRepairHandleDTO.setCreditAccountLimit(flowVO.getCreditAccountLimit());
        flowRepairHandleDTO.setCreditAccountOccupancyLimit(flowVO.getCreditAccountOccupancyLimit());
        flowRepairHandleDTO.setCreditAccountUsedLimit(flowVO.getCreditAccountUsedLimit());
        flowRepairHandleDTO.setCreditAccountAvailableLimit(flowVO.getCreditAccountAvailableLimit());
        return flowRepairHandleDTO;
    }

    private CreditAccountFlowRepairHandleDTO assembleRepairAfterHandle(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, CreditAccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getCreditAccountLimit()) || Objects.isNull(flowVO.getCreditAccountOccupancyLimit()) || Objects.isNull(flowVO.getCreditAccountUsedLimit()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = new CreditAccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairCurrentHandleDTO.getVariableAmount();
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getCreditAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getCreditAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getCreditAccountName());
        flowRepairHandleDTO.setTransactionType(flowRepairCurrentHandleDTO.getTransactionType());
        flowRepairHandleDTO.setCreditAccountLimit(flowVO.getCreditAccountLimit());
        flowRepairHandleDTO.setCreditAccountOccupancyLimit(flowVO.getCreditAccountOccupancyLimit());
        flowRepairHandleDTO.setCreditAccountUsedLimit(flowVO.getCreditAccountUsedLimit());
        flowRepairHandleDTO.setCreditAccountAvailableLimit(flowVO.getCreditAccountAvailableLimit());
        return flowRepairHandleDTO;
    }

    public void repairCalculationFlow(CreditAccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal creditAccountLimit = flowRepairHandleDTO.getCreditAccountLimit();
        BigDecimal creditAccountOccupancyLimit = flowRepairHandleDTO.getCreditAccountOccupancyLimit();
        BigDecimal creditAccountUsedLimit = flowRepairHandleDTO.getCreditAccountUsedLimit();
        BigDecimal creditAccountAvailableLimit = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        BigDecimal actualAmount = flowRepairHandleDTO.getActualAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_R.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(creditAccountOccupancyLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_T.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(creditAccountOccupancyLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_O.getValueCode())) {
            creditAccountLimit = creditAccountLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableAndAmountById(creditAccountLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_I.getValueCode())) {
            creditAccountLimit = creditAccountLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableAndAmountById(creditAccountLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_U.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableAndAmountById(creditAccountUsedLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_D.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableAndAmountById(creditAccountUsedLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    public void repairCalculationFlowAfter(CreditAccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal creditAccountLimit = flowRepairHandleDTO.getCreditAccountLimit();
        BigDecimal creditAccountOccupancyLimit = flowRepairHandleDTO.getCreditAccountOccupancyLimit();
        BigDecimal creditAccountUsedLimit = flowRepairHandleDTO.getCreditAccountUsedLimit();
        BigDecimal creditAccountAvailableLimit = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_R.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableById(creditAccountOccupancyLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_T.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableById(creditAccountOccupancyLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_O.getValueCode())) {
            creditAccountLimit = creditAccountLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableById(creditAccountLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_I.getValueCode())) {
            creditAccountLimit = creditAccountLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableById(creditAccountLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_U.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableById(creditAccountUsedLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_D.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableById(creditAccountUsedLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    private void saveFlowRepair20(CreditAccountFlowRepairParam param) {
        List<CreditAccountFlowRepairHandle20DTO> xyRepairHandle23List;
        List<CreditAccountFlowRepairHandle20DTO> xyRepairHandle22List;
        String accountCode = param.getAccountCode();
        LocalDateTime recalculationDate = param.getRecalculationDate();
        ArrayList<CreditAccountFlowRepairDO> repairDoAllList = new ArrayList<CreditAccountFlowRepairDO>();
        ArrayList<CreditAccountFlowRepairHandle20DTO> xyRepairHandleAllList = new ArrayList<CreditAccountFlowRepairHandle20DTO>();
        List<CreditAccountFlowRepairHandle20DTO> xyRepairHandle21List = this.xyAppendSql21(accountCode, recalculationDate);
        if (CollectionUtil.isNotEmpty(xyRepairHandle21List)) {
            xyRepairHandleAllList.addAll(xyRepairHandle21List);
        }
        if (CollectionUtil.isNotEmpty(xyRepairHandle22List = this.xyAppendSql22(accountCode, recalculationDate))) {
            xyRepairHandleAllList.addAll(xyRepairHandle22List);
        }
        if (CollectionUtil.isNotEmpty(xyRepairHandle23List = this.xyAppendSql23(accountCode, recalculationDate))) {
            xyRepairHandleAllList.addAll(xyRepairHandle23List);
        }
        this.assembleHandleFlowRepair20(param, xyRepairHandleAllList, repairDoAllList);
        if (!CollectionUtil.isNotEmpty(repairDoAllList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5339\u914d\u5230\u7b26\u5408\u91cd\u7b97\u7684\u6570\u636e!");
        }
        this.creditAccountFlowRepairRepo.saveAll(repairDoAllList);
    }

    private void assembleHandleFlowRepair20(CreditAccountFlowRepairParam param, List<CreditAccountFlowRepairHandle20DTO> repairHandleAllList, List<CreditAccountFlowRepairDO> repairDoAllList) {
        if (CollectionUtil.isNotEmpty(repairHandleAllList)) {
            Map<String, List<CreditAccountFlowRepairHandle20DTO>> xyRepairHandleAllMap = repairHandleAllList.stream().collect(Collectors.groupingBy(i -> i.getCreditAccountCode()));
            xyRepairHandleAllMap.forEach((key, value) -> {
                CreditAccountFlowRepairHandle20DTO repairHandle20DTO = value.stream().min((u1, u2) -> u1.getAuditDate().compareTo(u2.getAuditDate())).orElse(null);
                if (Objects.isNull(repairHandle20DTO)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u4fe1\u7528\u8d26\u6237(" + key + ")\u672a\u5339\u914d\u5230\u6700\u65e9\u5ba1\u6838\u65f6\u95f4\u7684\u6570\u636e!");
                }
                CreditAccountFlowRepairDO flowRepairDO = new CreditAccountFlowRepairDO();
                this.assembleFlowRepair20(flowRepairDO, param, repairHandle20DTO);
                repairDoAllList.add(flowRepairDO);
            });
        }
    }

    private void assembleFlowRepair20(CreditAccountFlowRepairDO flowRepairDO, CreditAccountFlowRepairParam param, CreditAccountFlowRepairHandle20DTO repairHandle20DTO) {
        flowRepairDO.setFlowNo(repairHandle20DTO.getFlowNo());
        flowRepairDO.setActualAmount(repairHandle20DTO.getAmount());
        flowRepairDO.setAmount(repairHandle20DTO.getAmount());
        flowRepairDO.setOpenAccountEntityCode(repairHandle20DTO.getObjectCode());
        flowRepairDO.setOpenAccountEntityName(repairHandle20DTO.getObjectName());
        flowRepairDO.setAccountType(repairHandle20DTO.getCreditAccountType());
        flowRepairDO.setAccountCode(repairHandle20DTO.getCreditAccountCode());
        flowRepairDO.setAccountName(repairHandle20DTO.getCreditAccountName());
        flowRepairDO.setSourceNo(repairHandle20DTO.getSourceNo());
        flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)param.getRecalculationReason())) {
            flowRepairDO.setRecalculationReason(param.getRecalculationReason());
        }
        if (Objects.nonNull(param.getRecalculationDate())) {
            flowRepairDO.setRecalculationDate(param.getRecalculationDate());
        } else {
            flowRepairDO.setRecalculationDate(repairHandle20DTO.getPrevAuditDate());
        }
        SysUserDTO sysUserDTO = this.getUser();
        if (StringUtils.isNotBlank((CharSequence)param.getRecalculationUser())) {
            flowRepairDO.setRecalculationUser(param.getRecalculationUser());
        } else {
            flowRepairDO.setRecalculationUser(sysUserDTO.getPrettyName());
        }
        if (Objects.nonNull(param.getRecalculationUserId())) {
            flowRepairDO.setRecalculationUserId(param.getRecalculationUserId());
        } else {
            flowRepairDO.setRecalculationUserId(sysUserDTO.getId());
        }
    }

    private List<CreditAccountFlowRepairHandle20DTO> xyAppendSql21(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        credit_account_code,credit_account_name,credit_account_type,transaction_type,object_code,object_name, \n        flow_no,amount,credit_account_limit,credit_account_used_limit,credit_account_occupancy_limit,credit_account_available_limit,audit_date,source_no, \n        prev_credit_account_limit, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_flow_no is null,amount,if(prev_credit_account_limit is null,0,prev_credit_account_limit - credit_account_limit)) difference_value \n        from \n                (select A.*, \n                        lag(credit_account_limit, 1,0) over(partition by credit_account_code order by audit_date) prev_credit_account_limit, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        credit_account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('I','O') \n                               and A.credit_account_type in ('CREDIT') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date");
        List creditAccountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(CreditAccountFlowRepairHandle20DTO.class));
        return creditAccountFlowRepairHandle20DTOList;
    }

    private List<CreditAccountFlowRepairHandle20DTO> xyAppendSql22(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        credit_account_code,credit_account_name,credit_account_type,transaction_type,object_code,object_name, \n        flow_no,amount,credit_account_limit,credit_account_used_limit,credit_account_occupancy_limit,credit_account_available_limit,audit_date,source_no, \n        prev_credit_account_occupancy_limit, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_flow_no is null,amount,if(prev_credit_account_occupancy_limit is null,0,prev_credit_account_occupancy_limit - credit_account_occupancy_limit)) difference_value \n        from \n                (select A.*, \n                        lag(credit_account_occupancy_limit, 1,0) over(partition by credit_account_code order by audit_date) prev_credit_account_occupancy_limit, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        credit_account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('T','R') \n                               and A.credit_account_type in ('CREDIT') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date");
        List creditAccountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(CreditAccountFlowRepairHandle20DTO.class));
        return creditAccountFlowRepairHandle20DTOList;
    }

    private List<CreditAccountFlowRepairHandle20DTO> xyAppendSql23(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        credit_account_code,credit_account_name,credit_account_type,transaction_type,object_code,object_name, \n        flow_no,amount,credit_account_limit,credit_account_used_limit,credit_account_occupancy_limit,credit_account_available_limit,audit_date,source_no, \n        prev_credit_account_used_limit, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_flow_no is null,amount,if(prev_credit_account_used_limit is null,0,prev_credit_account_used_limit - credit_account_used_limit)) difference_value \n        from \n                (select A.*, \n                        lag(credit_account_used_limit, 1,0) over(partition by credit_account_code order by audit_date) prev_credit_account_used_limit, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        credit_account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('U','D') \n                               and A.credit_account_type in ('CREDIT') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date ");
        List creditAccountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(CreditAccountFlowRepairHandle20DTO.class));
        return creditAccountFlowRepairHandle20DTOList;
    }

    private void appendWhere(String creditAccountCode, LocalDateTime recalculationDate, StringBuilder sqlWhereBuffer, Map<String, Object> params, List<Object> args) {
        if (StringUtils.isNotBlank((CharSequence)creditAccountCode)) {
            sqlWhereBuffer.append(" and A.credit_account_code = :creditAccountCode ");
            params.put("creditAccountCode", creditAccountCode);
        }
        if (Objects.nonNull(recalculationDate)) {
            sqlWhereBuffer.append(" and A.audit_date >= :auditDate ");
            params.put("auditDate", recalculationDate);
        }
    }

    private void processingCalculation20(List<CreditAccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        List<String> accountCodeAllList = repairFlowVOList.stream().map(CreditAccountFlowRepairVO::getAccountCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<CreditAccountFlowDO> creditAccountFlowAllList = this.creditAccountFlowRepo.selectByCreditAccountCodeIn(false, accountCodeAllList);
        HashMap creditAccountFlowAllMap = CollectionUtil.isEmpty(creditAccountFlowAllList) ? new HashMap() : creditAccountFlowAllList.stream().collect(Collectors.toMap(CreditAccountFlowDO::getCreditAccountCode, t -> t, (t1, t2) -> t1));
        for (CreditAccountFlowRepairVO creditAccountFlowRepairVO : repairFlowVOList) {
            String accountCode = creditAccountFlowRepairVO.getAccountCode();
            LocalDateTime recalculationDate = creditAccountFlowRepairVO.getRecalculationDate();
            this.transactionTemplate.setPropagationBehavior(3);
            String string = (String)this.transactionTemplate.execute(transactionStatus -> {
                try {
                    CreditAccountFlowDO creditAccountFlowDO = (CreditAccountFlowDO)((Object)((Object)creditAccountFlowAllMap.get(accountCode)));
                    if (Objects.isNull((Object)creditAccountFlowDO)) {
                        log.info("\u4fe1\u7528\u8d26\u6237(" + accountCode + ")\u672a\u67e5\u8be2\u5230\u6700\u65e9\u4e00\u6761\u7684\u5ba1\u6838\u6d41\u6c34!");
                        this.removeFlowNoCache(creditAccountFlowRepairVO.getFlowNo());
                        return null;
                    }
                    if (Objects.isNull(recalculationDate)) {
                        log.info("\u4fe1\u7528\u8d26\u6237(" + accountCode + ")\u7684\u91cd\u7b97\u65e5\u671f\u4e3a\u7a7a!");
                        this.removeFlowNoCache(creditAccountFlowRepairVO.getFlowNo());
                        return null;
                    }
                    String successAccountCode = null;
                    successAccountCode = creditAccountFlowDO.getAuditDate().isAfter(recalculationDate) ? this.executeCreditAccountFlowProcedureInitial(accountCode, repairFlowNoList) : this.executeCreditAccountFlowProcedure(accountCode, recalculationDate, repairFlowNoList);
                    if (Objects.nonNull(successAccountCode)) {
                        this.creditAccountFlowRepairRepoProc.updateRepairStatusById(UdcEnum.FLOW_REPAIR_STATUS_FIXED.getValueCode(), creditAccountFlowRepairVO.getId());
                        this.updateAccountAmt(Collections.singletonList(accountCode), repairFlowNoList);
                        this.updateCreditAccountSnapshot(Collections.singletonList(creditAccountFlowRepairVO), repairFlowNoList);
                    }
                    this.removeFlowNoCache(creditAccountFlowRepairVO.getFlowNo());
                    return successAccountCode;
                }
                catch (Exception e) {
                    log.error("\u4fe1\u7528\u8d26\u6237(" + accountCode + ")\u6d41\u6c34\u4fee\u590d\u91cd\u7b97\u5931\u8d25!:{}", (Object)e.getMessage());
                    transactionStatus.setRollbackOnly();
                    repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4fe1\u7528\u8d26\u6237(" + accountCode + ")\u6d41\u6c34\u4fee\u590d\u91cd\u7b97\u5931\u8d25!");
                }
            });
        }
        repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    private void updateCreditAccountSnapshot(List<CreditAccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        repairFlowVOList.forEach(accountFlowRepairVO -> {
            CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
            creditAccountFlowParam.setCreditAccountCode(accountFlowRepairVO.getAccountCode());
            creditAccountFlowParam.setRepairTime(accountFlowRepairVO.getRecalculationDate());
            List<CreditAccountFlowVO> creditAccountFlowVOList = this.creditAccountFlowService.selectRepairAfter(creditAccountFlowParam);
            HashMap creditAccountFlowAllMap = CollectionUtil.isEmpty(creditAccountFlowVOList) ? new HashMap() : creditAccountFlowVOList.stream().collect(Collectors.groupingBy(i -> i.getCreditAccountCode()));
            CreditAccountSnapshotParam creditAccountSnapshotParam = new CreditAccountSnapshotParam();
            creditAccountSnapshotParam.setCreditAccountCode(accountFlowRepairVO.getAccountCode());
            creditAccountSnapshotParam.setRepairTime(accountFlowRepairVO.getRecalculationDate());
            List<CreditAccountSnapshotDO> creditAccountSnapshotDOList = this.creditAccountService.selectCreditAccountSnapshotByParam(creditAccountSnapshotParam);
            HashMap creditAccountSnapshotAllMap = CollectionUtil.isEmpty(creditAccountSnapshotDOList) ? new HashMap() : creditAccountSnapshotDOList.stream().collect(Collectors.groupingBy(i -> i.getCreditAccountCode()));
            ArrayList<CreditAccountSnapshotDO> creditAccountSnapshotUpdateList = new ArrayList<CreditAccountSnapshotDO>();
            for (Map.Entry entry : creditAccountSnapshotAllMap.entrySet()) {
                String creditAccountCode = (String)entry.getKey();
                Collections.sort((List)entry.getValue(), Comparator.comparing(CreditAccountSnapshotDO::getSnapshotTime));
                List creditAccountFlowList = (List)creditAccountFlowAllMap.get(creditAccountCode);
                Collections.sort(creditAccountFlowList, Comparator.comparing(CreditAccountFlowVO::getAuditDate));
                for (CreditAccountSnapshotDO creditAccountSnapshotDO2 : (List)entry.getValue()) {
                    CreditAccountFlowVO maxDateAccountFlow;
                    ArrayList<CreditAccountFlowVO> creditAccountFlowFiltrationList = new ArrayList<CreditAccountFlowVO>();
                    for (int i2 = 0; i2 < creditAccountFlowList.size(); ++i2) {
                        CreditAccountFlowVO creditAccountFlowVO = (CreditAccountFlowVO)creditAccountFlowList.get(i2);
                        if (creditAccountFlowVO.getAuditDate().isEqual(creditAccountSnapshotDO2.getSnapshotTime())) {
                            creditAccountFlowFiltrationList.add(creditAccountFlowVO);
                            continue;
                        }
                        if (!creditAccountFlowVO.getAuditDate().isBefore(creditAccountSnapshotDO2.getSnapshotTime())) break;
                        creditAccountFlowFiltrationList.add(creditAccountFlowVO);
                    }
                    if (!Objects.nonNull(maxDateAccountFlow = (CreditAccountFlowVO)creditAccountFlowFiltrationList.stream().filter(Objects::nonNull).max(Comparator.comparing(CreditAccountFlowVO::getAuditDate)).orElse(null))) continue;
                    creditAccountSnapshotDO2.setCreditAccountLimit(maxDateAccountFlow.getCreditAccountLimit());
                    creditAccountSnapshotDO2.setCreditAccountAvailableLimit(maxDateAccountFlow.getCreditAccountAvailableLimit());
                    creditAccountSnapshotDO2.setCreditAccountOccupancyLimit(maxDateAccountFlow.getCreditAccountOccupancyLimit());
                    creditAccountSnapshotDO2.setCreditAccountUsedLimit(maxDateAccountFlow.getCreditAccountUsedLimit());
                    creditAccountSnapshotUpdateList.add(creditAccountSnapshotDO2);
                }
                CreditAccountSnapshotDO lastSnapshot = (CreditAccountSnapshotDO)((Object)((Object)((List)entry.getValue()).get(((List)entry.getValue()).size() - 1)));
                CreditAccountFlowVO lastFlow = (CreditAccountFlowVO)creditAccountFlowList.get(creditAccountFlowList.size() - 1);
                creditAccountSnapshotUpdateList.forEach(creditAccountSnapshotDO -> {
                    if (Objects.equals(creditAccountSnapshotDO.getId(), lastSnapshot.getId())) {
                        creditAccountSnapshotDO.setCreditAccountLimit(lastFlow.getCreditAccountLimit());
                        creditAccountSnapshotDO.setCreditAccountAvailableLimit(lastFlow.getCreditAccountAvailableLimit());
                        creditAccountSnapshotDO.setCreditAccountOccupancyLimit(lastFlow.getCreditAccountOccupancyLimit());
                        creditAccountSnapshotDO.setCreditAccountUsedLimit(lastFlow.getCreditAccountUsedLimit());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(creditAccountSnapshotUpdateList)) {
                this.creditAccountSnapshotRepo.saveAll(creditAccountSnapshotUpdateList);
            }
        });
    }

    public String executeCreditAccountFlowProcedure(String creditAccountCode, LocalDateTime retryTime, List<String> repairFlowNoList) {
        if (StringUtils.isBlank((CharSequence)creditAccountCode)) {
            log.info("\u4fe1\u7528\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97");
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4fe1\u7528\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97!");
        }
        if (Objects.isNull(retryTime)) {
            log.info("\u91cd\u7b97\u65f6\u95f4\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97");
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u7b97\u65f6\u95f4\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97!");
        }
        StoredProcedureQuery storedProcedureQuery = this.entityManager.createStoredProcedureQuery("credit_account_flow_repair");
        storedProcedureQuery.registerStoredProcedureParameter("credit_account_code_i", String.class, ParameterMode.IN);
        storedProcedureQuery.registerStoredProcedureParameter("audit_date_i", LocalDateTime.class, ParameterMode.IN);
        storedProcedureQuery.setParameter("credit_account_code_i", (Object)creditAccountCode);
        storedProcedureQuery.setParameter("audit_date_i", (Object)retryTime);
        storedProcedureQuery.execute();
        List resultList = storedProcedureQuery.getResultList();
        log.info("\u5904\u7406\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u5b58\u50a8\u8fc7\u7a0b\u7684\u7ed3\u679c:" + resultList.toString());
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            return null;
        }
        return creditAccountCode;
    }

    public String executeCreditAccountFlowProcedureInitial(String creditAccountCode, List<String> repairFlowNoList) {
        if (StringUtils.isBlank((CharSequence)creditAccountCode)) {
            log.info("\u4fe1\u7528\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a\u65e0\u6cd5\u671f\u521d\u91cd\u7b97");
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4fe1\u7528\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a\u65e0\u6cd5\u671f\u521d\u91cd\u7b97!");
        }
        StoredProcedureQuery storedProcedureQuery = this.entityManager.createStoredProcedureQuery("credit_account_flow_repair_from_initial");
        storedProcedureQuery.registerStoredProcedureParameter("credit_account_code_i", String.class, ParameterMode.IN);
        storedProcedureQuery.setParameter("credit_account_code_i", (Object)creditAccountCode);
        storedProcedureQuery.execute();
        List resultList = storedProcedureQuery.getResultList();
        log.info("\u5904\u7406\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u671f\u521d\u5b58\u50a8\u8fc7\u7a0b\u7684\u7ed3\u679c:" + resultList.toString());
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            return null;
        }
        return creditAccountCode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rollbackBySourceNo(List<CreditAccountFlowVO> creditAccountFlowVOList) {
        List<CreditAccountFlowRepairVO> creditAccountFlowRepairVOList = this.convertToRepairVO(creditAccountFlowVOList);
        List<String> repairFlowNo10List = creditAccountFlowRepairVOList.stream().map(CreditAccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        creditAccountFlowRepairVOList.forEach(flowRepairVO -> this.processingCalculationRollback((CreditAccountFlowRepairVO)flowRepairVO, repairFlowNo10List));
        repairFlowNo10List.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    public List<CreditAccountFlowRepairVO> convertToRepairVO(List<CreditAccountFlowVO> creditAccountFlowVOList) {
        creditAccountFlowVOList = creditAccountFlowVOList.stream().sorted(Comparator.comparing(CreditAccountFlowVO::getAuditDate)).collect(Collectors.toList());
        List<CreditAccountFlowRepairVO> flowRepairVOList = creditAccountFlowVOList.stream().map(flowVO -> {
            CreditAccountFlowRepairVO flowRepairVO = new CreditAccountFlowRepairVO();
            flowRepairVO.setId(-100L);
            flowRepairVO.setFlowNo(flowVO.getFlowNo());
            flowRepairVO.setActualAmount(BigDecimal.ZERO);
            flowRepairVO.setAmount(flowVO.getAmount());
            flowRepairVO.setOpenAccountEntityCode(flowVO.getObjectCode());
            flowRepairVO.setOpenAccountEntityName(flowVO.getObjectName());
            flowRepairVO.setAccountType(flowVO.getCreditAccountType());
            flowRepairVO.setAccountCode(flowVO.getCreditAccountCode());
            flowRepairVO.setAccountName(flowVO.getCreditAccountName());
            flowRepairVO.setSourceNo(flowVO.getSourceNo());
            flowRepairVO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
            flowRepairVO.setRecalculationReason(UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode());
            flowRepairVO.setRecalculationDate(flowVO.getAuditDate());
            flowRepairVO.setRecalculationUser(null);
            flowRepairVO.setRecalculationUserId(null);
            return flowRepairVO;
        }).collect(Collectors.toList());
        return flowRepairVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processingCalculationRollback(CreditAccountFlowRepairVO flowRepairVO, List<String> repairFlowNoList) {
        ArrayList<String> accCodeList = new ArrayList<String>();
        CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
        flowQueryParam.setFlowNo(flowRepairVO.getFlowNo());
        log.info("\u4fee\u590d\u91cd\u7b97\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowQueryParam)));
        List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowService.selectListByQueryParam(flowQueryParam);
        log.info("\u4fee\u590d\u91cd\u7b97\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
        if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() == 1) {
            if (Objects.nonNull(flowVOList.get(0))) {
                CreditAccountFlowVO flowVO = flowVOList.get(0);
                if (Objects.equals(flowVO.getCreditAccountType(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()) && FinConstant.CREDIT_ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                    this.repairFlow(flowRepairVO, flowVO, accCodeList);
                } else {
                    log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
                }
                if (accCodeList.contains(flowVO.getCreditAccountCode())) {
                    this.updateAccountAmt(Collections.singletonList(flowVO.getCreditAccountCode()), repairFlowNoList);
                }
            } else {
                log.info("\u672a\u67e5\u8be2\u5230\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowRepairVO));
            }
        } else {
            log.info("\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6709\u591a\u6761,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
        }
        this.removeFlowNoCache(flowRepairVO.getFlowNo());
    }

    public CreditAccountFlowRepairServiceImpl(CreditAccountFlowRepairRepo creditAccountFlowRepairRepo, CreditAccountFlowRepairRepoProc creditAccountFlowRepairRepoProc, CreditAccountFlowService creditAccountFlowService, CreditAccountFlowRepoProc creditAccountFlowRepoProc, CreditAccountFlowRepo creditAccountFlowRepo, CreditAccountRepoProc creditAccountRepoProc, CreditAccountSnapshotRepo creditAccountSnapshotRepo, CreditAccountService creditAccountService, RedissonClient redissonClient, EntityManager entityManager, NamedParameterJdbcTemplate namedTemplate, TransactionTemplate transactionTemplate) {
        this.creditAccountFlowRepairRepo = creditAccountFlowRepairRepo;
        this.creditAccountFlowRepairRepoProc = creditAccountFlowRepairRepoProc;
        this.creditAccountFlowService = creditAccountFlowService;
        this.creditAccountFlowRepoProc = creditAccountFlowRepoProc;
        this.creditAccountFlowRepo = creditAccountFlowRepo;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.creditAccountSnapshotRepo = creditAccountSnapshotRepo;
        this.creditAccountService = creditAccountService;
        this.redissonClient = redissonClient;
        this.entityManager = entityManager;
        this.namedTemplate = namedTemplate;
        this.transactionTemplate = transactionTemplate;
    }
}

