/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flowrepair;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.flowrepair.AccountFlowRepairHandleDTO;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.facade.vo.flowrepair.AccountFlowRepairVO;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.flowrepair.AccountFlowRepairService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.flowrepair.AccountFlowRepairDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.flow.AccountFlowRepoProc;
import com.elitesland.fin.repo.flowrepair.AccountFlowRepairRepo;
import com.elitesland.fin.repo.flowrepair.AccountFlowRepairRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountFlowRepairServiceImpl
implements AccountFlowRepairService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowRepairServiceImpl.class);
    @Autowired
    private AccountFlowRepairRepo accountFlowRepairRepo;
    @Autowired
    private AccountFlowRepairRepoProc accountFlowRepairRepoProc;
    @Autowired
    private AccountFlowService accountFlowService;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private AccountRepoProc accountRepoProc;
    @Autowired
    private AccountRepo accountRepo;
    private final RedissonClient redissonClient;

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowRepairVO> page(AccountFlowRepairPageParam pageParam) {
        PagingVO<AccountFlowRepairVO> pagingVO = this.accountFlowRepairRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(AccountFlowRepairParam param) {
        if (StringUtils.isBlank((CharSequence)param.getFlowNo())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getActualAmount())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b9e\u9645\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        AccountFlowVO flowVO = this.selectFlowByFlowNo(param.getFlowNo());
        if (Objects.isNull(param.getId())) {
            AccountFlowRepairDO flowRepairDO = new AccountFlowRepairDO();
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.accountFlowRepairRepo.save((Object)flowRepairDO);
        } else {
            Optional flowRepairOptional = this.accountFlowRepairRepo.findById(param.getId());
            if (flowRepairOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6761\u6d41\u6c34\u4fee\u590d\u6570\u636e!");
            }
            AccountFlowRepairDO flowRepairDO = (AccountFlowRepairDO)((Object)flowRepairOptional.get());
            if (!Objects.equals(flowRepairDO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8349\u7a3f\u72b6\u6001\u624d\u53ef\u4fee\u6539!");
            }
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.accountFlowRepairRepo.save((Object)flowRepairDO);
        }
    }

    private void assembleFlowRepair(AccountFlowRepairDO flowRepairDO, AccountFlowRepairParam param, AccountFlowVO flowVO) {
        flowRepairDO.setFlowNo(param.getFlowNo());
        flowRepairDO.setActualAmount(param.getActualAmount());
        flowRepairDO.setAmount(flowVO.getAmount());
        flowRepairDO.setOpenAccountEntityCode(null);
        flowRepairDO.setOpenAccountEntityName(flowVO.getAccountHolderName());
        flowRepairDO.setAccountType(flowVO.getAccountType());
        flowRepairDO.setAccountCode(flowVO.getAccountCode());
        flowRepairDO.setAccountName(flowVO.getAccountName());
        flowRepairDO.setSourceNo(flowVO.getSourceNo());
        flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
    }

    private AccountFlowVO selectFlowByFlowNo(String flowNo) {
        if (StringUtils.isBlank((CharSequence)flowNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
        flowQueryParam.setFlowNo(flowNo);
        List<AccountFlowVO> flowVOList = this.accountFlowService.selectListByQueryParam(flowQueryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u6d41\u6c34\u4fe1\u606f!");
        }
        if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u5b58\u5728\u591a\u6761\u6d41\u6c34\u4fe1\u606f!");
        }
        return flowVOList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        AccountFlowRepairPageParam flowRepairPageParam = new AccountFlowRepairPageParam();
        flowRepairPageParam.setIds(ids);
        List<AccountFlowRepairVO> respVOList = this.accountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List voList = respVOList.stream().filter(respVO -> !Objects.equals(respVO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            String checkResult = voList.stream().map(vo -> "\u6d41\u6c34\u53f7:" + vo.getFlowNo()).collect(Collectors.joining(";", "\u53ea\u6709\u8349\u7a3f\u53ef\u5220\u9664,[", "], \u8bf7\u68c0\u67e5"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        this.accountFlowRepairRepoProc.updateDeleteFlagBatch(1, ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairRedo(AccountFlowRepairRedoParam repairRedoParam) {
        AccountFlowRepairPageParam flowRepairPageParam = new AccountFlowRepairPageParam();
        flowRepairPageParam.setIds(repairRedoParam.getIds());
        flowRepairPageParam.setFlowNoList(repairRedoParam.getFlowNoList());
        flowRepairPageParam.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        List<AccountFlowRepairVO> repairFlowVOList = this.accountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(repairFlowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u7b26\u5408\u91cd\u7b97\u7684\u8d26\u6237\u6d41\u6c34\u6570\u636e!");
        }
        List flowNoCheckList = repairFlowVOList.stream().filter(repairParam -> !StringUtils.isBlank((CharSequence)repairParam.getFlowNo())).map(AccountFlowRepairVO::getFlowNo).collect(Collectors.toMap(e -> e, e -> 1, (a, b) -> a + b)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(flowNoCheckList)) {
            String checkResult = flowNoCheckList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        List<String> repairFlowNoList = repairFlowVOList.stream().map(AccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repairFlowNoList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u7b97\u7684\u8d26\u6237\u6d41\u6c34\u6570\u636e\u7684\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        ArrayList repairFlowNoCacheList = new ArrayList();
        repairFlowNoList.forEach(flowNo -> {
            if (StringUtils.isNotBlank((CharSequence)this.getFlowNoCache((String)flowNo))) {
                repairFlowNoCacheList.add(flowNo);
            } else {
                this.saveFlowNoCache((String)flowNo);
            }
        });
        if (CollectionUtils.isNotEmpty(repairFlowNoCacheList)) {
            String checkResult = repairFlowNoCacheList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u4fee\u590d\u91cd\u7b97\u4e2d,\u8bf7\u7a0d\u540e\u518d\u6b21\u91cd\u7b97!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        if (CollectionUtils.isNotEmpty(repairFlowVOList)) {
            this.processingCalculation(repairFlowVOList, repairFlowNoList);
        }
    }

    @Override
    public void removeFlowNoCacheBatch(List<String> flowNoList) {
        flowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Override
    public void removeFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public String getFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            return (String)bucket.get();
        }
        return null;
    }

    @Override
    public void saveFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        bucket.set((Object)flowNo);
    }

    private void processingCalculation(List<AccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        ArrayList accCodeList = new ArrayList();
        repairFlowVOList.forEach(flowRepairVO -> {
            AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
            flowQueryParam.setFlowNo(flowRepairVO.getFlowNo());
            log.info("\u4fee\u590d\u91cd\u7b97\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowQueryParam)));
            List<AccountFlowVO> flowVOList = this.accountFlowService.selectListByQueryParam(flowQueryParam);
            log.info("\u4fee\u590d\u91cd\u7b97\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
            if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() == 1) {
                if (Objects.nonNull(flowVOList.get(0))) {
                    AccountFlowVO flowVO = flowVOList.get(0);
                    if (Objects.equals(flowVO.getAccountType(), UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()) && FinConstant.ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                        this.repairFlow((AccountFlowRepairVO)flowRepairVO, flowVO, accCodeList);
                    } else if (Objects.equals(flowVO.getAccountType(), UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode()) && FinConstant.ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                        this.repairFlow((AccountFlowRepairVO)flowRepairVO, flowVO, accCodeList);
                    } else {
                        log.info("\u672a\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
                    }
                } else {
                    log.info("\u672a\u67e5\u8be2\u5230\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowRepairVO));
                }
            } else {
                log.info("\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6709\u591a\u6761,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
            }
        });
        if (CollectionUtils.isNotEmpty(accCodeList)) {
            List<String> accCodes = accCodeList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.updateAccountAmt(accCodes, repairFlowNoList);
        }
        repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void repairFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, List<String> accCodeList) {
        this.repairCurrentFlow(flowRepairVO, flowVO, accCodeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAccountAmt(List<String> accCodeList, List<String> repairFlowNoList) {
        accCodeList.forEach(accCode -> {
            AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
            flowQueryParam.setAccountCode((String)accCode);
            AccountFlowVO flowVO = this.accountFlowRepoProc.selectPreviousRepairAmtByParam(flowQueryParam);
            AccountDO accountDO = this.accountRepoProc.findByAccountCode((String)accCode);
            if (Objects.nonNull(flowVO) && Objects.nonNull((Object)accountDO)) {
                BigDecimal accountAmount = flowVO.getAccountAmount();
                BigDecimal accountOccupancyAmount = flowVO.getAccountOccupancyAmount();
                accountDO.setAccountAmount(accountAmount);
                accountDO.setAccountOccupancyAmount(accountOccupancyAmount);
                accountDO.setAccountAvailableAmount(accountAmount.subtract(accountOccupancyAmount));
                this.accountRepo.save((Object)accountDO);
            } else if (Objects.isNull((Object)accountDO)) {
                repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u8d26\u6237(" + accCode + ")\u4fe1\u606f!");
            }
        });
    }

    public void repairCurrentFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, List<String> accCodeList) {
        AccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairHandle(flowRepairVO, flowVO);
        if (Objects.nonNull(flowRepairHandleDTO)) {
            this.repairCalculationFlow(flowRepairHandleDTO, accCodeList);
            this.accountFlowRepairRepoProc.updateAmountAndRepairStatusById(flowRepairHandleDTO.getAmount(), UdcEnum.FLOW_REPAIR_STATUS_FIXED.getValueCode(), flowRepairHandleDTO.getFlowRepairId());
            this.repairAfterFlow(flowRepairVO, flowVO, flowRepairHandleDTO, accCodeList);
        }
    }

    public void repairAfterFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, AccountFlowRepairHandleDTO flowRepairCurrentHandleDTO, List<String> accCodeList) {
        List<AccountFlowRepairHandleDTO> flowRepairHandleList = this.selectRepairAfterFlow(flowRepairVO, flowVO, flowRepairCurrentHandleDTO);
        if (CollectionUtils.isNotEmpty(flowRepairHandleList)) {
            flowRepairHandleList.forEach(flowRepairHandleDTO -> this.repairCalculationFlowAfter((AccountFlowRepairHandleDTO)flowRepairHandleDTO, accCodeList));
        }
    }

    public List<AccountFlowRepairHandleDTO> selectRepairAfterFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, AccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        List<AccountFlowVO> flowAfterList;
        int size = 500;
        int page = 1;
        ArrayList<AccountFlowRepairHandleDTO> flowRepairHandleList = new ArrayList<AccountFlowRepairHandleDTO>();
        AccountFlowPageParam flowPageParam = new AccountFlowPageParam();
        flowPageParam.setAccountCode(flowVO.getAccountCode());
        flowPageParam.setRepairTime(flowVO.getCreateTime());
        do {
            flowPageParam.setCurrent(page++);
            flowPageParam.setSize(size);
            log.info("\u67e5\u8be2\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowPageParam)));
            flowAfterList = this.accountFlowService.selectRepairAfterPage(flowPageParam);
            log.info("\u67e5\u8be2\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowAfterList));
            if (CollectionUtils.isEmpty(flowAfterList)) break;
            flowAfterList.forEach(flowAfterVO -> {
                AccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairAfterHandle(flowRepairVO, (AccountFlowVO)flowAfterVO, flowRepairCurrentHandleDTO);
                if (Objects.nonNull(flowRepairHandleDTO)) {
                    flowRepairHandleList.add(flowRepairHandleDTO);
                } else {
                    log.info("\u6309\u7167\u4ea4\u6613\u7c7b\u578b\u672a\u5339\u914d\u5230\u8d26\u6237\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowAfterList));
                }
            });
        } while (flowAfterList.size() >= size);
        return flowRepairHandleList;
    }

    private AccountFlowRepairHandleDTO assembleRepairHandle(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getAccountAmount()) || Objects.isNull(flowVO.getAccountOccupancyAmount()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        AccountFlowRepairHandleDTO flowRepairHandleDTO = new AccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairVO.getActualAmount().subtract(flowVO.getAmount());
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getAccountName());
        flowRepairHandleDTO.setTransactionType(flowVO.getTransactionType());
        flowRepairHandleDTO.setAccountAmount(flowVO.getAccountAmount());
        flowRepairHandleDTO.setAccountOccupancyAmount(flowVO.getAccountOccupancyAmount());
        flowRepairHandleDTO.setAccountAvailableAmount(flowVO.getAccountAvailableAmount());
        return flowRepairHandleDTO;
    }

    private AccountFlowRepairHandleDTO assembleRepairAfterHandle(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, AccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getAccountAmount()) || Objects.isNull(flowVO.getAccountOccupancyAmount()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        AccountFlowRepairHandleDTO flowRepairHandleDTO = new AccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairCurrentHandleDTO.getVariableAmount();
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getAccountName());
        flowRepairHandleDTO.setTransactionType(flowRepairCurrentHandleDTO.getTransactionType());
        flowRepairHandleDTO.setAccountAmount(flowVO.getAccountAmount());
        flowRepairHandleDTO.setAccountOccupancyAmount(flowVO.getAccountOccupancyAmount());
        flowRepairHandleDTO.setAccountAvailableAmount(flowVO.getAccountAvailableAmount());
        return flowRepairHandleDTO;
    }

    public void repairCalculationFlow(AccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal accountAmount = flowRepairHandleDTO.getAccountAmount();
        BigDecimal accountOccupancyAmount = flowRepairHandleDTO.getAccountOccupancyAmount();
        BigDecimal accountAvailableAmount = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        BigDecimal actualAmount = flowRepairHandleDTO.getActualAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_R.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(accountOccupancyAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_T.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(accountOccupancyAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_O.getValueCode())) {
            accountAmount = accountAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableAndAmountById(accountAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_I.getValueCode())) {
            accountAmount = accountAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableAndAmountById(accountAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    public void repairCalculationFlowAfter(AccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal accountAmount = flowRepairHandleDTO.getAccountAmount();
        BigDecimal accountOccupancyAmount = flowRepairHandleDTO.getAccountOccupancyAmount();
        BigDecimal accountAvailableAmount = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_R.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableById(accountOccupancyAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_T.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableById(accountOccupancyAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_O.getValueCode())) {
            accountAmount = accountAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableById(accountAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_I.getValueCode())) {
            accountAmount = accountAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableById(accountAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    public AccountFlowRepairServiceImpl(AccountFlowRepairRepo accountFlowRepairRepo, AccountFlowRepairRepoProc accountFlowRepairRepoProc, AccountFlowService accountFlowService, AccountFlowRepoProc accountFlowRepoProc, AccountRepoProc accountRepoProc, AccountRepo accountRepo, RedissonClient redissonClient) {
        this.accountFlowRepairRepo = accountFlowRepairRepo;
        this.accountFlowRepairRepoProc = accountFlowRepairRepoProc;
        this.accountFlowService = accountFlowService;
        this.accountFlowRepoProc = accountFlowRepoProc;
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
        this.redissonClient = redissonClient;
    }
}

