/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.recorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.rectype.RecTypeConvert;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class RecOrderServiceImpl
implements RecOrderService {
    private final RecOrderDomainService recOrderDomainService;
    private final RecTypeDomainService recTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final TransactionTemplate transactionTemplate;

    @Override
    @SysCodeProc
    public PagingVO<RecOrderVO> page(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = this.recOrderDomainService.page(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        recOrderVOPagingVO.getRecords().forEach(vo -> {
            if (vo.getVerAmt() != null && vo.getTotalAmt() != null) {
                vo.setUnVerAmt(vo.getTotalAmt().subtract(vo.getVerAmt()));
            }
        });
        return recOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public RecOrderVO queryById(Long id) {
        RecOrderDTO recOrderDTO = this.recOrderDomainService.queryById(id, false);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        return recOrderVO;
    }

    @Override
    @SysCodeProc
    public RecOrderVO queryDetailsById(Long id) {
        RecOrderDTO recOrderDTO = this.recOrderDomainService.queryById(id, true);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        return recOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = this.recOrderDomainService.deleteByIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Override
    public ApiResult<RecOrderVO> defaultValue() {
        RecTypeDTO recTypeDTO = this.recTypeDomainService.defaultValue();
        RecOrderVO recOrderVO = RecTypeConvert.INSTANCE.typeToOrder(recTypeDTO);
        if (recOrderVO == null) {
            return ApiResult.ok((Object)new RecOrderVO());
        }
        return ApiResult.ok((Object)recOrderVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(RecOrderSaveParam param) {
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        Long id = this.recOrderDomainService.save(order);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApiResult<Long> submit(RecOrderSaveParam param) {
        Boolean auto = this.recTypeDomainService.getAuto(param.getRecTypeId());
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        if (auto.booleanValue()) {
            order.setAuditDate(LocalDateTime.now());
            order.setAuditUser("admin");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            order.setAuditUserId(user.getId());
        }
        this.transactionTemplate.setPropagationBehavior(3);
        Long id = (Long)this.transactionTemplate.execute(transactionStatus -> this.recOrderDomainService.submit(order, auto));
        if (!auto.booleanValue()) {
            this.startWorkFlow(order, id);
        }
        return ApiResult.ok((Object)id);
    }

    private void startWorkFlow(RecOrder order, Long id) {
        if (order.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(order.getProcInstStatus())) {
            String procInstName = "\u6536\u6b3e\u5355\u5ba1\u6838-" + order.getRecOrderNo();
            String procKey = WorkFlowDefKey.FIN_REC_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<String, Object>());
            this.recOrderDomainService.updateWorkInfo(processInfo, id);
        }
    }

    public RecOrderServiceImpl(RecOrderDomainService recOrderDomainService, RecTypeDomainService recTypeDomainService, SystemRpcService systemRpcService, WorkflowRpcService workflowRpcService, TransactionTemplate transactionTemplate) {
        this.recOrderDomainService = recOrderDomainService;
        this.recTypeDomainService = recTypeDomainService;
        this.systemRpcService = systemRpcService;
        this.workflowRpcService = workflowRpcService;
        this.transactionTemplate = transactionTemplate;
    }
}

