/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.adjusttoorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.dto.adjusttoorder.AdjustToOrderDTO;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.fin.entity.adjusttoorder.QAdjustToOrderDO;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepo;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AdjustToOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAdjustToOrderDO qAdjustToOrderDO = QAdjustToOrderDO.adjustToOrderDO;
    private final AdjustToOrderRepo adjustToOrderRepo;
    private final UdcProvider udcProvider;

    public PagingVO<AdjustToOrderDTO> page(AdjustToOrderParam adjustOrderPageParam) {
        Predicate where = this.where(adjustOrderPageParam);
        JPAQuery query = (JPAQuery)this.select(AdjustToOrderDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        adjustOrderPageParam.setPaging(query);
        adjustOrderPageParam.fillOrders(query, this.qAdjustToOrderDO);
        long count = query.fetchCount();
        List adjustToOrderDTOList = query.fetch();
        Map accountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Map creditAccountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
        adjustToOrderDTOList.stream().forEach(item -> {
            String type = item.getAccountTypeTo();
            if (accountTypeUdc.get(type) != null) {
                item.setAccountTypeToName((String)accountTypeUdc.get(type));
                return;
            }
            item.setAccountTypeToName((String)creditAccountTypeUdc.get(type));
        });
        return PagingVO.builder().total(count).records(adjustToOrderDTOList).build();
    }

    public List<AdjustToOrderVO> queryByIds(List<Long> id) {
        return ((JPAQuery)this.select(AdjustToOrderVO.class).where((Predicate)this.qAdjustToOrderDO.id.in(id))).fetch();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO) {
        this.jpaQueryFactory.update((EntityPath)this.qAdjustToOrderDO).set((Path)this.qAdjustToOrderDO.docState, (Object)status).set(this.qAdjustToOrderDO.auditTime, (Object)LocalDateTime.now()).set((Path)this.qAdjustToOrderDO.auditUser, (Object)sysUserDTO.getUsername()).set(this.qAdjustToOrderDO.auditUserId, (Object)sysUserDTO.getId()).where(new Predicate[]{this.qAdjustToOrderDO.id.in(ids)}).execute();
    }

    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)this.qAdjustToOrderDO).set((Path)this.qAdjustToOrderDO.docState, (Object)status).set(this.qAdjustToOrderDO.auditTime, (Object)LocalDateTime.now()).set((Path)this.qAdjustToOrderDO.auditUser, (Object)sysUserDTO.getUsername()).set(this.qAdjustToOrderDO.auditUserId, (Object)sysUserDTO.getId()).set((Path)this.qAdjustToOrderDO.auditRejectReason, (Object)reason).where(new Predicate[]{this.qAdjustToOrderDO.id.in(ids)}).execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)this.qAdjustToOrderDO).set((Path)this.qAdjustToOrderDO.docState, (Object)status).set(this.qAdjustToOrderDO.auditTime, (Object)LocalDateTime.now()).set((Path)this.qAdjustToOrderDO.auditUser, (Object)sysUserDTO.getUsername()).set(this.qAdjustToOrderDO.auditUserId, (Object)sysUserDTO.getId()).set((Path)this.qAdjustToOrderDO.auditRejectReason, (Object)reason).where(new Predicate[]{this.qAdjustToOrderDO.id.in(ids)}).execute();
    }

    public AdjustToOrderVO queryById(Long id) {
        return (AdjustToOrderVO)((JPAQuery)this.select(AdjustToOrderVO.class).where((Predicate)this.qAdjustToOrderDO.id.eq((Object)id))).fetchOne();
    }

    private Predicate where(AdjustToOrderParam adjustToOrderParam) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(adjustToOrderParam.getId() != null, this.qAdjustToOrderDO.id, (Object)adjustToOrderParam.getId()).andLike(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getDocNo()), (StringExpression)this.qAdjustToOrderDO.docNo, StringUtil.buildLikeString(adjustToOrderParam.getDocNo())).andEq(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getDocState()), (SimpleExpression)this.qAdjustToOrderDO.docState, (Object)adjustToOrderParam.getDocState()).andEq(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getAccountTypeFrom()), (SimpleExpression)this.qAdjustToOrderDO.accountTypeFrom, (Object)adjustToOrderParam.getAccountTypeFrom()).andEq(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getAccountTypeTo()), (SimpleExpression)this.qAdjustToOrderDO.accountTypeTo, (Object)adjustToOrderParam.getAccountTypeTo()).andLike(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getAccountNameFrom()), (StringExpression)this.qAdjustToOrderDO.accountNameFrom, StringUtil.buildLikeString(adjustToOrderParam.getAccountNameFrom())).andLike(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getAccountNameTo()), (StringExpression)this.qAdjustToOrderDO.accountNameTo, StringUtil.buildLikeString(adjustToOrderParam.getAccountNameTo())).andEq(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getAdjustReason()), (SimpleExpression)this.qAdjustToOrderDO.adjustReason, (Object)adjustToOrderParam.getAdjustReason()).andLike(StringUtils.isNotEmpty((CharSequence)adjustToOrderParam.getRemark()), (StringExpression)this.qAdjustToOrderDO.remark, StringUtil.buildLikeString(adjustToOrderParam.getRemark())).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAdjustToOrderDO.id, this.qAdjustToOrderDO.docState, this.qAdjustToOrderDO.accountCodeFrom, this.qAdjustToOrderDO.accountNameFrom, this.qAdjustToOrderDO.accountTypeFrom, this.qAdjustToOrderDO.accountTypeTo, this.qAdjustToOrderDO.accountCodeTo, this.qAdjustToOrderDO.accountNameTo, this.qAdjustToOrderDO.auditTime, this.qAdjustToOrderDO.auditRejectReason, this.qAdjustToOrderDO.auditUser, this.qAdjustToOrderDO.docNo, this.qAdjustToOrderDO.createTime, this.qAdjustToOrderDO.creator, this.qAdjustToOrderDO.adjustAmount, this.qAdjustToOrderDO.remark, this.qAdjustToOrderDO.modifyTime, this.qAdjustToOrderDO.modifyUserId, this.qAdjustToOrderDO.updater, this.qAdjustToOrderDO.adjustReason})).from((EntityPath)this.qAdjustToOrderDO);
    }

    public AdjustToOrderDO findById(Long id) {
        Optional adjustToOrderDOOptional = this.adjustToOrderRepo.findById(id);
        Assert.isTrue((boolean)adjustToOrderDOOptional.isPresent(), (String)"\u67e5\u8be2\u4e0d\u5230\u8c03\u5242\u5355", (Object[])new Object[0]);
        return (AdjustToOrderDO)((Object)adjustToOrderDOOptional.get());
    }

    public AdjustToOrderRepoProc(JPAQueryFactory jpaQueryFactory, AdjustToOrderRepo adjustToOrderRepo, UdcProvider udcProvider) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.adjustToOrderRepo = adjustToOrderRepo;
        this.udcProvider = udcProvider;
    }
}

