/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.vo.account.AccountIocParamVO;
import com.elitesland.fin.entity.account.QAccountIocDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountIocRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<AccountIocDTO> search(AccountIocParamVO param) {
        QAccountIocDO jpaQDo = QAccountIocDO.accountIocDO;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountIocDTO.class, (Expression[])new Expression[]{jpaQDo.id, jpaQDo.ioCode, jpaQDo.ioName, jpaQDo.ioType, jpaQDo.status, jpaQDo.remark, jpaQDo.createUserId, jpaQDo.creator, jpaQDo.createTime, jpaQDo.modifyUserId, jpaQDo.updater, jpaQDo.modifyTime, jpaQDo.deleteFlag, jpaQDo.tenantId, jpaQDo.auditDataVersion})).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    public JPAQuery<AccountIocDTO> select(AccountIocParamVO param) {
        QAccountIocDO jpaQDo = QAccountIocDO.accountIocDO;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountIocDTO.class, (Expression[])new Expression[]{jpaQDo.id, jpaQDo.ioCode, jpaQDo.ioName, jpaQDo.ioType, jpaQDo.status, jpaQDo.remark, jpaQDo.createUserId, jpaQDo.creator, jpaQDo.createTime, jpaQDo.modifyUserId, jpaQDo.updater, jpaQDo.modifyTime, jpaQDo.deleteFlag, jpaQDo.tenantId, jpaQDo.auditDataVersion})).from((EntityPath)jpaQDo);
        if (Objects.nonNull(param)) {
            jpaQuery.where(this.where(param));
            if (!CollectionUtils.isEmpty((Collection)param.getOrders())) {
                param.fillOrders(jpaQuery, jpaQDo);
            }
        }
        jpaQuery.where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate where(AccountIocParamVO param) {
        QAccountIocDO jpaQDo = QAccountIocDO.accountIocDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        if (param.getId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty((String)param.getKeyword())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ioCode.like("%" + param.getKeyword() + "%").or((Predicate)jpaQDo.ioName.like("%" + param.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((String)param.getIoCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ioCode.eq((Object)param.getIoCode()));
        }
        if (!CollectionUtils.isEmpty(param.getIoCodeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ioCode.in(param.getIoCodeList()));
        }
        if (!StringUtils.isEmpty((String)param.getIoName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ioName.eq((Object)param.getIoName()));
        }
        if (!StringUtils.isEmpty((String)param.getIoType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ioType.eq((Object)param.getIoType()));
        }
        if (!StringUtils.isEmpty((String)param.getStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.status.eq((Object)param.getStatus()));
        }
        return predicate;
    }

    public JPAUpdateClause updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        QAccountIocDO jpaQDo = QAccountIocDO.accountIocDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)jpaQDo).set(jpaQDo.deleteFlag, (Object)deleteFlag).where(new Predicate[]{ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.in(idList))});
    }

    private <T> JPAQuery<T> query(Class<T> cls) {
        QAccountIocDO jpaQDo = QAccountIocDO.accountIocDO;
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{jpaQDo.id, jpaQDo.ioCode, jpaQDo.ioName, jpaQDo.ioType, jpaQDo.status, jpaQDo.remark, jpaQDo.createUserId, jpaQDo.creator, jpaQDo.createTime, jpaQDo.modifyUserId, jpaQDo.updater, jpaQDo.modifyTime, jpaQDo.deleteFlag, jpaQDo.tenantId, jpaQDo.auditDataVersion})).from((EntityPath)jpaQDo);
    }

    public List<AccountIocDTO> queryByAccountIocParam(AccountIocParam accountIocParam) {
        QAccountIocDO jpaQDo = QAccountIocDO.accountIocDO;
        JPAQuery<AccountIocDTO> jpaQuery = this.query(AccountIocDTO.class);
        if (CollectionUtils.isNotEmpty(accountIocParam.getIoCodeSet())) {
            jpaQuery.where((Predicate)jpaQDo.ioCode.in(accountIocParam.getIoCodeSet()));
        }
        if (CollectionUtils.isNotEmpty(accountIocParam.getIoNameSet())) {
            jpaQuery.where((Predicate)jpaQDo.ioName.in(accountIocParam.getIoNameSet()));
        }
        if (StringUtils.isNotEmpty((String)accountIocParam.getState())) {
            jpaQuery.where((Predicate)jpaQDo.status.in((Object[])new String[]{accountIocParam.getState()}));
        }
        return jpaQuery.fetch();
    }

    public AccountIocRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

