/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.creditaccount;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountInitialLimitDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.vo.creditaccount.InitialLimitPageVO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountInitialLimitDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CreditAccountInitialLimitRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountInitialLimitDO Q_DO = QCreditAccountInitialLimitDO.creditAccountInitialLimitDO;
    private final QCreditAccountDO Q_CA_DO = QCreditAccountDO.creditAccountDO;

    public List<CreditAccountInitialLimitDTO> findByParam(List<CreditAccountInitialLimitParam> params) {
        ArrayList predicates = new ArrayList();
        params.stream().forEach(param -> {
            Predicate predicate = this.commonBuilder((CreditAccountInitialLimitParam)((Object)param)).build();
            predicates.add(predicate);
        });
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CreditAccountInitialLimitDTO.class, (Expression[])new Expression[]{this.Q_DO.creditAccountCode, this.Q_DO.creditAccountName, this.Q_DO.status, this.Q_DO.id})).from((EntityPath)this.Q_DO)).where(ExpressionUtils.anyOf(predicates));
        return jpaQuery.fetch();
    }

    public PagingVO<InitialLimitPageVO> pageSearch(CreditAccountInitialLimitParam pageParam) {
        Predicate predicate = this.commonBuilder(pageParam).andLike(StrUtil.isNotBlank((CharSequence)pageParam.getObjectName()), (StringExpression)this.Q_CA_DO.objectName, pageParam.getObjectName()).andIn(CollectionUtils.isNotEmpty(pageParam.getIds()), this.Q_DO.id, pageParam.getIds()).build();
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.select(InitialLimitPageVO.class).innerJoin((EntityPath)this.Q_CA_DO)).on((Predicate)this.Q_DO.creditAccountCode.eq((Expression)this.Q_CA_DO.creditAccountCode))).where(predicate)).orderBy(this.Q_DO.createTime.desc());
        pageParam.setPaging(query);
        pageParam.fillOrders(query, this.Q_DO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.Q_DO.id, this.Q_DO.creditAccountCode, this.Q_DO.creditAccountName, this.Q_DO.initialAccountLimit.as("creditAccountLimit"), this.Q_DO.initialAccountAvailableLimit.as("creditAccountAvailableLimit"), this.Q_DO.initialAccountOccupancyLimit.as("creditAccountOccupancyLimit"), this.Q_DO.initialAccountUsedLimit.as("creditAccountUsedLimit"), this.Q_DO.finishedTime, this.Q_DO.status, this.Q_DO.remark, this.Q_DO.createTime, this.Q_DO.creator, this.Q_DO.createUserId, this.Q_DO.modifyTime, this.Q_DO.modifyUserId, this.Q_DO.updater, this.Q_DO.tenantId, this.Q_CA_DO.ouCode, this.Q_CA_DO.ouName, this.Q_CA_DO.objectType, this.Q_CA_DO.objectName, this.Q_CA_DO.creditAccountType, this.Q_CA_DO.objectCode, this.Q_CA_DO.salesmanName, this.Q_CA_DO.salesmanNo})).from((EntityPath)this.Q_DO);
    }

    private BaseRepoProc.PredicateBuilder commonBuilder(CreditAccountInitialLimitParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andLike(StrUtil.isNotBlank((CharSequence)param.getCreditAccountCodeName()), new StringExpression[]{this.Q_DO.creditAccountCode, this.Q_DO.creditAccountName}, param.getCreditAccountCodeName()).andEq(StrUtil.isNotBlank((CharSequence)param.getStatus()), (SimpleExpression)this.Q_DO.status, (Object)param.getStatus()).andEq(StrUtil.isNotBlank((CharSequence)param.getCreditAccountCode()), (SimpleExpression)this.Q_DO.creditAccountCode, (Object)param.getCreditAccountCode()).andEq(StrUtil.isNotBlank((CharSequence)param.getCreditAccountName()), (SimpleExpression)this.Q_DO.creditAccountName, (Object)param.getCreditAccountName());
    }

    public void deleteByAccountCodesAndStatus(Set<String> accountCodeList, String status) {
        this.jpaQueryFactory.update((EntityPath)this.Q_DO).set(this.Q_DO.deleteFlag, (Object)1).where(new Predicate[]{this.Q_DO.creditAccountCode.in(accountCodeList).and((Predicate)this.Q_DO.status.eq((Object)status))}).execute();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void logicDeleteByIds(List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)this.Q_DO).set(this.Q_DO.deleteFlag, (Object)1).where(new Predicate[]{this.Q_DO.id.in(ids)}).execute();
    }

    public CreditAccountInitialLimitRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

