/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.limitadjustorder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.dto.limitadjustorder.LimitAdjustOrderDTO;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.limitadjustorder.LimitAdjustOrderDO;
import com.elitesland.fin.entity.limitadjustorder.QLimitAdjustOrderDO;
import com.elitesland.fin.repo.limitadjustorder.LimitAdjustOrderRepo;
import com.elitesland.fin.utils.StringUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LimitAdjustOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QLimitAdjustOrderDO qLimitAdjustOrder = QLimitAdjustOrderDO.limitAdjustOrderDO;
    private final LimitAdjustOrderRepo limitAdjustOrderRepo;

    public PagingVO<LimitAdjustOrderDTO> page(LimitAdjustOrderParam limitAdjustOrderParam) {
        List<Predicate> where = this.where(limitAdjustOrderParam);
        JPAQuery query = (JPAQuery)this.select(LimitAdjustOrderDTO.class).where(ExpressionUtils.allOf(where));
        limitAdjustOrderParam.setPaging(query);
        limitAdjustOrderParam.fillOrders(query, this.qLimitAdjustOrder);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<LimitAdjustOrderDTO> queryByParam(LimitAdjustOrderParam limitAdjustOrderParam) {
        List<Predicate> where = this.where(limitAdjustOrderParam);
        JPAQuery query = (JPAQuery)this.select(LimitAdjustOrderDTO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    public List<AdjustOrderVO> queryByIds(List<Long> id) {
        return ((JPAQuery)this.select(AdjustOrderVO.class).where((Predicate)this.qLimitAdjustOrder.id.in(id))).fetch();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO) {
        this.jpaQueryFactory.update((EntityPath)this.qLimitAdjustOrder).set((Path)this.qLimitAdjustOrder.docState, (Object)status).set(this.qLimitAdjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)this.qLimitAdjustOrder.auditUser, (Object)sysUserDTO.getUsername()).where(new Predicate[]{this.qLimitAdjustOrder.id.in(ids)}).execute();
    }

    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)this.qLimitAdjustOrder).set((Path)this.qLimitAdjustOrder.docState, (Object)status).set(this.qLimitAdjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)this.qLimitAdjustOrder.auditUser, (Object)sysUserDTO.getUsername()).set((Path)this.qLimitAdjustOrder.auditRejectReason, (Object)reason).where(new Predicate[]{this.qLimitAdjustOrder.id.in(ids)}).execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)this.qLimitAdjustOrder).set((Path)this.qLimitAdjustOrder.docState, (Object)status).set(this.qLimitAdjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)this.qLimitAdjustOrder.auditUser, (Object)sysUserDTO.getUsername()).set((Path)this.qLimitAdjustOrder.auditRejectReason, (Object)reason).where(new Predicate[]{this.qLimitAdjustOrder.id.in(ids)}).execute();
    }

    public AdjustOrderVO queryById(Long id) {
        return (AdjustOrderVO)((Object)((JPAQuery)this.select(AdjustOrderVO.class).where((Predicate)this.qLimitAdjustOrder.id.eq((Object)id))).fetchOne());
    }

    private String buildLikeString(String string) {
        return "%".concat(string).concat("%");
    }

    private List<Predicate> where(LimitAdjustOrderParam limitAdjustOrderParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (limitAdjustOrderParam.getId() != null) {
            predicates.add((Predicate)this.qLimitAdjustOrder.id.eq((Object)limitAdjustOrderParam.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getDocNo())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.docNo.like(this.buildLikeString(limitAdjustOrderParam.getDocNo())));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getDocNoList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.docNo.in(limitAdjustOrderParam.getDocNoList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getCreditType())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.creditType.eq((Object)limitAdjustOrderParam.getCreditType()));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getCreditTypeList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.creditType.in(limitAdjustOrderParam.getCreditTypeList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getAdjustType())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.adjustType.eq((Object)limitAdjustOrderParam.getAdjustType()));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getAdjustTypeList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.adjustType.in(limitAdjustOrderParam.getAdjustTypeList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getDocState())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.docState.eq((Object)limitAdjustOrderParam.getDocState()));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getDocStateList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.docState.in(limitAdjustOrderParam.getDocStateList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getObjectName())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.objectName.like(this.buildLikeString(limitAdjustOrderParam.getObjectName())));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getObjectNameList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.objectName.in(limitAdjustOrderParam.getObjectNameList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getCreditAccountName())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.creditAccountName.like(this.buildLikeString(limitAdjustOrderParam.getCreditAccountName())));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getCreditAccountNameList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.creditAccountName.in(limitAdjustOrderParam.getCreditAccountNameList()));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.creditAccountCode.in(limitAdjustOrderParam.getCreditAccountCodeList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getAdjustReason())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.adjustReason.eq((Object)limitAdjustOrderParam.getAdjustReason()));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getAdjustReasonList())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.adjustReason.in(limitAdjustOrderParam.getAdjustReasonList()));
        }
        if (limitAdjustOrderParam.getCreateTimeStart() != null) {
            predicates.add((Predicate)this.qLimitAdjustOrder.createTime.goe((Comparable)limitAdjustOrderParam.getCreateTimeStart()));
        }
        if (limitAdjustOrderParam.getCreateTimeEnd() != null) {
            predicates.add((Predicate)this.qLimitAdjustOrder.createTime.loe((Comparable)limitAdjustOrderParam.getCreateTimeEnd()));
        }
        if (limitAdjustOrderParam.getAuditTimeStart() != null) {
            predicates.add((Predicate)this.qLimitAdjustOrder.auditTime.goe((Comparable)limitAdjustOrderParam.getAuditTimeStart()));
        }
        if (limitAdjustOrderParam.getAuditTimeEnd() != null) {
            predicates.add((Predicate)this.qLimitAdjustOrder.auditTime.loe((Comparable)limitAdjustOrderParam.getAuditTimeEnd()));
        }
        if (limitAdjustOrderParam.getCurrentTime() != null) {
            predicates.add((Predicate)this.qLimitAdjustOrder.expireTime.loe((Comparable)limitAdjustOrderParam.getCurrentTime()));
        }
        if (ObjectUtil.isNotNull((Object)limitAdjustOrderParam.getCurrEffectiveTime())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.effectiveTime.loe((Comparable)limitAdjustOrderParam.getCurrEffectiveTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)limitAdjustOrderParam.getRemark())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.remark.like(StringUtil.buildLikeString(limitAdjustOrderParam.getRemark())));
        }
        if (CollectionUtils.isNotEmpty(limitAdjustOrderParam.getIds())) {
            predicates.add((Predicate)this.qLimitAdjustOrder.id.in(limitAdjustOrderParam.getIds()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qLimitAdjustOrder.id, this.qLimitAdjustOrder.docNo, this.qLimitAdjustOrder.docState, this.qLimitAdjustOrder.creditType, this.qLimitAdjustOrder.adjustType, this.qLimitAdjustOrder.expireTime, this.qLimitAdjustOrder.ouCode, this.qLimitAdjustOrder.ouName, this.qLimitAdjustOrder.buCode, this.qLimitAdjustOrder.buName, this.qLimitAdjustOrder.productLine, this.qLimitAdjustOrder.saleUser, this.qLimitAdjustOrder.objectType, this.qLimitAdjustOrder.objectName, this.qLimitAdjustOrder.creditAccountCode, this.qLimitAdjustOrder.creditAccountName, this.qLimitAdjustOrder.adjustLimit, this.qLimitAdjustOrder.adjustReason, this.qLimitAdjustOrder.auditUser, this.qLimitAdjustOrder.auditTime, this.qLimitAdjustOrder.auditRejectReason, this.qLimitAdjustOrder.creator, this.qLimitAdjustOrder.createTime, this.qLimitAdjustOrder.updater, this.qLimitAdjustOrder.modifyTime, this.qLimitAdjustOrder.remark, this.qLimitAdjustOrder.workflowProcInstId.as("procInstId"), this.qLimitAdjustOrder.workflowProcInstStatus.as("procInstStatus"), this.qLimitAdjustOrder.workflowSubmitTime, this.qLimitAdjustOrder.workflowEndTime, this.qLimitAdjustOrder.workflowCurrentNodeKey, this.qLimitAdjustOrder.workflowCurrentNodeName, this.qLimitAdjustOrder.workflowCurrentUserIds, this.qLimitAdjustOrder.workflowRejectedMessage, this.qLimitAdjustOrder.effectiveTime, this.qLimitAdjustOrder.fileCode})).from((EntityPath)this.qLimitAdjustOrder);
    }

    public LimitAdjustOrderDO findById(Long id) {
        Optional limitAdjustOrderDOOptional = this.limitAdjustOrderRepo.findById(id);
        Assert.isTrue((boolean)limitAdjustOrderDOOptional.isPresent(), (String)"\u67e5\u4e0d\u5230\u989d\u5ea6\u8c03\u6574\u5355", (Object[])new Object[0]);
        return (LimitAdjustOrderDO)((Object)limitAdjustOrderDOOptional.get());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDocStateByIds(LimitAdjustOrderParam limitAdjustOrderParam) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qLimitAdjustOrder);
        if (limitAdjustOrderParam.getDocState() != null) {
            jpaUpdateClause.set((Path)this.qLimitAdjustOrder.docState, (Object)limitAdjustOrderParam.getDocState());
        }
        jpaUpdateClause.where(new Predicate[]{this.qLimitAdjustOrder.id.in(limitAdjustOrderParam.getIds())});
        jpaUpdateClause.execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateWorkflow(LimitAdjustOrderDO limitAdjustOrderDO, ProcessInfo processInfo) {
        QLimitAdjustOrderDO qLimitAdjustOrderDO = QLimitAdjustOrderDO.limitAdjustOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qLimitAdjustOrderDO).set((Path)qLimitAdjustOrderDO.workflowProcInstId, (Object)processInfo.getProcInstId()).set(qLimitAdjustOrderDO.workflowSubmitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qLimitAdjustOrderDO.id.eq((Object)limitAdjustOrderDO.getId())});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qLimitAdjustOrderDO.workflowProcInstStatus, (Object)ProcInstStatus.APPROVING);
            jpaUpdateClause.set((Path)qLimitAdjustOrderDO.docState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        jpaUpdateClause.execute();
    }

    public LimitAdjustOrderRepoProc(JPAQueryFactory jpaQueryFactory, LimitAdjustOrderRepo limitAdjustOrderRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.limitAdjustOrderRepo = limitAdjustOrderRepo;
    }
}

