/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitesland.fin.application.facade.dto.accountingengine.PageParam;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineJdbcService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineConfigDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableLineDO;
import com.mysql.cj.MysqlType;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FinAccountEngineJdbcServiceImpl
implements FinAccountEngineJdbcService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountEngineJdbcServiceImpl.class);
    private final UdcProvider udcProvider;
    private final TenantClientProvider tenantClientProvider;
    @Value(value="${fin.journal.batchSaveSize:1}")
    private int batchSize = 1;

    @Override
    public void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Connection getJournalConnection(FinAccountEngineDO finAccountEngineDO) throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.cj.jdbc.Driver");
        Connection connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finAccountEngineDO.getJournalHost(), finAccountEngineDO.getJournalPort(), finAccountEngineDO.getJournalDatabase()), finAccountEngineDO.getJournalUser(), finAccountEngineDO.getJournalPassword());
        return connection;
    }

    @Override
    public Connection getEventTableConnection(FinEventTableDO finEventTableDO) throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.cj.jdbc.Driver");
        Connection connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finEventTableDO.getHost(), finEventTableDO.getPort(), finEventTableDO.getDatabaseName()), finEventTableDO.getUserName(), finEventTableDO.getPassword());
        return connection;
    }

    @Override
    public int updateProposedStatus(FinEventTableDO finEventTableDO, Connection connection, Long masId, String proposedStatus) throws SQLException {
        String updateProposedStatusSql = "update " + finEventTableDO.getMasTable() + " set proposed_status='" + proposedStatus + "' where (proposed_status !='" + UdcEnum.DOC_PROPOSED_STATUS_PROPOSING.getValueCode() + "') and " + finEventTableDO.getMasTableColumn() + " = " + masId;
        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
        log.info("\u66f4\u65b0\u62df\u5b9a\u72b6\u6001sql:\n{}", (Object)updateProposedStatusSql);
        int res = preparedStatement.executeUpdate();
        try {
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Assert.isTrue((res == 1 ? 1 : 0) != 0, (String)"\u5355\u636e\u66f4\u65b0\u4e3a\u62df\u5b9a\u4e2d\u5931\u8d25", (Object[])new Object[0]);
        return res;
    }

    @Override
    public int batchUpdateProposedStatus(FinEventTableDO finEventTableDO, Connection connection, Set<Long> masIds, String proposedStatus) throws SQLException {
        if (CollectionUtils.isEmpty(masIds)) {
            return 0;
        }
        String masIdStr = this.getIdsJoinString(masIds);
        String updateProposedStatusSql = "update " + finEventTableDO.getMasTable() + " set proposed_status='" + proposedStatus + "' where (proposed_status ='" + UdcEnum.DOC_PROPOSED_STATUS_PROPOSING.getValueCode() + "') and " + finEventTableDO.getMasTableColumn() + " in (" + masIdStr + ")";
        log.info("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u72b6\u6001sql:\n{}", (Object)updateProposedStatusSql);
        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
        int res = preparedStatement.executeUpdate();
        try {
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Assert.isTrue((res == masIds.size() ? 1 : 0) != 0, (String)"\u5355\u636e\u66f4\u65b0\u4e3a\u62df\u5b9a\u4e2d\u5931\u8d25", (Object[])new Object[0]);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map> queryEventTableData(Connection connection, FinAccountEngineConfigDO finAccountEngineConfigDO, boolean manualFlag, List<Long> docIds) throws SQLException {
        FinEventTableDO finEventTableDO = finAccountEngineConfigDO.getFinEventTableDO();
        FinAccountEngineDO finAccountEngineDO = finAccountEngineConfigDO.getFinAccountEngineDO();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String sql = this.buildSql(finAccountEngineConfigDO, null, manualFlag, docIds);
        sql = this.addTenantCondition(sql, finEventTableDO.getMasTable(), finEventTableDO.getTableName());
        log.info("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{},\u4e1a\u52a1\u5355\u636e\u67e5\u8be2sql:\n{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), sql});
        try {
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Map> resultList = new ArrayList<Map>();
            String[] columnLabels = null;
            boolean isFirst = true;
            int columnCount = 0;
            while (resultSet.next()) {
                int i;
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (isFirst) {
                    columnCount = resultSet.getMetaData().getColumnCount();
                    columnLabels = new String[columnCount];
                    for (i = 1; i <= columnCount; ++i) {
                        columnLabels[i - 1] = resultSet.getMetaData().getColumnLabel(i);
                        map.put(columnLabels[i - 1], resultSet.getObject(columnLabels[i - 1]));
                    }
                    isFirst = false;
                } else {
                    for (i = 0; i < columnCount; ++i) {
                        map.put(columnLabels[i], resultSet.getObject(columnLabels[i]));
                    }
                }
                resultList.add(map);
            }
            ArrayList<Map> arrayList = resultList;
            return arrayList;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map> purePageQueryEventTableData(Connection connection, FinAccountEngineConfigDO finAccountEngineConfigDO, boolean manualFlag, List<Long> docIds, PageParam pageParam) throws SQLException {
        FinEventTableDO finEventTableDO = finAccountEngineConfigDO.getFinEventTableDO();
        FinAccountEngineDO finAccountEngineDO = finAccountEngineConfigDO.getFinAccountEngineDO();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String sql = this.buildSql(finAccountEngineConfigDO, null, manualFlag, docIds);
        sql = this.addTenantCondition(sql, finEventTableDO.getMasTable(), finEventTableDO.getTableName());
        sql = this.handlePage(sql, finAccountEngineConfigDO, pageParam.getLimit(), pageParam.getOffset());
        log.info("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{},\u4e1a\u52a1\u5355\u636e\u67e5\u8be2sql:\n{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), sql});
        try {
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Map> resultList = new ArrayList<Map>();
            String[] columnLabels = null;
            boolean isFirst = true;
            int columnCount = 0;
            while (resultSet.next()) {
                int i;
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (isFirst) {
                    columnCount = resultSet.getMetaData().getColumnCount();
                    columnLabels = new String[columnCount];
                    for (i = 1; i <= columnCount; ++i) {
                        columnLabels[i - 1] = resultSet.getMetaData().getColumnLabel(i);
                        map.put(columnLabels[i - 1], resultSet.getObject(columnLabels[i - 1]));
                    }
                    isFirst = false;
                } else {
                    for (i = 0; i < columnCount; ++i) {
                        map.put(columnLabels[i], resultSet.getObject(columnLabels[i]));
                    }
                }
                resultList.add(map);
            }
            ArrayList<Map> arrayList = resultList;
            return arrayList;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public List<Map> pageQueryEventTableData(Connection connection, FinAccountEngineConfigDO finAccountEngineConfigDO, boolean manualFlag, List<Long> docIds, PageParam pageParam) throws SQLException {
        int limit = pageParam.getLimit();
        int offset = pageParam.getOffset();
        List<Map> purePageData = this.purePageQueryEventTableData(connection, finAccountEngineConfigDO, manualFlag, docIds, pageParam);
        if (CollectionUtils.isEmpty(purePageData)) {
            return null;
        }
        if (finAccountEngineConfigDO.isMasTableOnly()) {
            pageParam.setOffset(limit + offset);
            return purePageData;
        }
        if (purePageData.size() < limit) {
            return purePageData;
        }
        long lastMainId = (Long)purePageData.get(purePageData.size() - 1).get("main_id");
        ArrayList<Long> lastDocIds = new ArrayList<Long>();
        lastDocIds.add(lastMainId);
        List<Map> lastMainData = this.queryEventTableData(connection, finAccountEngineConfigDO, manualFlag, lastDocIds);
        if (CollectionUtils.isEmpty(lastMainData)) {
            return purePageData;
        }
        Map purePageDataMap = purePageData.stream().collect(Collectors.groupingBy(v -> v.get("main_id"), Collectors.toList()));
        List existLastMainData = purePageDataMap.get(lastMainId);
        Map<Object, Map> existLastMainDataMap = existLastMainData.stream().collect(Collectors.toMap(v -> v.get("detail_id"), v -> v));
        purePageData.addAll(lastMainData.stream().filter(v -> !existLastMainDataMap.containsKey(v.get("detail_id"))).collect(Collectors.toList()));
        int diffSize = lastMainData.size() - existLastMainData.size();
        offset = offset + limit + diffSize;
        pageParam.setOffset(offset);
        return purePageData;
    }

    private String handlePage(String srcSql, FinAccountEngineConfigDO finAccountEngineConfigDO, int limit, int offset) {
        FinEventTableDO finEventTableDO = finAccountEngineConfigDO.getFinEventTableDO();
        StringBuilder pageQueryClause = new StringBuilder();
        String tableOrder = finEventTableDO.getTableOrder();
        String masTableOrder = finEventTableDO.getMasTableOrder();
        if (StringUtils.isNotBlank((CharSequence)masTableOrder)) {
            pageQueryClause.append(" order by ").append(finEventTableDO.getMasTable()).append(".").append(masTableOrder);
        }
        if (StringUtils.isNotBlank((CharSequence)tableOrder)) {
            if (pageQueryClause.toString().length() < 1) {
                pageQueryClause.append(" order by ").append(finEventTableDO.getTableName()).append(".").append(tableOrder);
            } else {
                pageQueryClause.append(",").append(finEventTableDO.getTableName()).append(".").append(tableOrder);
            }
        }
        pageQueryClause.append(" limit ").append(limit).append(" offset ").append(offset);
        return srcSql + pageQueryClause.toString();
    }

    @Override
    public void deleteExistJournal(Connection eventTableConnection, Connection journalConnection, FinAccountEngineConfigDO finAccountEngineConfigDO, List<String> docNums, List<Long> docIds) {
        if (CollectionUtils.isEmpty(docNums)) {
            return;
        }
        FinAccountEngineDO finAccountEngineDO = finAccountEngineConfigDO.getFinAccountEngineDO();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDO.getFinEventTableDO();
        String journalTable = finAccountEngineDO.getJournalTable();
        String docNumsString = docNums.stream().map(v -> "'".concat((String)v).concat("'")).reduce((v1, v2) -> v1.concat(",").concat((String)v2)).get();
        String docIdsString = docIds.stream().map(v -> "'".concat(v.toString()).concat("'")).reduce((v1, v2) -> v1.concat(",").concat((String)v2)).get();
        String sql = "delete from " + journalTable + " where doc_num in (" + docNumsString + ") or doc_num in (" + docIdsString + ")";
        log.info("\u624b\u52a8\u62df\u5b9a,\u4e8b\u4ef6\u8868\u5355:{},\u5220\u9664\u5df2\u6709\u7684\u4f1a\u8ba1\u51ed\u8bc1sql :\n{}", (Object)finEventTableDO.getEventTable(), (Object)sql);
        PreparedStatement preparedStatement = null;
        int result = 0;
        try {
            preparedStatement = journalConnection.prepareStatement(sql);
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            log.error("\u624b\u52a8\u62df\u5b9a,\u4e8b\u4ef6\u8868\u5355:{},\u5220\u9664\u5df2\u6709\u7684\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38", (Object)finEventTableDO.getEventTable(), (Object)e);
            throw new BusinessException("\u5220\u9664\u5df2\u6709\u7684\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38");
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getDocNumStrsFromDocIds(Connection eventTableConnection, FinAccountEngineConfigDO finAccountEngineConfigDO, List<Long> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return null;
        }
        FinEventTableDO finEventTableDO = finAccountEngineConfigDO.getFinEventTableDO();
        String masTable = finEventTableDO.getMasTable();
        String columnDocNum = finAccountEngineConfigDO.getFinAccountEngineDO().getColumnDocNum();
        Optional<String> docIdsStrs = docIds.stream().map(v -> v.toString()).reduce((v1, v2) -> v1.concat(",").concat((String)v2));
        String sql = "select " + columnDocNum + "  from " + masTable + " where id in (" + docIdsStrs.get() + ")";
        log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\uff0c\u4e8b\u4ef6\u8868\u5355:{},\u6839\u636edocId\u67e5\u8be2docNum sql:\n{}", (Object)finEventTableDO.getEventTable(), (Object)sql);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = eventTableConnection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            String docNumStrs = "";
            while (resultSet.next()) {
                docNumStrs.concat(",").concat(resultSet.getString(columnDocNum));
            }
            String string = docNumStrs;
            return string;
        }
        catch (SQLException e) {
            log.error("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210,\u4e8b\u4ef6\u8868\u5355:{},\u6839\u636edocId\u67e5\u8be2docNum\u5f02\u5e38", (Object)finEventTableDO.getEventTable(), (Object)e);
            throw new BusinessException("\u6839\u636edocId\u67e5\u8be2docNum\u5f02\u5e38");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void finJournalBatchSave(FinAccountEngineDO finAccountEngineDO, Connection journalConnection, List<Map> saveMapList) {
        if (CollectionUtils.isEmpty(saveMapList)) {
            return;
        }
        Set keySet = saveMapList.get(0).keySet();
        ArrayList columnList = new ArrayList(keySet);
        Optional<String> stationsymbolCollect = columnList.stream().map(v -> "?").reduce((v1, v2) -> v1.concat(",").concat((String)v2));
        String sql = "insert".concat(" ").concat("into").concat(" ").concat(finAccountEngineDO.getJournalTable()).concat(" ").concat("(").concat(StringUtils.join(columnList, (String)",")).concat(")").concat(" ").concat("values").concat("(").concat(stationsymbolCollect.get()).concat(")");
        log.info("\u63d2\u5165\u4f1a\u8ba1\u5206\u5f55sql: " + sql);
        PreparedStatement preparedStatement = null;
        try {
            int count = 0;
            preparedStatement = journalConnection.prepareStatement(sql);
            for (Map map : saveMapList) {
                Object value = null;
                for (int i = 0; i < columnList.size(); ++i) {
                    value = map.get(columnList.get(i));
                    if (value instanceof String) {
                        preparedStatement.setString(i + 1, value);
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        preparedStatement.setBigDecimal(i + 1, value);
                        continue;
                    }
                    if (value instanceof Long) {
                        preparedStatement.setLong(i + 1, (Long)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        preparedStatement.setInt(i + 1, (Integer)value);
                        continue;
                    }
                    if (value instanceof LocalDateTime) {
                        preparedStatement.setObject(i + 1, value, (SQLType)MysqlType.DATETIME);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        preparedStatement.setObject(i + 1, value, (SQLType)MysqlType.DATETIME);
                        continue;
                    }
                    log.warn("\u5f02\u5e38\u7c7b\u578b\u5b57\u6bb5{}:{}:{}", new Object[]{i, columnList.get(i), value});
                }
                preparedStatement.addBatch();
                if (++count % this.batchSize != 0) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            if (count % this.batchSize != 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            log.error("\u4fdd\u5b58\u4f1a\u8ba1\u51ed\u8bc1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u4f1a\u8ba1\u51ed\u8bc1\u5931\u8d25");
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String addTenantCondition(String sql, String mainTableName, String detailTableName) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return sql;
        }
        long tenantId = -1L;
        if (this.tenantClientProvider.getSessionTenant() != null) {
            tenantId = this.tenantClientProvider.getSessionTenant().getId();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainTableName})) {
            sql = (String)sql + " and " + mainTableName + ".tenant_id=" + tenantId;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{detailTableName})) {
                sql = (String)sql + " and " + detailTableName + ".tenant_id=" + tenantId;
            }
        }
        return sql;
    }

    private String buildSql(FinAccountEngineConfigDO finAccountEngineConfigDO, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList, boolean manualFlag, List<Long> docIds) {
        List<FinEventTableConditionDO> finEventTableProposedConditionList = finAccountEngineConfigDO.getFinEventTableProposedConditionList();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDO.getFinEventTableDO();
        if (!finAccountEngineConfigDO.isMasTableOnly()) {
            return "select".concat(" ").concat(this.buildFields(finAccountEngineConfigDO.getFinEventTableLineDOList())).concat(",").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTable().concat(".").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTableColumn()).concat(" as main_id")).concat(",").concat(finAccountEngineConfigDO.getFinEventTableDO().getTableName().concat(".").concat("id").concat(" as detail_id")).concat(" ").concat("from").concat(" ").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTable()).concat(" ").concat("inner").concat(" ").concat("join").concat(" ").concat(finAccountEngineConfigDO.getFinEventTableDO().getTableName()).concat(" ").concat("where").concat(" ").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTable()).concat(".").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTableColumn()).concat(" ").concat("=").concat(" ").concat(finAccountEngineConfigDO.getFinEventTableDO().getTableName()).concat(".").concat(finAccountEngineConfigDO.getFinEventTableDO().getTableColumn()).concat(" ").concat("and").concat(" ").concat(this.buildWhere(finAccountEngineConfigDO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList, finEventTableProposedConditionList, finEventTableDO, manualFlag, docIds));
        }
        return "select".concat(" ").concat(this.buildFields(finAccountEngineConfigDO.getFinEventTableLineDOList())).concat(",").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTable().concat(".").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTableColumn()).concat(" as main_id")).concat(" ").concat("from").concat(" ").concat(finAccountEngineConfigDO.getFinEventTableDO().getMasTable()).concat(" ").concat("where").concat(" ").concat(this.buildWhere(finAccountEngineConfigDO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList, finEventTableProposedConditionList, finEventTableDO, manualFlag, docIds));
    }

    private String buildFields(List<FinEventTableLineDO> finEventTableLineDOList) {
        List fieldList = finEventTableLineDOList.stream().map(item -> item.getTableName().concat(".").concat(item.getColumnName())).collect(Collectors.toList());
        return StringUtils.join(fieldList, (String)",");
    }

    private String buildWhere(List<FinEventTableConditionDO> finEventTableConditionDOList, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList, List<FinEventTableConditionDO> finEventTableProposedConditionList, FinEventTableDO finEventTableDO, boolean manualFlag, List<Long> docIds) {
        String whereSql = "proposed_status != 'PROPOSING' and proposed_status is not null ";
        ArrayList wheres = new ArrayList();
        if (CollectionUtils.isNotEmpty(finEventTableConditionDOList)) {
            wheres.addAll(finEventTableConditionDOList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(wheres)) {
            whereSql = whereSql.concat(" and ").concat(StringUtils.join(wheres, (String)" ".concat("and").concat(" ")));
        }
        if (CollectionUtils.isNotEmpty(docIds)) {
            String masIdStr = this.getIdsJoinString(docIds);
            whereSql = whereSql.concat(" ".concat("and").concat(" ").concat(finEventTableDO.getMasTable().concat(".").concat(finEventTableDO.getMasTableColumn()).concat(" ").concat("in ").concat("(" + masIdStr + ")")));
        }
        if (manualFlag) {
            return whereSql;
        }
        if (CollectionUtils.isEmpty(finEventTableProposedConditionList)) {
            return whereSql;
        }
        List proposedConditions = finEventTableProposedConditionList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList());
        String ngWhereSql = StringUtils.join(proposedConditions, (String)" ".concat("and").concat(" "));
        return whereSql.concat(" ".concat("and").concat(" ").concat("!(")).concat(" ").concat(ngWhereSql).concat(" ").concat(")");
    }

    private String buildWhere(String conditionType, String tableName, String columnName, String valueFrom, String valueTo) {
        Map eventTableConditionUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        conditionType = (String)eventTableConditionUdc.get(conditionType);
        String concat = tableName.concat(".").concat(columnName).concat(" ");
        if (UdcEnum.EVENT_TABLE_CONDITION_BETWEEN_AND.getValueCode().equals(conditionType)) {
            return concat.concat("between").concat(" ").concat("'").concat(valueFrom).concat("'").concat(" ").concat("and").concat(" ").concat("'").concat(valueTo).concat("'");
        }
        concat = concat.concat(conditionType).concat(" ");
        if (valueFrom != null) {
            concat = concat.concat("'" + valueFrom + "'");
        }
        return concat;
    }

    private String getIdsJoinString(Collection<Long> ids) {
        String masIdStr = null;
        if (ids.size() == 1) {
            masIdStr = ids.toArray()[0].toString();
        } else {
            StringBuilder sb = new StringBuilder();
            for (Long masId : ids) {
                sb.append(masId.toString().concat(","));
            }
            masIdStr = sb.substring(0, sb.length() - 1);
        }
        return masIdStr;
    }

    public FinAccountEngineJdbcServiceImpl(UdcProvider udcProvider, TenantClientProvider tenantClientProvider) {
        this.udcProvider = udcProvider;
        this.tenantClientProvider = tenantClientProvider;
    }
}

