/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.paymentperiod;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeConvert;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeOuConvert;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeComPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuMainSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangePageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;
import com.elitesland.fin.application.service.paymentperiod.AgingRangeService;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeDomainService;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeDtlDomainService;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeOuDomainService;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuHandleDTO;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepoProc;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgingRangeServiceImpl
implements AgingRangeService {
    private static final Logger log = LoggerFactory.getLogger(AgingRangeServiceImpl.class);
    private final AgingRangeDomainService domainService;
    private final AgingRangeDtlDomainService dtlDomainService;
    private final AgingRangeRepo agingRangeRepo;
    private final AgingRangeRepoProc agingRangeRepoProc;
    private final AgingRangeDtlRepo agingRangeDtlRepo;
    private final AgingRangeDtlRepoProc agingRangeDtlRepoProc;
    private final SysNumberGenerator sysNumberGeneratorWrapper;
    private final UdcProvider udcProvider;
    private final AgingRangeOuDomainService agingRangeOuDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(AgingRangeSaveParam saveParam) {
        List<AgingRangeDtlSaveParam> dtlSaveParamList = saveParam.getDtlSaveParamList();
        this.checkMandatoryField(saveParam);
        this.checkMandatoryFieldDtlList(dtlSaveParamList);
        AgingRangeVO AgingRangeVO2 = null;
        Boolean flag = true;
        if (Objects.nonNull(saveParam.getId())) {
            AgingRangeVO2 = this.domainService.findById(saveParam.getId());
            this.checkUpdateBusiness(AgingRangeVO2);
            flag = false;
        }
        this.checkSave(saveParam, flag);
        this.checkSaveDtl(saveParam, dtlSaveParamList, flag);
        this.saveDefaultValue(flag, saveParam, AgingRangeVO2);
        Long id = this.domainService.save(saveParam);
        saveParam.setId(id);
        this.dtlDomainService.deleteByMasId(id);
        this.saveDtlDefaultValue(dtlSaveParamList, saveParam);
        this.dtlDomainService.saveDtl(dtlSaveParamList);
        return id;
    }

    private void saveDefaultValue(Boolean flag, AgingRangeSaveParam saveVO, AgingRangeVO respVO) {
        if (!flag.booleanValue() && StringUtils.isBlank((CharSequence)saveVO.getAgingRangeCode())) {
            saveVO.setAgingRangeCode(respVO.getAgingRangeCode());
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getStatus())) {
            saveVO.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
    }

    private void saveDtlDefaultValue(List<AgingRangeDtlSaveParam> dtlSaveVOList, AgingRangeSaveParam saveVO) {
        dtlSaveVOList.forEach(dtlSaveVO -> {
            dtlSaveVO.setMasId(saveVO.getId());
            if (Objects.nonNull(dtlSaveVO.getPaymentPeriodEnd())) {
                if (dtlSaveVO.getPaymentPeriodBegin() == 0) {
                    Integer differenceValue = dtlSaveVO.getPaymentPeriodEnd() - dtlSaveVO.getPaymentPeriodBegin();
                    dtlSaveVO.setTotalPeriod(differenceValue);
                } else {
                    Integer differenceValue = dtlSaveVO.getPaymentPeriodEnd() - dtlSaveVO.getPaymentPeriodBegin() + 1;
                    dtlSaveVO.setTotalPeriod(differenceValue);
                }
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(AgingRangeSaveParam saveParam) {
        return null;
    }

    private void checkSave(AgingRangeSaveParam saveVO, Boolean flag) {
        AgingRangePageParam pageParam1 = new AgingRangePageParam();
        pageParam1.setAgingRangeCode(saveVO.getAgingRangeCode());
        AgingRangeVO agreementVO1 = this.domainService.checkSelectByParam(pageParam1);
        if (flag != false ? Objects.nonNull(agreementVO1) && Objects.equals(agreementVO1.getAgingRangeCode(), saveVO.getAgingRangeCode()) : Objects.nonNull(agreementVO1) && Objects.equals(agreementVO1.getAgingRangeCode(), saveVO.getAgingRangeCode()) && !Objects.equals(saveVO.getId(), agreementVO1.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7f16\u7801\u5df2\u5b58\u5728!");
        }
        AgingRangePageParam pageParam2 = new AgingRangePageParam();
        pageParam2.setAgingRangeName(saveVO.getAgingRangeName());
        AgingRangeVO agreementVO2 = this.domainService.checkSelectByParam(pageParam2);
        if (flag != false ? Objects.nonNull(agreementVO2) && Objects.equals(agreementVO2.getAgingRangeName(), saveVO.getAgingRangeName()) : Objects.nonNull(agreementVO2) && Objects.equals(agreementVO2.getAgingRangeName(), saveVO.getAgingRangeName()) && !Objects.equals(saveVO.getId(), agreementVO2.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u540d\u79f0\u5df2\u5b58\u5728!");
        }
    }

    private void checkSaveDtl(AgingRangeSaveParam saveVO, List<AgingRangeDtlSaveParam> dtlSaveVOList, Boolean flag) {
        AgingRangeDtlSaveParam agingRangeDtlSaveParam;
        if (dtlSaveVOList.size() > 1) {
            List sortedDtlList = dtlSaveVOList.stream().sorted(Comparator.comparing(AgingRangeDtlSaveParam::getLineNo).reversed()).collect(Collectors.toList());
            for (int i = 0; i < sortedDtlList.size(); ++i) {
                AgingRangeDtlSaveParam currentSaveParam = (AgingRangeDtlSaveParam)sortedDtlList.get(i);
                if (i == sortedDtlList.size() - 1) {
                    if (currentSaveParam.getPaymentPeriodBegin() == 0) continue;
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + currentSaveParam.getLineNo() + "\u884c\u7684\u884c\u53f7\u4e3a1\u65f6,\u8d26\u671f\u5f00\u59cb\u5fc5\u987b\u662f0");
                }
                AgingRangeDtlSaveParam previousSaveParam = (AgingRangeDtlSaveParam)sortedDtlList.get(i + 1);
                if (Objects.isNull(previousSaveParam.getPaymentPeriodEnd())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + previousSaveParam.getLineNo() + "\u884c\u7684\u8d26\u671f\u7ed3\u675f\u4e3a\u7a7a");
                }
                Integer differenceValue = currentSaveParam.getPaymentPeriodBegin() - previousSaveParam.getPaymentPeriodEnd();
                if (differenceValue != 1) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + previousSaveParam.getLineNo() + "\u884c\u7684\u8d26\u671f\u7ed3\u675f\u4e0e\u7b2c" + currentSaveParam.getLineNo() + "\u884c\u7684\u8d26\u671f\u5f00\u59cb\u5fc5\u987b\u8fde\u7eed\u3001\u4e0d\u80fd\u76f8\u540c");
                }
                if (previousSaveParam.getLineNo() != 1 || previousSaveParam.getPaymentPeriodBegin() == 0) continue;
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c" + previousSaveParam.getLineNo() + "\u884c\u7684\u884c\u53f7\u4e3a1\u65f6,\u8d26\u671f\u5f00\u59cb\u5fc5\u987b\u662f0");
            }
        } else if (dtlSaveVOList.size() == 1 && (agingRangeDtlSaveParam = dtlSaveVOList.get(0)).getPaymentPeriodBegin() != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u884c\u53f71\u65f6,\u8d26\u671f\u5f00\u59cb\u5fc5\u987b\u662f0");
        }
    }

    private void checkUpdateBusiness(AgingRangeVO respVO) {
        if (!Objects.equals(respVO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u624d\u53ef\u7f16\u8f91\u4fee\u6539!");
        }
    }

    private void checkMandatoryField(AgingRangeSaveParam saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getAgingRangeCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u9f84\u533a\u95f4\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getAgingRangeName())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u9f84\u533a\u95f4\u540d\u79f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getTimeUnitType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65f6\u95f4\u5355\u4f4d\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getUnitDays())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5355\u4f4d\u5929\u6570\u4e3a\u7a7a!");
        }
    }

    private void checkMandatoryFieldDtlList(List<AgingRangeDtlSaveParam> saveVOList) {
        if (!CollectionUtils.isEmpty(saveVOList)) {
            saveVOList.forEach(saveVO -> this.checkMandatoryFieldDtl((AgingRangeDtlSaveParam)saveVO));
        }
    }

    private void checkMandatoryFieldDtl(AgingRangeDtlSaveParam saveVO) {
        if (Objects.isNull(saveVO.getLineNo())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u884c\u53f7\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getPaymentPeriodDesc())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u63cf\u8ff0\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getPaymentPeriodBegin())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u5f00\u59cb\u4e3a\u7a7a!");
        }
    }

    private String getProtocolCode() {
        String code = this.sysNumberGeneratorWrapper.generate("AGREEMENT_PROTOCOL_CODE");
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u751f\u6210\u8d26\u9f84\u533a\u95f4\u7f16\u7801\u5931\u8d25!");
        }
        return code;
    }

    @Override
    @SysCodeProc
    public PagingVO<AgingRangePagingVO> page(AgingRangePageParam pageParam) {
        PagingVO<AgingRangePagingVO> pagingVO = this.domainService.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List pagingVOList = pagingVO.getRecords();
        Map yearTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getModel(), UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getCode());
        Map monthTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getModel(), UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getCode());
        Map dayTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getModel(), UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getCode());
        pagingVOList.forEach(agingRangePagingVO -> {
            String unitDays = agingRangePagingVO.getUnitDays();
            String timeUnitType = agingRangePagingVO.getTimeUnitType();
            if (StringUtils.isNotBlank((CharSequence)unitDays)) {
                if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_YEAR.getValueCode()) && MapUtil.isNotEmpty((Map)yearTypeUnitDaysUdc)) {
                    agingRangePagingVO.setUnitDaysName((String)yearTypeUnitDaysUdc.get(unitDays));
                } else if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_MONTH.getValueCode()) && MapUtil.isNotEmpty((Map)monthTypeUnitDaysUdc)) {
                    agingRangePagingVO.setUnitDaysName((String)monthTypeUnitDaysUdc.get(unitDays));
                } else if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_DAY.getValueCode()) && MapUtil.isNotEmpty((Map)dayTypeUnitDaysUdc)) {
                    agingRangePagingVO.setUnitDaysName((String)dayTypeUnitDaysUdc.get(unitDays));
                }
            }
        });
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVOList).build();
    }

    @Override
    @SysCodeProc
    public AgingRangeVO findIdOne(Long id) {
        AgingRangeVO agreementVO = this.domainService.selectById(id);
        this.translateAgingRange(Collections.singletonList(agreementVO));
        List<AgingRangeDtlVO> agreementDtlVOList = this.dtlDomainService.selectByMasId(agreementVO.getId());
        if (CollectionUtils.isEmpty(agreementDtlVOList)) {
            return agreementVO;
        }
        this.translateDtl(agreementDtlVOList);
        agreementVO.setDtlVOList(agreementDtlVOList);
        return agreementVO;
    }

    @Override
    @SysCodeProc
    public AgingRangeVO findCodeOne(String code) {
        AgingRangeVO agreementVO = this.domainService.selectByCode(code);
        this.translateAgingRange(Collections.singletonList(agreementVO));
        List<AgingRangeDtlVO> agreementDtlVOList = this.dtlDomainService.selectByMasId(agreementVO.getId());
        if (CollectionUtils.isEmpty(agreementDtlVOList)) {
            return agreementVO;
        }
        this.translateDtl(agreementDtlVOList);
        agreementVO.setDtlVOList(agreementDtlVOList);
        return agreementVO;
    }

    private void translateAgingRange(List<AgingRangeVO> respVOList) {
        Map yearTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getModel(), UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getCode());
        Map monthTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getModel(), UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getCode());
        Map dayTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getModel(), UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getCode());
        respVOList.forEach(agingRangeVO -> {
            String unitDays = agingRangeVO.getUnitDays();
            String timeUnitType = agingRangeVO.getTimeUnitType();
            if (StringUtils.isNotBlank((CharSequence)unitDays)) {
                if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_YEAR.getValueCode()) && MapUtil.isNotEmpty((Map)yearTypeUnitDaysUdc)) {
                    agingRangeVO.setUnitDaysName((String)yearTypeUnitDaysUdc.get(unitDays));
                } else if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_MONTH.getValueCode()) && MapUtil.isNotEmpty((Map)monthTypeUnitDaysUdc)) {
                    agingRangeVO.setUnitDaysName((String)monthTypeUnitDaysUdc.get(unitDays));
                } else if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_DAY.getValueCode()) && MapUtil.isNotEmpty((Map)dayTypeUnitDaysUdc)) {
                    agingRangeVO.setUnitDaysName((String)dayTypeUnitDaysUdc.get(unitDays));
                }
            }
        });
    }

    private void translateDtl(List<AgingRangeDtlVO> respVOList) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        AgingRangePageParam queryVO = new AgingRangePageParam();
        queryVO.setIdList(ids);
        List<AgingRangeVO> respVOList = this.domainService.selectByParam(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List checkRespVOList = respVOList.stream().filter(agingRangeVO -> !Objects.equals(agingRangeVO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkRespVOList)) {
            String checkItemResult = checkRespVOList.stream().map(checkVO -> checkVO.getAgingRangeCode()).collect(Collectors.joining(";", "\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u624d\u53ef\u5220\u9664.[", "],\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.FAIL, checkItemResult);
        }
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.domainService.updateDeleteFlagBatch(1, idList);
        this.dtlDomainService.updateDeleteFlagBatch(1, idList);
        this.agingRangeOuDomainService.updateDeleteFlagBatchByMasId(1, idList);
    }

    @Override
    public void enableBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u9700\u8981\u542f\u7528\u7684\u6570\u636e!");
        }
        AgingRangePageParam checkEqualParam = new AgingRangePageParam();
        checkEqualParam.setIdList(ids);
        checkEqualParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AgingRangeVO> checkEqualList = this.domainService.selectByParam(checkEqualParam);
        if (!CollectionUtils.isEmpty(checkEqualList)) {
            String checkItemResult = checkEqualList.stream().map(checkVO -> checkVO.getAgingRangeCode()).collect(Collectors.joining(";", "\u5df2\u542f\u7528\u7684\u4e0d\u53ef\u91cd\u590d\u542f\u7528.[", "],\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.FAIL, checkItemResult);
        }
        this.domainService.updateStatusBatch(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u9700\u8981\u7981\u7528\u7684\u6570\u636e!");
        }
        AgingRangePageParam checkEqualParam = new AgingRangePageParam();
        checkEqualParam.setIdList(ids);
        checkEqualParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode());
        List<AgingRangeVO> checkEqualList = this.domainService.selectByParam(checkEqualParam);
        if (!CollectionUtils.isEmpty(checkEqualList)) {
            String checkItemResult = checkEqualList.stream().map(checkVO -> checkVO.getAgingRangeCode()).collect(Collectors.joining(";", "\u5df2\u7981\u7528\u7684\u4e0d\u53ef\u91cd\u590d\u7981\u7528.[", "],\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.FAIL, checkItemResult);
        }
        this.domainService.updateStatusBatch(UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode(), ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<AgingRangeComPagingVO> commonPage(AgingRangeComPageParam comPageParam) {
        AgingRangePageParam pageParam = AgingRangeConvert.INSTANCE.comToPageParam(comPageParam);
        PagingVO<AgingRangePagingVO> pagingVO = this.domainService.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<AgingRangeComPagingVO> comPagingVOList = pagingVO.getRecords().stream().map(AgingRangeConvert.INSTANCE::voToComPagingVo).collect(Collectors.toList());
        Map yearTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getModel(), UdcEnum.TIME_UNIT_DAYS_YEAR_TYPE_360.getCode());
        Map monthTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getModel(), UdcEnum.TIME_UNIT_DAYS_MONTH_TYPE_30.getCode());
        Map dayTypeUnitDaysUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getModel(), UdcEnum.TIME_UNIT_DAYS_DAY_TYPE_1.getCode());
        comPagingVOList.forEach(agingRangePagingVO -> {
            String unitDays = agingRangePagingVO.getUnitDays();
            String timeUnitType = agingRangePagingVO.getTimeUnitType();
            if (StringUtils.isNotBlank((CharSequence)unitDays)) {
                if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_YEAR.getValueCode()) && MapUtil.isNotEmpty((Map)yearTypeUnitDaysUdc)) {
                    agingRangePagingVO.setUnitDaysName((String)yearTypeUnitDaysUdc.get(unitDays));
                } else if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_MONTH.getValueCode()) && MapUtil.isNotEmpty((Map)monthTypeUnitDaysUdc)) {
                    agingRangePagingVO.setUnitDaysName((String)monthTypeUnitDaysUdc.get(unitDays));
                } else if (Objects.equals(timeUnitType, UdcEnum.AGING_RANGE_TIME_UNIT_TYPE_DAY.getValueCode()) && MapUtil.isNotEmpty((Map)dayTypeUnitDaysUdc)) {
                    agingRangePagingVO.setUnitDaysName((String)dayTypeUnitDaysUdc.get(unitDays));
                }
            }
        });
        return PagingVO.builder().total(pagingVO.getTotal()).records(comPagingVOList).build();
    }

    @Override
    @SysCodeProc
    public PagingVO<AgingRangeOuVO> ouPage(AgingRangeOuPageParam pageParam) {
        PagingVO<AgingRangeOuDTO> pagingVO = this.agingRangeOuDomainService.ouPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List agingRangeOuVOList = pagingVO.getRecords().stream().map(AgingRangeOuConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVO.getTotal()).records(agingRangeOuVOList).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOu(AgingRangeOuMainSaveParam saveParam) {
        List checkAgingRangeOuVOList;
        if (Objects.isNull(saveParam.getMasId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e3b\u8868ID\u4e3a\u7a7a!");
        }
        if (CollectionUtil.isEmpty(saveParam.getOuSaveParamList())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u914d\u516c\u53f8\u6570\u636e\u4e3a\u7a7a!");
        }
        Long masId = saveParam.getMasId();
        List<AgingRangeOuSaveParam> ouSaveParamList = saveParam.getOuSaveParamList();
        List<Long> ouIdList = ouSaveParamList.stream().map(AgingRangeOuSaveParam::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(ouIdList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u914d\u516c\u53f8\u7684ID\u4e3a\u7a7a!");
        }
        AgingRangeOuPageParam agingRangeOuPageParam = new AgingRangeOuPageParam();
        agingRangeOuPageParam.setOuIdList(ouIdList);
        List<AgingRangeOuVO> oldAgingRangeOuVOList = this.agingRangeOuDomainService.selectByParam(agingRangeOuPageParam);
        if (CollectionUtil.isNotEmpty(oldAgingRangeOuVOList) && CollectionUtil.isNotEmpty(checkAgingRangeOuVOList = oldAgingRangeOuVOList.stream().filter(agingRangeOuVO -> !Objects.equals(agingRangeOuVO.getMasId(), masId)).distinct().collect(Collectors.toList()))) {
            List<Long> checkMasIdList = checkAgingRangeOuVOList.stream().map(AgingRangeOuVO::getMasId).distinct().collect(Collectors.toList());
            AgingRangePageParam agingRangePageParam = new AgingRangePageParam();
            agingRangePageParam.setIdList(checkMasIdList);
            List<AgingRangeVO> checkAgingRangeVOList = this.domainService.selectByParam(agingRangePageParam);
            Map<Long, AgingRangeVO> checkAgingRangeMap = checkAgingRangeVOList.stream().collect(Collectors.toMap(BaseModelVO::getId, v -> v, (v1, v2) -> v2));
            List checkAgingRangeOuHandleList = checkAgingRangeOuVOList.stream().map(agingRangeOuVO -> {
                AgingRangeOuHandleDTO agingRangeOuHandleDTO = new AgingRangeOuHandleDTO();
                agingRangeOuHandleDTO.setAgingRangeOuId(agingRangeOuVO.getId());
                agingRangeOuHandleDTO.setOuId(agingRangeOuVO.getOuId());
                agingRangeOuHandleDTO.setOuCode(agingRangeOuVO.getOuCode());
                agingRangeOuHandleDTO.setOuName(agingRangeOuVO.getOuName());
                AgingRangeVO agingRangeVO = (AgingRangeVO)checkAgingRangeMap.get(agingRangeOuVO.getMasId());
                if (Objects.isNull(agingRangeVO)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u5206\u914d\u516c\u53f8\u6570\u636e(" + agingRangeOuVO.getId() + ")\u7684\u4e3b\u8868\u4e0d\u5b58\u5728!");
                }
                agingRangeOuHandleDTO.setAgingRangeId(agingRangeVO.getId());
                agingRangeOuHandleDTO.setAgingRangeCode(agingRangeVO.getAgingRangeCode());
                agingRangeOuHandleDTO.setAgingRangeName(agingRangeVO.getAgingRangeName());
                return agingRangeOuHandleDTO;
            }).collect(Collectors.toList());
            String checkResult = checkAgingRangeOuHandleList.stream().map(checkVO -> "\u516c\u53f8(" + checkVO.getOuCode() + ")\u5df2\u5206\u914d\u8fc7\u8d26\u9f84(" + checkVO.getAgingRangeCode() + ")").collect(Collectors.joining(";", "\u4e0d\u5141\u8bb8\u91cd\u590d\u5339\u914d.[", "],\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        ArrayList<AgingRangeOuSaveParam> newOuSaveParamList = new ArrayList<AgingRangeOuSaveParam>();
        for (AgingRangeOuSaveParam rangeOuSaveParam : ouSaveParamList) {
            rangeOuSaveParam.setMasId(masId);
            Boolean checkExistFlag = oldAgingRangeOuVOList.stream().anyMatch(agingRangeOuVO -> Objects.equals(rangeOuSaveParam.getMasId(), agingRangeOuVO.getMasId()) && Objects.equals(agingRangeOuVO.getOuId(), rangeOuSaveParam.getOuId()));
            if (checkExistFlag.booleanValue()) continue;
            newOuSaveParamList.add(rangeOuSaveParam);
        }
        if (CollectionUtil.isNotEmpty(newOuSaveParamList)) {
            this.agingRangeOuDomainService.save(newOuSaveParamList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOu(List<Long> ids) {
        this.agingRangeOuDomainService.cancelOu(ids);
    }

    public AgingRangeServiceImpl(AgingRangeDomainService domainService, AgingRangeDtlDomainService dtlDomainService, AgingRangeRepo agingRangeRepo, AgingRangeRepoProc agingRangeRepoProc, AgingRangeDtlRepo agingRangeDtlRepo, AgingRangeDtlRepoProc agingRangeDtlRepoProc, SysNumberGenerator sysNumberGeneratorWrapper, UdcProvider udcProvider, AgingRangeOuDomainService agingRangeOuDomainService) {
        this.domainService = domainService;
        this.dtlDomainService = dtlDomainService;
        this.agingRangeRepo = agingRangeRepo;
        this.agingRangeRepoProc = agingRangeRepoProc;
        this.agingRangeDtlRepo = agingRangeDtlRepo;
        this.agingRangeDtlRepoProc = agingRangeDtlRepoProc;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.udcProvider = udcProvider;
        this.agingRangeOuDomainService = agingRangeOuDomainService;
    }
}

