/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.creditaccountflow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.creditaccountflow.QCreditAccountFlowDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CreditAccountFlowRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountFlowDO qCreditAccountFlowDO = QCreditAccountFlowDO.creditAccountFlowDO;

    public PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.where(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowPageParam.setPaging(query);
        creditAccountFlowPageParam.fillOrders(query, this.qCreditAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public CreditAccountFlowVO selectByAccCode(String accCode) {
        return (CreditAccountFlowVO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.select(CreditAccountFlowVO.class).where((Predicate)this.qCreditAccountFlowDO.creditAccountCode.eq((Object)accCode))).where((Predicate)this.qCreditAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)this.qCreditAccountFlowDO.deleteFlag.isNull()))).orderBy(this.qCreditAccountFlowDO.createTime.desc())).fetchFirst());
    }

    public List<CreditAccountFlowVO> selectListByParam(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.where(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        Predicate customFieldPredicate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowPageParam.getObjectName())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.objectName.like(StringUtil.buildLikeString(creditAccountFlowPageParam.getObjectName())));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getObjectNameList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.objectName.in(creditAccountFlowPageParam.getObjectNameList()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getObjectCodeList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.objectCode.in(creditAccountFlowPageParam.getObjectCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getCreditAccountName())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountName.like(StringUtil.buildLikeString(creditAccountFlowPageParam.getCreditAccountName())));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountNameList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountName.in(creditAccountFlowPageParam.getCreditAccountNameList()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountCode.in(creditAccountFlowPageParam.getCreditAccountCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getTransactionType())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionType.eq((Object)creditAccountFlowPageParam.getTransactionType()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getTransactionTypeList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionType.in(creditAccountFlowPageParam.getTransactionTypeList()));
        }
        if (creditAccountFlowPageParam.getTransactionTimeS() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionTime.goe((Comparable)creditAccountFlowPageParam.getTransactionTimeS()));
        }
        if (creditAccountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.transactionTime.loe((Comparable)creditAccountFlowPageParam.getTransactionTimeE()));
        }
        if (creditAccountFlowPageParam.getAmountFrom() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.amount.goe((Number)creditAccountFlowPageParam.getAmountFrom()));
        }
        if (creditAccountFlowPageParam.getAmountTo() != null) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.amount.loe((Number)creditAccountFlowPageParam.getAmountTo()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getCreditAccountType())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountType.eq((Object)creditAccountFlowPageParam.getCreditAccountType()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountTypeList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountType.in(creditAccountFlowPageParam.getCreditAccountTypeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.sourceNo.like("%" + creditAccountFlowPageParam.getSourceNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getSourceNoList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.sourceNo.in(creditAccountFlowPageParam.getSourceNoList()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getFlowNo())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.flowNo.like("%" + creditAccountFlowPageParam.getFlowNo() + "%"));
        }
        if (CollectionUtil.isNotEmpty(creditAccountFlowPageParam.getSourceDocList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.sourceDoc.in(creditAccountFlowPageParam.getSourceDocList()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getIds())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.id.in(creditAccountFlowPageParam.getIds()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)creditAccountFlowPageParam.getConditions(), CreditAccountFlowDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCreditAccountFlowDO.id, this.qCreditAccountFlowDO.flowNo, this.qCreditAccountFlowDO.transactionType, this.qCreditAccountFlowDO.amount, this.qCreditAccountFlowDO.transactionTime, this.qCreditAccountFlowDO.creditAccountCode, this.qCreditAccountFlowDO.creditAccountName, this.qCreditAccountFlowDO.creditAccountType, this.qCreditAccountFlowDO.sourceNo, this.qCreditAccountFlowDO.sourceDoc, this.qCreditAccountFlowDO.remark, this.qCreditAccountFlowDO.createTime, this.qCreditAccountFlowDO.createUserId, this.qCreditAccountFlowDO.creator, this.qCreditAccountFlowDO.modifyTime, this.qCreditAccountFlowDO.modifyUserId, this.qCreditAccountFlowDO.updater, this.qCreditAccountFlowDO.deleteFlag, this.qCreditAccountFlowDO.ouCode, this.qCreditAccountFlowDO.creditAccountLimit, this.qCreditAccountFlowDO.creditAccountUsedLimit, this.qCreditAccountFlowDO.creditAccountOccupancyLimit, this.qCreditAccountFlowDO.creditAccountAvailableLimit, this.qCreditAccountFlowDO.auditUserId, this.qCreditAccountFlowDO.auditUserName, this.qCreditAccountFlowDO.auditDate, this.qCreditAccountFlowDO.orderState, this.qCreditAccountFlowDO.creditAccountRuleCode, this.qCreditAccountFlowDO.priorityNo, this.qCreditAccountFlowDO.ouName, this.qCreditAccountFlowDO.objectCode, this.qCreditAccountFlowDO.objectName, this.qCreditAccountFlowDO.objectType, this.qCreditAccountFlowDO.buCode, this.qCreditAccountFlowDO.buName, this.qCreditAccountFlowDO.saleUser, this.qCreditAccountFlowDO.sourceId, this.qCreditAccountFlowDO.sourceDocStatus, this.qCreditAccountFlowDO.extensionInfo})).from((EntityPath)this.qCreditAccountFlowDO);
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCreditAccountFlowDO.id, this.qCreditAccountFlowDO.flowNo, this.qCreditAccountFlowDO.transactionType, this.qCreditAccountFlowDO.amount, this.qCreditAccountFlowDO.transactionTime, this.qCreditAccountFlowDO.creditAccountCode, this.qCreditAccountFlowDO.creditAccountName, this.qCreditAccountFlowDO.sourceNo, this.qCreditAccountFlowDO.sourceDoc})).from((EntityPath)this.qCreditAccountFlowDO);
    }

    public void approveAccountFlow(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set((Path)this.qCreditAccountFlowDO.orderState, (Object)creditAccountFlowParam.getOrderState()).set(this.qCreditAccountFlowDO.auditUserId, (Object)creditAccountFlowParam.getAuditUserId()).set((Path)this.qCreditAccountFlowDO.auditUserName, (Object)creditAccountFlowParam.getAuditUserName()).set(this.qCreditAccountFlowDO.auditDate, (Object)creditAccountFlowParam.getAuditDate()).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)creditAccountFlowParam.getId())}).execute();
    }

    public List<CreditAccountFlowVO> queryCreditAccountFlowVO(CreditAccountFlowParam creditAccountFlowParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (creditAccountFlowParam.getSourceId() != null) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceId.eq((Object)creditAccountFlowParam.getSourceId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDoc())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceDoc.eq((Object)creditAccountFlowParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDocStatus())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceDocStatus.eq((Object)creditAccountFlowParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getCreditAccountType())) {
            query.where((Predicate)this.qCreditAccountFlowDO.creditAccountType.eq((Object)creditAccountFlowParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceNo())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceNo.eq((Object)creditAccountFlowParam.getSourceNo()));
        }
        return query.fetch();
    }

    public void updateCreditAccountFlowAmount(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountFlowParam.getCreditAccountLimit()).set(this.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountFlowParam.getCreditAccountUsedLimit()).set(this.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountFlowParam.getCreditAccountOccupancyLimit()).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountFlowParam.getCreditAccountAvailableLimit()).where(new Predicate[]{this.qCreditAccountFlowDO.creditAccountCode.eq((Object)creditAccountFlowParam.getCreditAccountCode()).and((Predicate)this.qCreditAccountFlowDO.orderState.eq((Object)creditAccountFlowParam.getOrderState()))}).execute();
    }

    public List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getSourceNo())) {
            query.where((Predicate)this.qCreditAccountFlowDO.sourceNo.eq((Object)queryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getCreditAccountType())) {
            query.where((Predicate)this.qCreditAccountFlowDO.creditAccountType.eq((Object)queryParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getFlowNo())) {
            query.where((Predicate)this.qCreditAccountFlowDO.flowNo.eq((Object)queryParam.getFlowNo()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getFlowNoList())) {
            query.where((Predicate)this.qCreditAccountFlowDO.flowNo.in(queryParam.getFlowNoList()));
        }
        return query.fetch();
    }

    public CreditAccountFlowVO selectPreviousRepairAmtByParam(CreditAccountFlowParam flowQueryParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (!StringUtils.isEmpty((CharSequence)flowQueryParam.getCreditAccountCode())) {
            query.where((Predicate)this.qCreditAccountFlowDO.creditAccountCode.eq((Object)flowQueryParam.getCreditAccountCode()));
        }
        query.where((Predicate)this.qCreditAccountFlowDO.auditDate.isNotNull());
        return (CreditAccountFlowVO)((Object)((JPAQuery)query.orderBy(this.qCreditAccountFlowDO.auditDate.desc())).fetchFirst());
    }

    public List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.selectRepairAfterPageWhere(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(this.qCreditAccountFlowDO.auditDate.desc());
        creditAccountFlowPageParam.setPaging(query);
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterPageWhere(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)this.qCreditAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getFlowNoList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.flowNo.in(creditAccountFlowPageParam.getFlowNoList()));
        }
        if (Objects.nonNull(creditAccountFlowPageParam.getRepairTime())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.auditDate.gt((Comparable)creditAccountFlowPageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getCreditAccountCode())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountCode.eq((Object)creditAccountFlowPageParam.getCreditAccountCode()));
        }
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountCode.in(creditAccountFlowPageParam.getCreditAccountCodeList()));
        }
        return predicates;
    }

    public List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam flowPageParam) {
        List<Predicate> where = this.selectRepairAfterWhere(flowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(this.qCreditAccountFlowDO.auditDate.desc());
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterWhere(CreditAccountFlowParam pageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)this.qCreditAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.auditDate.goe((Comparable)pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)pageParam.getCreditAccountCode())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountCode.eq((Object)pageParam.getCreditAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)this.qCreditAccountFlowDO.creditAccountCode.in(pageParam.getCreditAccountCodeList()));
        }
        return predicates;
    }

    public void updateOccupancyAndAvailableAndAmountById(BigDecimal creditAccountOccupancyLimit, BigDecimal creditAccountAvailableLimit, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountOccupancyLimit).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).set(this.qCreditAccountFlowDO.amount, (Object)amount).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableAndAmountById(BigDecimal creditAccountLimit, BigDecimal creditAccountAvailableLimit, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountLimit).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).set(this.qCreditAccountFlowDO.amount, (Object)amount).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateUsedAndAvailableAndAmountById(BigDecimal creditAccountUsedLimit, BigDecimal creditAccountAvailableLimit, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountUsedLimit).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).set(this.qCreditAccountFlowDO.amount, (Object)amount).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateOccupancyAndAvailableById(BigDecimal creditAccountOccupancyLimit, BigDecimal creditAccountAvailableLimit, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountOccupancyLimit).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableById(BigDecimal creditAccountLimit, BigDecimal creditAccountAvailableLimit, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountLimit).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateUsedAndAvailableById(BigDecimal creditAccountUsedLimit, BigDecimal creditAccountAvailableLimit, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qCreditAccountFlowDO).set(this.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountUsedLimit).set(this.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).where(new Predicate[]{this.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public CreditAccountFlowRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

