/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.aporder;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlGroupConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroupDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlGroupDTO;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.factory.aporder.ApOrderFactory;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlGroupRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlGroupRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.workflow.ProcessInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderDomainServiceImpl
implements ApOrderDomainService {
    private final ApOrderRepo apOrderRepo;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final ApOrderFactory apOrderFactory;
    private final ApOrderDtlGroupRepo apOrderDtlGroupRepo;
    private final ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ApOrder apOrder) {
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            apOrder.checkAmt();
            apOrder.checkAmtSum();
        }
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            apOrder.setPacckDef();
            apOrder.countByPacck();
            List<ApOrderDtlGroup> apOrderDtlGroups = this.genDtlGroup(apOrder);
            apOrder.setApOrderDtlGroupList(apOrderDtlGroups);
        }
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        ApOrderDO apOrderRes = this.saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    public List<ApOrderDtlGroup> genDtlGroup(ApOrder apOrder) {
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        ArrayList<ApOrderDtlGroup> resList = new ArrayList<ApOrderDtlGroup>();
        for (Map.Entry<String, List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
        }
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApOrderDO saveOrUpdate(ApOrder apOrder) {
        ApOrderDO apOrderDO;
        if (CharSequenceUtil.isBlank((CharSequence)apOrder.getApOrderNo())) {
            String apOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "YFD", null);
            apOrder.setApOrderNo(apOrderNo);
        }
        if ((apOrderDO = ApOrderConvert.INSTANCE.convert(apOrder)).getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        ApOrderDO apOrderRes = (ApOrderDO)this.apOrderRepo.save(apOrderDO);
        this.apOrderDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ApOrderDtl> apOrderDtlList = apOrder.getApOrderDtlList();
        List<ApOrderDtlDO> apOrderDtlDOS = ApOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        apOrderDtlDOS.stream().forEach(x -> {
            x.setMasId(apOrderRes.getId());
            this.apOrderDtlRepo.save(x);
        });
        this.apOrderDtlGroupRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ApOrderDtlGroup> apOrderDtlGroups = apOrder.getApOrderDtlGroupList();
        if (null != apOrderDtlGroups) {
            List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = ApOrderDtlGroupConvert.INSTANCE.convert(apOrderDtlGroups);
            apOrderDtlGroupDOS.stream().forEach(x -> {
                x.setMasId(apOrderRes.getId());
                this.apOrderDtlGroupRepo.save(x);
            });
        }
        return apOrderRes;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long commit(ApOrder apOrder) {
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        apOrder.checkAmt();
        apOrder.checkAmtSum();
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        ApOrderDO apOrderRes = this.saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        this.apOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    @Override
    public ApOrderDTO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = this.get(id);
        List<ApOrderDtlDTO> apOrderDtlDOS = this.apOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlDTOList(apOrderDtlDOS);
        List<ApOrderDtlGroupDTO> apOrderDtlGroupDTOS = this.apOrderDtlGroupRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlGroupDTOList(apOrderDtlGroupDTOS);
        return apOrderDTO;
    }

    @Override
    public List<ApOrderDTO> queryByIds(List<Long> ids) {
        return this.apOrderRepoProc.queryByIds(ids);
    }

    @Override
    public List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam) {
        List<ApOrderDTO> res = this.apOrderRepoProc.getApOrderList(apOrderParam);
        return res;
    }

    @Override
    public Boolean queryByApTypeId(Long apTypeId) {
        return this.apOrderRepoProc.queryByApTypeId(apTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Retryable(value={BusinessException.class}, maxAttempts=5, backoff=@Backoff(value=500L))
    public void updateVerAmt(Long id, BigDecimal amt) {
        BigDecimal totalAmt;
        ApVerDTO apVerDTO = this.apOrderRepoProc.queryVerAmtById(id);
        if (Objects.isNull(apVerDTO)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u4fe1\u606f");
        }
        BigDecimal bigDecimal = totalAmt = Objects.isNull(apVerDTO.getTotalAmt()) ? BigDecimal.ZERO : apVerDTO.getTotalAmt();
        if (apVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u5e94\u4ed8\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        apVerDTO.setAmtAndVerState(amt);
        long rows = this.apOrderRepoProc.updateVerAmt(apVerDTO);
        if (rows == 0L) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = this.apOrderFactory.page(apOrderPageParam);
        return res;
    }

    @Override
    public ApOrderDTO get(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(id);
        return apOrderDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = this.apOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        List<ApOrderDTO> apOrderDTOList = this.apOrderRepoProc.queryByIds(ids);
        apOrderDTOList.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
        });
        Long res = this.apOrderRepoProc.del(ids);
        this.apOrderDtlRepoProc.delByMasId(ids);
        this.apOrderDtlGroupRepoProc.delByMasId(ids);
        return res;
    }

    public ApOrderDomainServiceImpl(ApOrderRepo apOrderRepo, ApOrderRepoProc apOrderRepoProc, ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderDtlRepo apOrderDtlRepo, ApOrderFactory apOrderFactory, ApOrderDtlGroupRepo apOrderDtlGroupRepo, ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc, SeqNumProvider sysNumberRuleService) {
        this.apOrderRepo = apOrderRepo;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderDtlRepo = apOrderDtlRepo;
        this.apOrderFactory = apOrderFactory;
        this.apOrderDtlGroupRepo = apOrderDtlGroupRepo;
        this.apOrderDtlGroupRepoProc = apOrderDtlGroupRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

