/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.entity.account.AccountSnapshotDO;
import com.elitesland.fin.entity.account.QAccountSnapshotDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AccountSnapshotRepoProc
extends BaseRepoProc<AccountSnapshotDO> {
    private static final QAccountSnapshotDO qAccountSnapshotDO = QAccountSnapshotDO.accountSnapshotDO;

    protected AccountSnapshotRepoProc() {
        super((EntityPathBase)qAccountSnapshotDO);
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AccountSnapshotRepoProc.qAccountSnapshotDO.id, AccountSnapshotRepoProc.qAccountSnapshotDO.accountName, AccountSnapshotRepoProc.qAccountSnapshotDO.accountCode, AccountSnapshotRepoProc.qAccountSnapshotDO.accountType, AccountSnapshotRepoProc.qAccountSnapshotDO.state, AccountSnapshotRepoProc.qAccountSnapshotDO.createTime, AccountSnapshotRepoProc.qAccountSnapshotDO.creator, AccountSnapshotRepoProc.qAccountSnapshotDO.accountOccupancyAmount, AccountSnapshotRepoProc.qAccountSnapshotDO.accountAmount.subtract(AccountSnapshotRepoProc.qAccountSnapshotDO.accountOccupancyAmount).as("accAvaAmt"), AccountSnapshotRepoProc.qAccountSnapshotDO.accountAmount, AccountSnapshotRepoProc.qAccountSnapshotDO.accountAvailableAmount, AccountSnapshotRepoProc.qAccountSnapshotDO.secOuCode, AccountSnapshotRepoProc.qAccountSnapshotDO.secOuName, AccountSnapshotRepoProc.qAccountSnapshotDO.snapshotTime, AccountSnapshotRepoProc.qAccountSnapshotDO.accountHolderName, AccountSnapshotRepoProc.qAccountSnapshotDO.accountHolderCode, AccountSnapshotRepoProc.qAccountSnapshotDO.remark})).from((EntityPath)qAccountSnapshotDO);
    }

    public PagingVO<AccountSnapshotVo> querySnapshot(AccountSnapshotParam param) {
        Predicate predicate = this.commonBuilder(param).build();
        JPAQuery query = (JPAQuery)this.select(AccountSnapshotVo.class).where(predicate);
        param.setPaging(query);
        param.fillOrders(query, qAccountSnapshotDO);
        List fetch = query.fetch();
        return PagingVO.builder().total(query.fetchCount()).records(fetch).build();
    }

    private BaseRepoProc.PredicateBuilder commonBuilder(AccountSnapshotParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andIn(CollectionUtil.isNotEmpty(param.getIds()), AccountSnapshotRepoProc.qAccountSnapshotDO.id, param.getIds()).andLike(StrUtil.isNotBlank((CharSequence)param.getAccountHolderName()), (StringExpression)AccountSnapshotRepoProc.qAccountSnapshotDO.accountHolderName, param.getAccountHolderName()).andLike(StrUtil.isNotBlank((CharSequence)param.getAccountHolderCode()), (StringExpression)AccountSnapshotRepoProc.qAccountSnapshotDO.accountHolderCode, param.getAccountHolderCode()).andLike(StrUtil.isNotBlank((CharSequence)param.getAccountCode()), (StringExpression)AccountSnapshotRepoProc.qAccountSnapshotDO.accountCode, param.getAccountCode()).andLike(StrUtil.isNotBlank((CharSequence)param.getAccountName()), (StringExpression)AccountSnapshotRepoProc.qAccountSnapshotDO.accountName, param.getAccountName()).andEq(StrUtil.isNotBlank((CharSequence)param.getAccountType()), (SimpleExpression)AccountSnapshotRepoProc.qAccountSnapshotDO.accountType, (Object)param.getAccountType()).andGoe(ObjectUtil.isNotNull((Object)param.getSnapshotStartTime()), AccountSnapshotRepoProc.qAccountSnapshotDO.snapshotTime, (Comparable)param.getSnapshotStartTime()).andLoe(ObjectUtil.isNotNull((Object)param.getSnapshotEndTime()), AccountSnapshotRepoProc.qAccountSnapshotDO.snapshotTime, (Comparable)param.getSnapshotEndTime());
    }

    public List<AccountSnapshotDO> selectAccountSnapshotByParam(AccountSnapshotParam queryParam) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)qAccountSnapshotDO).from((EntityPath)qAccountSnapshotDO);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getAccountCode())) {
            query.where((Predicate)AccountSnapshotRepoProc.qAccountSnapshotDO.accountCode.eq((Object)queryParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getAccountCodeList())) {
            query.where((Predicate)AccountSnapshotRepoProc.qAccountSnapshotDO.accountCode.in(queryParam.getAccountCodeList()));
        }
        if (Objects.nonNull(queryParam.getRepairTime())) {
            query.where((Predicate)AccountSnapshotRepoProc.qAccountSnapshotDO.snapshotTime.gt((Comparable)queryParam.getRepairTime()));
        }
        return query.fetch();
    }
}

