package com.elitesland.fin.application.convert.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementComPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.entity.paymentperiod.ReceiptPaymentAgreementDO;
import com.elitesland.fin.dto.paymentperiod.ReceiptPaymentAgreementRpcDTO;
import com.elitesland.fin.infr.dto.paymentperiod.ReceiptPaymentAgreementDTO;
import com.elitesland.fin.param.paymentperiod.ReceiptPaymentAgreementRpcParam;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ReceiptPaymentAgreementConvert {
    ReceiptPaymentAgreementConvert INSTANCE = Mappers.getMapper(ReceiptPaymentAgreementConvert.class);


    /**
     * saveVO转换DO
     *
     * @param saveVO 入参
     * @return DO
     */
    ReceiptPaymentAgreementDO saveVoToDo(ReceiptPaymentAgreementSaveParam saveVO);

    /**
     * DO转换RespVO
     *
     * @param agreementDO 入参
     * @return RespVO
     */
    ReceiptPaymentAgreementVO doToRespVo(ReceiptPaymentAgreementDO agreementDO);

    /**
     * DO转换DTO
     *
     * @param agreementDO 入参
     * @return DTO
     */
    ReceiptPaymentAgreementDTO doToDto(ReceiptPaymentAgreementDO agreementDO);

    /**
     * DTO转换RespVO
     *
     * @param agreementDTO 入参
     * @return RespVO
     */
    ReceiptPaymentAgreementVO dtoToRespVo(ReceiptPaymentAgreementDTO agreementDTO);


    /**
     * comPageParam 转换 PageParam
     *
     * @param comPageParam 入参
     * @return
     */
    ReceiptPaymentAgreementPageParam comToPageParam(ReceiptPaymentAgreementComPageParam comPageParam);

    /**
     * pagingVo转换ComPagingVo
     *
     * @param pagingVO 入参
     * @return ComPagingVO
     */
    ReceiptPaymentAgreementComPagingVO voToComPagingVo(ReceiptPaymentAgreementPagingVO pagingVO);


    ReceiptPaymentAgreementPageParam rpcParamToParam(ReceiptPaymentAgreementRpcParam rpcParam);

    ReceiptPaymentAgreementRpcDTO voToRpcDto(ReceiptPaymentAgreementVO agreementVO);

}
