package com.elitesland.fin.application.facade.vo.cgorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.vo.picturefile.PictureFileVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.elitesland.fin.application.facade.base.BaseModelVO;

/**
 * 充值单;
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@ApiModel(value = "充值单",description = "")
@Data
public class CgOrderVO extends BaseModelVO {
    private static final long serialVersionUID = 4643188476671438315L;
    @ApiModelProperty("单号")
    private String docNo;

    @SysCode(sys = "yst-supp",mod = "APPLY_STATUS")
    @ApiModelProperty("状态")
    private String state;
    private String stateName;

    @SysCode(sys = "yst-fin",mod = "CG_ORDER_TYPE")
    @ApiModelProperty("单据类型")
    private String type;
    private String typeName;

    @ApiModelProperty("收款银行名称")
    private String recBankName;

    @ApiModelProperty("收款银行账户")
    private String recBankAcc;

    @SysCode(sys = "yst-supp",mod = "PAY_METHOD")
    @ApiModelProperty("收款方式")
    private String recType;
    private String recTypeName;

    @ApiModelProperty("汇款开户行")
    private String payOpenBank;

    @ApiModelProperty("汇款银行账户")
    private String payBankAcc;

    @ApiModelProperty("汇款时间")
    private LocalDateTime cgTime;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin",mod = "ACCOUNT_TYPE")
    private String accType;
    private String accTypeName;


    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private Long sourceId;

    @ApiModelProperty("已退还金额")
    private BigDecimal refundAmt;

    @ApiModelProperty("未退还金额")
    private BigDecimal unrefundAmt;

    @ApiModelProperty("充值类型")
    private String cgType;
    private String cgTypeName;

    @ApiModelProperty("是否删除  false=未删除")
    private Boolean delWeb;



    @ApiModelProperty("图片数据")
    private List<PictureFileVO> pictureFileVOS;
}