package com.elitesland.fin.application.service.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ApOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerificationDTO;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.repo.writeoff.ApOrderDetailRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;
/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.aporder
 * @date 2022/3/16 16:06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ApOrderServiceImpl implements ApOrderService {

    private final ApOrderDomainService apOrderDomainService;
    private final WorkflowRpcService workflowRpcService;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDetailRepoProc apOrderDetailRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;

    @SysCodeProc
    @Override
    public PagingVO<ApOrderVO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        if(res!=null && CollectionUtils.isNotEmpty(res.getRecords())){
            final List<Long> masIds = res.getRecords().stream().map(ApOrderVO::getId).collect(Collectors.toList());
            final List<ApOrderDtlDTO> apOrderDtlDTOS = apOrderDtlRepoProc.listByMasIds(masIds);
            final Map<Long, List<ApOrderDtlDTO>> apOrderDtlDTOMap= apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId, Collectors.toList()));
            res.getRecords().stream().forEach(v->{
                BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
                BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
                BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
                final List<ApOrderDtlDTO> arOrderDtlDTOS1 = apOrderDtlDTOMap.get(v.getId());
                if (CollUtil.isNotEmpty(arOrderDtlDTOS1)) {
                    for (ApOrderDtlDTO apOrderDtlDTO : arOrderDtlDTOS1) {
                        if(null != apOrderDtlDTO.getVerAmt()){
                            verAmt = verAmt.add(apOrderDtlDTO.getVerAmt());
                        }
                        if(apOrderDtlDTO.getApplyVerAmTing()!=null){
                            verAmting = verAmting.add(apOrderDtlDTO.getApplyVerAmTing());
                        }
                        if(apOrderDtlDTO.getUnVerAmt()!=null){
                            unVerAmt = unVerAmt.add(apOrderDtlDTO.getUnVerAmt());
                        }
                    }
                }
                v.setVerAmt(verAmt);
                v.setApplyVerAmTing(verAmting);
                v.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            });
        }
        flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.AP_ORDER,res.getRecords());
        return res;
    }
    @SysCodeProc
    @Override
    public PagingVO<ApOrderVO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = apOrderDomainService.writeoffPage(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        if(res.isEmpty()){
            return res;
        }
        final List<Long> masIds = res.getRecords().stream().map(ApOrderVO::getId).collect(Collectors.toList());
        final List<ApOrderDtlDTO> apOrderDtlDTOS = apOrderDtlRepoProc.listByMasIds(masIds);
        final Map<Long, List<ApOrderDtlDTO>> apOrderDtlDTOMap= apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId, Collectors.toList()));
        res.getRecords().stream().forEach(v->{
            BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
            BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
            BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
            final List<ApOrderDtlDTO> arOrderDtlDTOS1 = apOrderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty(arOrderDtlDTOS1)) {
                for (ApOrderDtlDTO apOrderDtlDTO : arOrderDtlDTOS1) {
                    verAmt = verAmt.add(apOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(apOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(apOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }

        });
        return res;
    }
    @SysCodeProc
    @Override
    public ApOrderVO get(Long id) {
        ApOrderDTO apOrderDTO = apOrderDomainService.get(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        flexFieldUtilService.handleSingleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.AP_ORDER,res);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> audit(Long id) {

        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {

        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = apOrderDomainService.audit(ids, content, user);
        return ApiResult.ok(res);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = apOrderDomainService.del(ids);
        return ApiResult.ok(res);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> save(ApOrderSaveParam apOrderSaveParam) {
        // 新增只用于单据来源为手工的
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("新增的单据来源需为手工");
        }
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = apOrderDomainService.save(apOrder);
        return ApiResult.ok(res);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> commit(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long resId = apOrderDomainService.commit(apOrder);
        // 启动工作流
        if (apOrder.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            // 启动流程
            String procInstName = "应付单审核-" + apOrder.getApOrderNo();
            String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
            ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<>());
            apOrderDomainService.updateWorkInfo(processInfo, resId);
        }
        return ApiResult.ok(resId);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> update(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = apOrderDomainService.save(apOrder);
        return ApiResult.ok(res);
    }

    @SysCodeProc
    @Override
    public ApOrderVO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = apOrderDomainService.getApOrderAndDtl(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        flexFieldUtilService.handleSingleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.AP_ORDER,res);
        return res;
    }

    @SysCodeProc
    @Override
    public void exportExl(HttpServletResponse response, ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
            String fileName = URLEncoder.encode("采购结算单", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write(response.getOutputStream(), ApOrderVO.class).sheet("采购结算单").doWrite(res.getRecords());
        } catch (IOException e) {
            log.error("采购结算单导出异常信息:{}", e);
        }
    }

    @Override
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        // 重置状态
        apOrderDomainService.restDocState(ids);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Long> redPunch(Long id) {
        ApOrderDTO apOrderDTO = apOrderDomainService.get(id);
        this.checkRedPunch(apOrderDTO);
        ApOrder apOrder = apOrderDomainService.redPunchCreate(id);
        apOrder.setCheck(false);
        return this.commit(ApOrderConvert.INSTANCE.convertParam(apOrder));
    }

    /**
     * 取消单据检查
     * @param apOrderDTO
     */
    void checkRedPunch(ApOrderDTO apOrderDTO) {
        if (Objects.isNull(apOrderDTO)){
            throw new BusinessException("单据不存在");
        }
        if (Boolean.TRUE.equals(apOrderDTO.getRedState())){
            throw new BusinessException("单据已红冲");
        }
        if (Objects.nonNull(apOrderDTO.getRedSourceNo())){
            throw new BusinessException("来源单据不可为红冲单据");
        }
        if (!(BigDecimal.ZERO.compareTo(apOrderDTO.getVerAmt())==0)){
            throw new BusinessException("已核销金额必须为0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(apOrderDTO.getOrderState())){
            throw new BusinessException("单据状态必须为审核通过");
        }
        if (!apOrderDTO.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("只允许红冲手工生成的应付单");
        }

    }
    private void checkVerAmtEqualZero(long id){
        List<Long> ids = new ArrayList<>();
        ids.add(id);
        List<ApOrderDtlDTO> apOrderDtlDTOS = apOrderDtlRepoProc.listByMasIds(ids);
        if(CollectionUtils.isNotEmpty(apOrderDtlDTOS)){
            BigDecimal verAmt = apOrderDtlDTOS.stream().map(ApOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!BigDecimal.ZERO.equals(verAmt)){
                throw new com.elitescloud.boot.exception.BusinessException("已核销金额不为0");
            }
        }
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMiddleVerAmt(Long apDId, BigDecimal amt) {
        ApOrderDtlDO detail = findDetail(apDId);
        doUpdateVerAmt(getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }
    @NotNull
    private ApOrderDtlDO findDetail(Long arDId) {
        ApOrderDtlDO detail = apOrderDetailRepoProc.getApOrderDetailAmt(arDId);
        Assert.notNull(detail, "未查询到应收单明细，明细ID:" + arDId);
        return detail;
    }
    private void doUpdateVerAmt(ApOrderAmtUpdateDTO update) {
        if (apOrderDetailRepoProc.updateVerAmt(update) == 0) {
            throw new BusinessException("更新核销金额失败，请稍后重试");
        }
    }
    private ApOrderAmtUpdateDTO.ApOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ApOrderDtlDO detail) {

        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);

        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("请核对金额数据");
        }
        return ApOrderAmtUpdateDTO.builder()
                .apDId(detail.getId())
                .unVerAmt(unVerAmt)
                .verAmting(verAmting)
                .verAmt(detail.getVerAmt())
                .version(detail.getAuditDataVersion());

    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateVerAmt(Long apDId, BigDecimal amt, String verType) {
        ApOrderDtlDO detail = findDetail(apDId);
        doUpdateVerAmt(getUpdateVerAmtBuilder(amt, detail, verType).build());
    }
    @NotNull
    private ApOrderAmtUpdateDTO.ApOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ApOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr(detail);
        log.info("计算应收单核销金额,{}-{}", amt, infoStr);
        // 取消核销
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("取消核销,{}-{}-{}", infoStr, verAmt, unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return ApOrderAmtUpdateDTO.builder()
                    .apDId(detail.getId())
                    .unVerAmt(unVerAmt)
                    .verAmting(detail.getApplyVerAmTing())
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());

        } else {
            // 核销通过
            BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
            BigDecimal verAmt = detail.getVerAmt().add(amt);
            log.info("核销通过,{}-{}-{}", infoStr, verAmting, verAmt);
            if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return ApOrderAmtUpdateDTO.builder()
                    .apDId(detail.getId())
                    .unVerAmt(detail.getUnVerAmt())
                    .verAmting(verAmting)
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());
        }

    }
    @Override
    public List<ApOrderDtlVO> listApOrderDetail(FinApOrderDetailQuery query) {
        return apOrderDetailRepoProc.listArOrderDetail(query);
    }
}

