package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.fin.application.convert.arorder.ArOrderExConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderExDTO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderExPageParam;
import com.elitesland.fin.application.facade.param.arorder.FinArOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOderExDtlDo;
import com.elitesland.fin.domain.entity.arorder.QArOderExDtlDo;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderExDo;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.repo.writeoff.ArOrderDetailRepoProc;
import com.elitesland.fin.repo.writeoff.ArOrderExRepoProc;
import com.elitesland.fin.utils.BeanConvertUtils;
import com.elitesland.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.support.provider.item.dto.ItmItemDTO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 查询服务实现类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@Service
@Log4j2
@RequiredArgsConstructor
public class ArOrderExServiceImpl extends BaseServiceImpl implements ArOrderExService {

    final QArOrderExDo arOrderExDo = QArOrderExDo.arOrderExDo;
    final QArOderExDtlDo qArOderExDtlDo = QArOderExDtlDo.arOderExDtlDo;
    final QArOrderDO qArOrderDO = QArOrderDO.arOrderDO;

    final JPAQueryFactory jpaQueryFactory;
    //final SalSoDomainService salSoService;
    final CrmCustRpcService crmCustRpcService;
    final OrgRpcService orgRpcService;
    //final ItmItemDomainService itmItemDomainService;
    final SysCurrencyRpcService sysCurrencyRpcService;
    final ArOrderDetailRepoProc arOrderDetailRepoProc;
    final EmployeeRpcService employeeRpcService;
    final ArOrderExRepoProc arOrderExRepoProc;
    final ArOrderDomainService arOrderDomainService;

    @Override
    @SysCodeProc
    public PagingVO<ArOrderExVo> page(ArOrderExPageParam param) {

        Integer size = param.size;
        Integer current = param.current;

        param.size = Integer.MAX_VALUE;
        param.current = 1;
        PagingVO<ArOrderExVo> page = arOrderExRepoProc.page(param);

        if (page.isEmpty()) {
            return page;
        }

        setInfo(page);

        if (Boolean.TRUE.equals(param.getHeadFlag())) {
            List<ArOrderExVo> records = page.getRecords();
            records = records.stream().filter(item -> BigDecimal.ZERO.compareTo(item.getUnVerAmt()) != 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(records)) {
                return PagingVO.empty();
            }
            param.size = size;
            param.current = current;
            param.setIds(records.stream().map(ArOrderExVo::getId).collect(Collectors.toList()));
            page = arOrderExRepoProc.page(param);
            setInfo(page);
        }

        return page;
    }

    @Override
    @SysCodeProc
    public PagingVO<ArOrderDtlExVo> detailPage(ArOrderDtlExPageParam param) {

        PagingVO<ArOrderDtlExVo> page = arOrderExRepoProc.detailPage(param);

        if (page.isEmpty()) {
            return page;
        }
        setDetailInfo(page.getRecords());
        return page;
    }

    /**
     * 返回结果内容填充.
     *
     * @param records 返回结果
     */
    private void setDetailInfo(List<ArOrderDtlExVo> records) {

        Set<String> itemCodes = new HashSet<>();
        Set<String> buCodes = new HashSet<>();
        Set<String> custCodes = new HashSet<>();
        Set<String> saleUserCodes = new HashSet<>();
        setDetailCode(records, itemCodes, buCodes, custCodes, saleUserCodes);

        // 公司组织
        List<SysOrgBasicDTO> orgList = getOrgList(buCodes);
        Map<String, String> orgMap = new HashMap<>();
        if (CollUtil.isNotEmpty(orgList)) {
            orgMap = orgList.stream().collect(Collectors.toMap(k -> k.getCode(), v -> v.getName(), (v1, v2) -> v2));
        }

        // 客户
        List<LmSaveCustRespVO> custResult = getCustList(custCodes);
        Map<String, String> custMap = new HashMap<>();
        if (CollUtil.isNotEmpty(orgList)) {
            custMap = custResult.stream().collect(Collectors.toMap(k -> k.getCustCode(), v -> v.getCustName(), (v1, v2) -> v2));
        }

        // 业务员
        List<SysEmployeeBasicDTO> employeeList = getEmployeeList(saleUserCodes);
        Map<String, String> empMap = new HashMap<>();
        if (CollUtil.isNotEmpty(orgList)) {
            empMap = employeeList.stream().collect(Collectors.toMap(k -> k.getCode(), v -> v.getLastName(), (v1, v2) -> v2));
        }

        List<ItmItemDTO> itemList = getItemDtoByItemCodes(itemCodes);

        Map<String, String> finalOrgMap = orgMap;
        Map<String, String> finalCustMap = custMap;
        Map<String, String> finalEmpMap = empMap;
        records.forEach(arOrderExVo -> {
            arOrderExVo.setArOrderType("应收单");
            if (StrUtil.isEmpty(arOrderExVo.getOrderNo())) {
                arOrderExVo.setOrderNo(arOrderExVo.getSalSoDocNo());
            }
            // 商品信息
            if (!CollectionUtils.isEmpty(itemList)) {
                itemList.stream().filter(fi -> fi.getItemCode().equals(arOrderExVo.getItemCode()))
                        .findFirst()
                        .ifPresent(opt -> {
                            arOrderExVo.setItemName(opt.getItemName());
                            arOrderExVo.setItemSpec(opt.getSpec());
                        });
            }

            // 公司
            if (StrUtil.isEmpty(arOrderExVo.getOuName()) && finalOrgMap.containsKey(arOrderExVo.getOuCode())) {
                arOrderExVo.setOuName(finalOrgMap.get(arOrderExVo.getOuCode()));
            }
            // 组织
            if (StrUtil.isEmpty(arOrderExVo.getBuName()) && finalOrgMap.containsKey(arOrderExVo.getMasBuCode())) {
                arOrderExVo.setBuCode(arOrderExVo.getMasBuCode());
                arOrderExVo.setBuName(finalOrgMap.get(arOrderExVo.getMasBuCode()));
            }
            // 客户
            if (finalCustMap.containsKey(arOrderExVo.getCustCode())) {
                arOrderExVo.setCustomName(finalCustMap.get(arOrderExVo.getCustCode()));
            }
            // 业务员
            if (StrUtil.isEmpty(arOrderExVo.getBusinessName()) && finalEmpMap.containsKey(arOrderExVo.getBusinessCode())) {
                arOrderExVo.setBusinessName(finalEmpMap.get(arOrderExVo.getBusinessCode()));
            }
        });
    }

    /**
     * 根据商品编码查询商品信息.
     *
     * @param itemCodes 商品编码
     * @return 查询结果
     */
    private List<ItmItemDTO> getItemDtoByItemCodes(Set<String> itemCodes) {
        if (itemCodes.isEmpty()) {
            return Collections.emptyList();
        }
        return null;//itmItemDomainService.findItemDtoByItemCodes(new ArrayList<>(itemCodes));
    }

    private void setDetailCode(List<ArOrderDtlExVo> records, Set<String> itemCodes, Set<String> buCodes, Set<String> custCodes, Set<String> saleUserCodes) {
        for (ArOrderDtlExVo vo : records) {
            itemCodes.add(vo.getItemCode());
            buCodes.add(vo.getOuCode());
            buCodes.add(vo.getBuCode());
            buCodes.add(vo.getMasBuCode());
            custCodes.add(vo.getCustCode());
            saleUserCodes.add(vo.getSaleUser());
        }
    }

    private void setInfo(PagingVO<ArOrderExVo> page) {

        Set<String> buCodes = new HashSet<>(8);
        Set<String> custCodes = new HashSet<>(8);
        Set<String> currCodes = new HashSet<>(8);
        Set<String> saleUserCodes = new HashSet<>(8);
        Set<Long> masIds = new HashSet<>(8);
        setCode(page, buCodes, custCodes, currCodes, saleUserCodes, masIds);

        List<ArOderExDtlDo> arOderExDtlDo = arOrderDetailRepoProc.listByMasIds(masIds);
        List<SysOrgBasicDTO> orgList = getOrgList(buCodes);
        List<LmSaveCustRespVO> custResult = getCustList(custCodes);
        List<SysCurrencyRespDTO> currList = getCurrList(currCodes);
        List<SysEmployeeBasicDTO> employeeList = getEmployeeList(saleUserCodes);

        page.getRecords().forEach(arOrderExVo -> {
            arOrderExVo.setArTypeName("应收单");
            // 部门名称
            if (!CollectionUtils.isEmpty(orgList)) {
                orgList.stream().filter(fi -> fi.getCode().equals(arOrderExVo.getBuCode()))
                        .findFirst()
                        .ifPresent(opt -> arOrderExVo.setBuName(opt.getName()));
                orgList.stream().filter(fi -> fi.getCode().equals(arOrderExVo.getOuCode()))
                        .findFirst()
                        .ifPresent(opt -> arOrderExVo.setOuName(opt.getName()));
            }
            // 客户名称
            if (!CollectionUtils.isEmpty(custResult)) {
                custResult.stream().filter(fi -> fi.getCustCode().equals(arOrderExVo.getCustCode()))
                        .findFirst()
                        .ifPresent(opt -> arOrderExVo.setCustomName(opt.getCustName()));
            }
            // 币种名称
            if (!CollectionUtils.isEmpty(currList)) {
                currList.stream().filter(fi -> fi.getCurrCode().equals(arOrderExVo.getCurrCode()))
                        .findFirst()
                        .ifPresent(opt -> arOrderExVo.setCurrName(opt.getCurrName()));
            }
            // 业务员信息
            if (!CollectionUtils.isEmpty(employeeList)) {
                employeeList.stream().filter(fi -> fi.getCode().equals(arOrderExVo.getSaleUser()))
                        .findFirst()
                        .ifPresent(opt -> arOrderExVo.setBusinessName(opt.getLastName()));
            }

            BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
            BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
            BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额

            List<ArOderExDtlDo> extDList = arOderExDtlDo.stream().filter(fi -> fi.getMasId().equals(arOrderExVo.getExtId()))
                    .collect(Collectors.toList());
            if (CollUtil.isNotEmpty(extDList)) {
                for (ArOderExDtlDo arOderExDtlDo1 : extDList) {
                    verAmt = verAmt.add(arOderExDtlDo1.getVerAmt());
                    verAmting = verAmting.add(arOderExDtlDo1.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(arOderExDtlDo1.getUnVerAmt());
                }
            }
            arOrderExVo.setVerAmt(verAmt);
            arOrderExVo.setApplyVerAmTing(verAmting);
            arOrderExVo.setUnVerAmt(unVerAmt);

            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(arOrderExVo.getTotalAmt()) == 0) {
                arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }

        });
    }

    private List<SysCurrencyRespDTO> getCurrList(Set<String> currCodes) {
        ApiResult<List<SysCurrencyRespDTO>> currResult = sysCurrencyRpcService.listByCodes(currCodes);
        if (currResult.isFailed()) {
            throw new BusinessException("获取币种信息失败");
        }
        return currResult.getData();
    }

    private List<SysEmployeeBasicDTO> getEmployeeList(Set<String> saleUserCodes) {
        EmployeeQueryDTO eeQuery = new EmployeeQueryDTO();
        eeQuery.setCodes(saleUserCodes);
        ApiResult<List<SysEmployeeBasicDTO>> eeResult = employeeRpcService.queryList(eeQuery);
        if (eeResult.isFailed()) {
            throw new BusinessException("获取业务员信息失败");
        }
        return eeResult.getData();
    }

    private List<LmSaveCustRespVO> getCustList(Set<String> custCodes) {
        CustCode2BaseParam custQuery = new CustCode2BaseParam();
        custQuery.setCustCode(new ArrayList<>(custCodes));
        return crmCustRpcService.findBaseCustInfo(custQuery);
    }

    private List<SysOrgBasicDTO> getOrgList(Set<String> buCodes) {
        SysOrgQueryDTO orgQuery = new SysOrgQueryDTO();
        orgQuery.setCodes(buCodes);
        ApiResult<List<SysOrgBasicDTO>> orgResult = orgRpcService.queryList(orgQuery);
        if (orgResult.isFailed()) {
            throw new BusinessException("获取公司信息失败");
        }
        return orgResult.getData();
    }

    private void setCode(PagingVO<ArOrderExVo> page, Set<String> buCodes, Set<String> custCodes, Set<String> currCodes, Set<String> saleUserCodes, Set<Long> masIds) {
        for (ArOrderExVo vo : page.getRecords()) {
            buCodes.add(vo.getOuCode());
            buCodes.add(vo.getBuCode());
            custCodes.add(vo.getCustCode());
            currCodes.add(vo.getCurrCode());
            saleUserCodes.add(vo.getSaleUser());
            masIds.add(vo.getExtId());
        }
    }

    /**
     * 明细表头
     *
     * @param res
     * @return
     */
    @Override
    @SysCodeProc
    public ArOrderExVo getDetailExInfo(ArOrderVO res) {
        //主数据扩展字段拼装
        List<ArOrderExDTO> list = select(ArOrderExDTO.class).where(arOrderExDo.relateId.eq(res.getRelateId())).fetch();
        ArOrderExVo arOrderExVo = new ArOrderExVo();
        if (CollUtil.isNotEmpty(list)) {
            ArOrderExDTO arOrderExDTO = list.get(0);
            ArOrderExVo arOrderExVo1 = ArOrderExConvert.INSTANCE.qeryDto2Vo(arOrderExDTO);
            ArOrderExVo arOrderExVo2 = ArOrderExConvert.INSTANCE.Vo2ExVo(res);
            arOrderExVo = (ArOrderExVo) BeanConvertUtils.beanConvert(arOrderExVo1, arOrderExVo2);
            try {
                final SysOrgBasicDTO data = orgRpcService.getByCode(arOrderExVo.getBuCode()).getData();
                arOrderExVo.setBuName(data == null ? "" : data.getName());//销售组织
                final CrmCustDTO data1 = crmCustRpcService.getCustInfo(arOrderExVo.getCustCode()).getData();
                arOrderExVo.setCustomName(data1 == null ? "" : data1.getCustName());//客户名称
                final SysOrgBasicDTO data2 = orgRpcService.getByCode(arOrderExVo.getOuCode()).getData();
                arOrderExVo.setOuName(data2 == null ? "" : data2.getName());//公司名称
                SysCurrencyRespDTO data3 = sysCurrencyRpcService.getByCode(arOrderExVo.getCurrCode()).getData();
                arOrderExVo.setCurrName(data3 == null ? "" : data3.getCurrName());//币种名称
                final SysEmployeeBasicDTO data4 = employeeRpcService.getByCode(arOrderExVo.getSaleUser()).getData();
                arOrderExVo.setBusinessName(data4 == null ? "" : data4.getLastName());//业务员名称
                arOrderExVo.setArTypeName("应收单");
                List<Long> masIds = Arrays.asList(arOrderExDTO.getId());
                List<ArOderExDtlDo> arOderExDtlDo = arOrderDetailRepoProc.listByMasIds(masIds);
                List<ArOderExDtlDo> extDList = arOderExDtlDo.stream().filter(fi -> fi.getMasId().equals(arOrderExDTO.getId()))
                        .collect(Collectors.toList());
                BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
                BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
                BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
                if (CollUtil.isNotEmpty(extDList)) {
                    for (ArOderExDtlDo arOderExDtlDo1 : extDList) {
                        verAmt = verAmt.add(arOderExDtlDo1.getVerAmt());
                        verAmting = verAmting.add(arOderExDtlDo1.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(arOderExDtlDo1.getUnVerAmt());
                    }
                }
                arOrderExVo.setVerAmt(verAmt);
                arOrderExVo.setApplyVerAmTing(verAmting);
                arOrderExVo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(arOrderExVo.getTotalAmt()) == 0) {
                    arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arOrderExVo;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                arOrderExDo.id,
                arOrderExDo.orderCustomer,
                arOrderExDo.invoiceNumber,
                arOrderExDo.invDate,
                arOrderExDo.relateId,
                arOrderExDo.invType,
                arOrderExDo.startDate,
                arOrderExDo.redFlushSign,
                arOrderExDo.thirdPaymentAssistance,
                arOrderExDo.consumerCardSsistance,
                arOrderExDo.creditCardAssistance,
                arOrderExDo.deleteFlag,
                arOrderExDo.tenantId,
                arOrderExDo.belongOrgId,
                arOrderExDo.tenantOrgId,
                arOrderExDo.createTime,
                arOrderExDo.updater,
                arOrderExDo.modifyTime,
                arOrderExDo.creator,
                arOrderExDo.remark,
                qArOrderDO.custCode,
                qArOrderDO.sourceNo
        )).from(arOrderExDo)
                .leftJoin(qArOderExDtlDo).on(qArOderExDtlDo.masId.eq(arOrderExDo.id));
    }

    @Override
    public List<ArOrderDtlExVo> listArOrderDetail(FinArOrderDetailQuery query) {
        return arOrderDetailRepoProc.listArOrderDetail(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateVerAmt(Long arDId, BigDecimal amt, String verType) {
        ArOderExDtlDo detail = findDetail(arDId);
        doUpdateVerAmt(getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMiddleVerAmt(Long arDId, BigDecimal amt) {
        ArOderExDtlDo detail = findDetail(arDId);
        doUpdateVerAmt(getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    /**
     * 通过应收单id查询明细信息
     *
     * @param id
     * @return
     */
    @Override
    public ApiResult<ArOrderExVo> info(Long id) {
        ArOrderDTO arOrderDTO = arOrderDomainService.get(id);


        return null;
    }

    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ArOderExDtlDo detail) {

        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);

        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("请核对金额数据");
        }

        return ArOrderAmtUpdateDTO.builder()
                .arDId(detail.getExtId())
                .unVerAmt(unVerAmt)
                .verAmting(verAmting)
                .verAmt(detail.getVerAmt())
                .version(detail.getVersion());

    }

    @NotNull
    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ArOderExDtlDo detail, String verType) {
        String infoStr = JSONUtil.toJsonStr(detail);
        log.info("计算应收单核销金额,{}-{}", amt, infoStr);
        // 取消核销
/*        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {*/
        if (true) {

            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("取消核销,{}-{}-{}", infoStr, verAmt, unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return ArOrderAmtUpdateDTO.builder()
                    .arDId(detail.getExtId())
                    .unVerAmt(unVerAmt)
                    .verAmting(detail.getApplyVerAmTing())
                    .verAmt(verAmt)
                    .version(detail.getVersion());

        } else {
            // 核销通过
            BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
            BigDecimal verAmt = detail.getVerAmt().add(amt);
            log.info("核销通过,{}-{}-{}", infoStr, verAmting, verAmt);
            if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return ArOrderAmtUpdateDTO.builder()
                    .arDId(detail.getExtId())
                    .unVerAmt(detail.getUnVerAmt())
                    .verAmting(verAmting)
                    .verAmt(verAmt)
                    .version(detail.getVersion());
        }

    }

    @NotNull
    private ArOderExDtlDo findDetail(Long arDId) {
        ArOderExDtlDo detail = arOrderDetailRepoProc.getArOrderDetailAmt(arDId);
        Assert.notNull(detail, "未查询到应收单明细，明细ID:" + arDId);
        return detail;
    }

    private void doUpdateVerAmt(ArOrderAmtUpdateDTO update) {
        if (arOrderDetailRepoProc.updateVerAmt(update) == 0) {
            throw new BusinessException("更新核销金额失败，请稍后重试");
        }
    }
}
