package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.application.service.excel.entity.ArListExportEntity;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_AR_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class ArExportUsingParamServiceImpl implements DataExport<ArListExportEntity, ArOrderPageParam> {
    private final ArOrderService arOrderService;
    @Override
    public String getTmplCode() {
        return FIN_AR_EXPORT_DEFAULT;
    }
    @Override
    public PagingVO<ArListExportEntity> executeExport(ArOrderPageParam queryParam) {
        PagingVO<ArOrderVO> page = arOrderService.page(queryParam);
        return new PagingVO<>(
            page.getTotal(),
            ExcelConvertUtils.convertLoosely(page.getRecords(), ArListExportEntity.class)
        );
    }
}
