package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.ApOrderExportEntity;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_AP_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultApOrderExportServiceImpl implements DataExport<ApOrderExportEntity, ApOrderPageParam> {
    private final ApOrderRepoProc apOrderRepoProc;
    private final UdcProvider udcProvider;
    private final static Map<String, String> emptyMap = Map.of();
    @Override
    public String getTmplCode() {
        return FIN_AP_EXPORT_DEFAULT;
    }
    @Override
    public PagingVO<ApOrderExportEntity> executeExport(ApOrderPageParam queryParam) {
        PagingVO<ApOrderExportEntity> page = apOrderRepoProc.defaultExport(queryParam);
        if (page == null || page.isEmpty()) {
            return new PagingVO<>(0, List.of());
        }
        List<ApOrderExportEntity> records = page.getRecords();
        var recDocClsMap = getUdcMap("yst-fin", "AP_DOC_CLS");
        var orderStateMap = getUdcMap("yst-supp", "APPLY_STATUS");
        var verifyStatusMap = getUdcMap("yst-fin", "VERIFY_STATUS");
        var proposedStatusMap = getUdcMap("yst-fin", "DOC_PROPOSED_STATUS");
        ExcelConverterManager.refresh();
        for (ApOrderExportEntity record : records) {
            record.setCreateModeName(recDocClsMap.get(record.getCreateMode()));
            record.setOrderStateName(orderStateMap.get(record.getOrderState()));
            record.setVerStateName(verifyStatusMap.get(record.getVerState()));
            record.setProposedStatusName(proposedStatusMap.get(record.getProposedStatus()));
            ExcelConvertUtils.convertSelfLoosely(record);
        }
        
        return page;
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
    
    private Map<String, String> getUdcMap(String appCode, String udcCode) {
        if(StringUtils.isBlank(appCode) || StringUtils.isBlank(udcCode)) {
            return emptyMap;
        }
        Map<String, String> valueMapByUdcCode = udcProvider.getValueMapByUdcCode(appCode, udcCode);
        return ObjectUtils.defaultIfNull(valueMapByUdcCode, emptyMap);
    }
}
