package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderDtlConvert;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyConvert;
import com.elitesland.fin.application.facade.dto.writeoff.*;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.param.payorder.FinPayOrderDetailQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.facade.vo.writeoff.*;
import com.elitesland.fin.application.service.aporder.ApOrderDtlService;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.payorder.PayOrderDtlService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.common.*;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyDO;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigDtlRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyRepoProc;
import com.elitesland.fin.utils.ThreadLocalCopyUtil;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyServiceImpl implements FinApPayVerApplyService {
    private final FinApPayVerApplyRepoProc finApPayVerApplyRepoProc;
    private final FinApPayVerApplyApService finApPayVerApplyApService;
    private final FinApPayVerApplyApHeadService finApPayVerApplyApHeadService;
    private final FinApPayVerApplyPayService finApPayVerApplyPayService;
    private final FinApPayVerApplyPayHeadService finApPayVerApplyPayHeadService;
    private final SeqNumProvider seqNumProvider;
    private final FinApPayVerApplySettleService finApPayVerApplySettleService;
    private final OperationLogService operationLogService;
    private final ThreadLocalCopyUtil threadLocalCopyUtil;
    private final ApOrderDtlService apOrderDtlService;
    private final PayOrderDtlService payOrderDtlService;
    private final ApOrderService apOrderService;
    private final PayOrderService payOrderService;
    private final ApVerConfigDomainService apVerConfigDomainService;
    private final ApVerConfigDtlRepoProc apVerConfigDtlRepoProc;
    private final ApOrderDomainService apOrderDomainService;
    private final PayOrderDomainService payOrderDomainService;
    public static final ThreadLocal<String> CURRENT_USER = new ThreadLocal<>();

    //@Value("${sync.tenantCode}")
    //private String tenantCode;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(FinApPayVerApplySaveDTO save) {
        if (save.getId() == null) {
            return doCreate(save);
        } else {
            return doUpdate(save);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long submit(FinApPayVerApplySaveDTO save) {

        verifyDataNew(save);

        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = this.save(save);
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, id.toString(), OperationTypeEnum.APPROVE_SUBMIT,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));

        updateArMiddleVerAmt(save.getApSaveList());
        updateRecMiddleVerAmt(save.getPaySaveList());

        finApPayVerApplySettleService.createBatch(id, settleApplyDetailListNew(save.getApSaveList(), save.getPaySaveList()));
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long writeOffSubmit(FinApPayVerApplySaveDTO save) {

        checkWriteOffParamNew(save);

        //金额分摊
        buildArAndRecSaveList(save);

        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = saveFinArRecVerApply(save);

        operationLogService.simpleSendLog(BusinessObjectConstant.FIN_AP_PAY_APPLY, id.toString(), OperationTypeEnum.APPROVE_SUBMIT,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));

        List<FinApPayVerApplyApSaveDTO> finApPayVerApplyApSaveDTOList = save.getApHeadSaveList().stream()
                .flatMap(item -> item.getApSaveList().stream())
                .collect(Collectors.toList());

        List<FinApPayVerApplyPaySaveDTO> finApPayVerApplyPaySaveDTOList = save.getPayHeadSaveList().stream()
                .flatMap(item -> item.getPaySaveList().stream())
                .collect(Collectors.toList());

        updateArMiddleVerAmt(finApPayVerApplyApSaveDTOList);
        updateRecMiddleVerAmt(finApPayVerApplyPaySaveDTOList);


        List<FinApPayVerApplySettleSaveDTO> finApPayVerApplySettleSaveDTOList = settleApplyDetailListNew(finApPayVerApplyApSaveDTOList, finApPayVerApplyPaySaveDTOList);
        finApPayVerApplySettleSaveDTOList.forEach(finArRecVerApplySettleSaveDTO -> {
            finArRecVerApplySettleSaveDTO.setOuId(save.getOuId());
            finArRecVerApplySettleSaveDTO.setOuCode(save.getOuCode());
            finArRecVerApplySettleSaveDTO.setOuName(save.getOuName());
        });

        finApPayVerApplySettleService.createBatch(id, finApPayVerApplySettleSaveDTOList);
        save.setId(id);
        //审核
        FinApPayApplyApprovalDTO dto = new FinApPayApplyApprovalDTO();
        ArrayList<String> applyNos=new ArrayList<>();
        applyNos.add(save.getApplyDocNo());
        dto.setApplyNos(applyNos);
        dto.setApprovalType(FinApPayApplyApprovalDTO.ApprovalType.APPROVE);
        this.writeOffApprove(dto);
        return id;
    }

    public Long saveFinArRecVerApply(FinApPayVerApplySaveDTO save) {
        if (save.getId() == null) {
            return createFinArRecVerApply(save);
        } else {
            return updateFinArRecVerApply(save);
        }
    }

    private Long updateFinArRecVerApply(FinApPayVerApplySaveDTO save) {
        if(save.getSchemeId()==null){
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }
        updateApplyOrder(save);

        List<FinApPayVerApplyApHeadVO> finApPayVerApplyApHeadVOList = finApPayVerApplyApHeadService.listByMasIds(Lists.newArrayList(save.getId()));
        Assert.notEmpty(finApPayVerApplyApHeadVOList, "查不到应收单");

        List<FinApPayVerApplyPayHeadVO> finApPayVerApplyPayHeadVOList = finApPayVerApplyPayHeadService.listByMasIds(Lists.newArrayList(save.getId()));
        Assert.notEmpty(finApPayVerApplyPayHeadVOList, "查不到收款单");

        // 删除核销单
        finApPayVerApplyApHeadService.deleteByMasId(Lists.newArrayList(save.getId()));
        finApPayVerApplyPayHeadService.deleteByMasId(Lists.newArrayList(save.getId()));

        finApPayVerApplyApService.deleteByMasId(finApPayVerApplyApHeadVOList.stream().map(FinApPayVerApplyApHeadVO::getId).collect(Collectors.toSet()));
        finApPayVerApplyPayService.deleteByMasId(finApPayVerApplyPayHeadVOList.stream().map(FinApPayVerApplyPayHeadVO::getId).collect(Collectors.toSet()));


        // 插入核销单
        save.getApHeadSaveList().stream().forEach(item -> {
            Long masId = finApPayVerApplyApHeadService.create(save.getId(), item);
            // 插入核销单明细
            finApPayVerApplyApService.createBatch(masId, item.getApSaveList());
        });

        save.getPayHeadSaveList().stream().forEach(item -> {
            Long masId = finApPayVerApplyPayHeadService.create(save.getId(), item);
            // 插入核销单明细
            finApPayVerApplyPayService.createBatch(masId, save.getPaySaveList());
        });

        return save.getId();
    }

    private Long createFinArRecVerApply(FinApPayVerApplySaveDTO save) {
        if(save.getSchemeId()==null){
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }

        Optional<FinApPayVerApplyApHeadSaveDTO> arHeadSaveDTOOptional = save.getApHeadSaveList().stream().filter(arHeadSaveDTO ->
                org.apache.commons.lang3.StringUtils.isNotBlank(arHeadSaveDTO.getOuCode()) || Objects.nonNull(arHeadSaveDTO.getOuId())).findFirst();
        if (arHeadSaveDTOOptional.isPresent()){
            arHeadSaveDTOOptional.ifPresent(finArRecVerApplyArHeadSaveDTO -> {
                save.setOuId(finArRecVerApplyArHeadSaveDTO.getOuId());
                save.setOuCode(finArRecVerApplyArHeadSaveDTO.getOuCode());
                save.setOuName(finArRecVerApplyArHeadSaveDTO.getOuName());
            });

        }else {
            Optional<FinApPayVerApplyPayHeadSaveDTO> recHeadSaveDTOOptional = save.getPayHeadSaveList().stream().filter(recHeadSaveDTO ->
                    org.apache.commons.lang3.StringUtils.isNotBlank(recHeadSaveDTO.getOuCode()) || Objects.nonNull(recHeadSaveDTO.getOuId())).findFirst();
            if (recHeadSaveDTOOptional.isPresent()){
                recHeadSaveDTOOptional.ifPresent(recVerApplyRecHeadSaveDTO -> {
                    save.setOuId(recVerApplyRecHeadSaveDTO.getOuId());
                    save.setOuCode(recVerApplyRecHeadSaveDTO.getOuCode());
                    save.setOuName(recVerApplyRecHeadSaveDTO.getOuName());
                });
            }
        }
        // 插入核销单数据
        long id = createApplyOrder(save);

        save.getApHeadSaveList().stream().forEach(item -> {
            Long masId = finApPayVerApplyApHeadService.create(id, item);
            // 插入核销单明细
            finApPayVerApplyApService.createBatch(masId, item.getApSaveList());
        });

        save.getPayHeadSaveList().stream().forEach(item -> {
            Long masId = finApPayVerApplyPayHeadService.create(id, item);
            // 插入核销单明细
            finApPayVerApplyPayService.createBatch(masId, item.getPaySaveList());
        });
        return id;
    }

    private void buildArAndRecSaveList(FinApPayVerApplySaveDTO save) {

        buildApHeadSaveList(save);

        buildRecHeadSaveList(save);
    }

    private void buildApHeadSaveList(FinApPayVerApplySaveDTO save) {

        List<FinApPayVerApplyApHeadSaveDTO> finApPayVerApplyApHeadSaveDTOList = save.getApHeadSaveList();
        // 查询应收单
        List<Long> arOrderIds = finApPayVerApplyApHeadSaveDTOList.stream().map(FinApPayVerApplyApHeadSaveDTO::getId).collect(Collectors.toList());
        ApOrderDtlPageParam apOrderDtlPageParam = new ApOrderDtlPageParam();
        apOrderDtlPageParam.setMasIds(arOrderIds);
        apOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<ApOrderDtlVO> apOrderDtlVOPagingVO = apOrderDtlService.page(apOrderDtlPageParam);
        List<ApOrderDtlVO> apOrderDtlVOS = apOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty(apOrderDtlVOS, "查不到应收单明细");
        finApPayVerApplyApHeadSaveDTOList.forEach(apOrder -> {
            List<ApOrderDtlVO> apOrderDtlVOList = apOrderDtlVOS.stream()
                    .filter(apOrderDtlVO -> apOrderDtlVO.getMasId().equals(apOrder.getId()))
                    .collect(Collectors.toList());
            Assert.notEmpty(apOrderDtlVOList, "查不到应收单明细");

            //设置初始值
            apOrder.setApSaveList(CollectionUtils.isEmpty(apOrder.getApSaveList()) ? Lists.newArrayList() : apOrder.getApSaveList());
            if (apOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                ApOrderDtlVO apOrderDtlVO = apOrderDtlVOList.get(0);
                buildApSaveList(apOrderDtlVO, apOrder.getVerAmt(), apOrder);
                return;
            }
            ApOrderDtlVO arOrderDtlVO = apOrderDtlVOList.stream()
                    .filter(item -> apOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst()
                    .orElse(null);
            if (arOrderDtlVO != null) {
                buildApSaveList(arOrderDtlVO, apOrder.getVerAmt(), apOrder);
            }
            if (arOrderDtlVO == null) {

                BigDecimal balance = apOrder.getVerAmt();

                for (ApOrderDtlVO item : apOrderDtlVOList) {

                    if (BigDecimal.ZERO.compareTo(item.getUnVerAmt()) == 0) {
                        continue;
                    }

                    if (apOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item.getUnVerAmt()) <= 0) {
                            buildApSaveList(item, balance, apOrder);
                            break;
                        }
                        if (balance.compareTo(item.getUnVerAmt()) > 0) {
                            buildApSaveList(item, item.getUnVerAmt(), apOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }

                    if (apOrder.getVerAmt().compareTo(BigDecimal.ZERO) < 0) {

                        if (balance.compareTo(item.getUnVerAmt()) >= 0) {
                            buildApSaveList(item, balance, apOrder);
                            break;
                        }

                        if (balance.compareTo(item.getUnVerAmt()) < 0) {
                            buildApSaveList(item, item.getUnVerAmt(), apOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }
                }
            }
        });
    }

    private void buildApSaveList(ApOrderDtlVO apOrderDtlVO, BigDecimal amount, FinApPayVerApplyApHeadSaveDTO finApPayVerApplyApHeadSaveDTO) {
        apOrderDtlVO.setVerAmt(amount);
        apOrderDtlVO.setApId(finApPayVerApplyApHeadSaveDTO.getId());
        apOrderDtlVO.setApDocNo(finApPayVerApplyApHeadSaveDTO.getApOrderNo());
/*        apOrderDtlVO.setOutApDocNo(finApPayVerApplyApHeadSaveDTO.getSourceNo());
        apOrderDtlVO.setOutApDId(apOrderDtlVO.getThirdOrderDtId());
        apOrderDtlVO.setSalesmanName(apOrderDtlVO.getBusinessName());
        apOrderDtlVO.setOrdererName(apOrderDtlVO.getRecvContactName());
        apOrderDtlVO.setOrdererPhone(apOrderDtlVO.getRecvContactTel());
        apOrderDtlVO.setOrdererAddr(apOrderDtlVO.getRecDetailaddr());
        apOrderDtlVO.setNotVerAmt(apOrderDtlVO.getUnVerAmt());
        apOrderDtlVO.setChanType(apOrderDtlVO.getSoSource());
        apOrderDtlVO.setSubCustName(apOrderDtlVO.getCustName());
        apOrderDtlVO.setCustName(apOrderDtlVO.getCustomName());
        apOrderDtlVO.setNotVerAmt(apOrderDtlVO.getUnVerAmt());*/
        FinApPayVerApplyApSaveDTO finApPayVerApplyApSaveDTO = ApOrderDtlConvert.INSTANCE.VO2DTO(apOrderDtlVO);
        finApPayVerApplyApSaveDTO.setApDId(apOrderDtlVO.getId());
        finApPayVerApplyApHeadSaveDTO.getApSaveList().add(finApPayVerApplyApSaveDTO);
        finApPayVerApplyApHeadSaveDTO.setSalesmanName(finApPayVerApplyApHeadSaveDTO.getBusinessName());
        finApPayVerApplyApHeadSaveDTO.setSalesmanCode(finApPayVerApplyApHeadSaveDTO.getSaleUser());
    }

    private void buildRecHeadSaveList(FinApPayVerApplySaveDTO save) {
        List<FinApPayVerApplyPayHeadSaveDTO> finApPayVerApplyPayHeadSaveDTOS = save.getPayHeadSaveList();
        // 查询收款单
        List<Long> recIds = finApPayVerApplyPayHeadSaveDTOS.stream().map(FinApPayVerApplyPayHeadSaveDTO::getId).collect(Collectors.toList());
        PayOrderDtlPageParam payOrderDtlPageParam = new PayOrderDtlPageParam();
        payOrderDtlPageParam.setMasIds(recIds);
        payOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        final PagingVO<PayOrderDtlVO> payOrderDtlVOPagingVO= payOrderDtlService.page(payOrderDtlPageParam);
        final List<PayOrderDtlVO> payOrderDtlVOS=payOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty(payOrderDtlVOS, "查不到收款单明细");
        finApPayVerApplyPayHeadSaveDTOS.forEach(payOrder -> {
            List<PayOrderDtlVO> payOrderDtlVOList = payOrderDtlVOS.stream()
                    .filter(payOrderDtlVO -> payOrderDtlVO.getMasId().equals(payOrder.getId()))
                    .collect(Collectors.toList());
            Assert.notEmpty(payOrderDtlVOList, "查不到收款单明细");
            //设置初始值
            payOrder.setPaySaveList(CollectionUtils.isEmpty(payOrder.getPaySaveList()) ? Lists.newArrayList() : payOrder.getPaySaveList());
            if (payOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                PayOrderDtlVO payOrderDtlVO = payOrderDtlVOList.get(0);
                buildRecSaveList(payOrderDtlVO, payOrder.getVerAmt(), payOrder);
                return;
            }
            PayOrderDtlVO recOrderDtlVO = payOrderDtlVOList.stream()
                    .filter(item -> payOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst()
                    .orElse(null);

            if (recOrderDtlVO != null) {
                buildRecSaveList(recOrderDtlVO, payOrder.getVerAmt(), payOrder);
            }

            if (recOrderDtlVO == null) {

                BigDecimal balance = payOrder.getVerAmt();

                for (PayOrderDtlVO item : payOrderDtlVOList) {

                    if (BigDecimal.ZERO.compareTo(item.getUnVerAmt()) == 0) {
                        continue;
                    }

                    if (payOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item.getUnVerAmt()) <= 0) {
                            buildRecSaveList(item, balance, payOrder);
                            break;
                        }
                        if (balance.compareTo(item.getUnVerAmt()) > 0) {
                            buildRecSaveList(item, item.getUnVerAmt(), payOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }

                    if (payOrder.getVerAmt().compareTo(BigDecimal.ZERO) < 0) {

                        if (balance.compareTo(item.getUnVerAmt()) >= 0) {
                            buildRecSaveList(item, balance, payOrder);
                            break;
                        }

                        if (balance.compareTo(item.getUnVerAmt()) < 0) {
                            buildRecSaveList(item, item.getUnVerAmt(), payOrder);
                            balance = balance.subtract(item.getUnVerAmt());
                        }
                    }
                }
            }
        });
    }

    private void buildRecSaveList(PayOrderDtlVO payOrderDtlVO, BigDecimal amount, FinApPayVerApplyPayHeadSaveDTO finApPayVerApplyPayHeadSaveDTO) {
        payOrderDtlVO.setVerAmt(amount);
        payOrderDtlVO.setPayId(finApPayVerApplyPayHeadSaveDTO.getId());
        payOrderDtlVO.setPayDocNo(finApPayVerApplyPayHeadSaveDTO.getPayOrderNo());
       /* payOrderDtlVO.setOutRecDocNo(finArRecVerApplyRecHeadSaveDTO.getSourceNo());
        payOrderDtlVO.setOutRecDId(recOrderDtlVO.getThirdOrderDtId());
        payOrderDtlVO.setSalesmanName(recOrderDtlVO.getBusinessName());
        payOrderDtlVO.setOuName(finArRecVerApplyRecHeadSaveDTO.getRecOuName());
        payOrderDtlVO.setRecBuType(recOrderDtlVO.getRecKindName());
        payOrderDtlVO.setRecNat(recOrderDtlVO.getNaturePayment());
        payOrderDtlVO.setNotVerAmt(recOrderDtlVO.getUnVerAmt());*/
        FinApPayVerApplyPaySaveDTO finApPayVerApplyPaySaveDTO = PayOrderDtlConvert.INSTANCE.VO2DTO(payOrderDtlVO);
        finApPayVerApplyPaySaveDTO.setPayDId(payOrderDtlVO.getId());
        finApPayVerApplyPayHeadSaveDTO.getPaySaveList().add(finApPayVerApplyPaySaveDTO);
        finApPayVerApplyPayHeadSaveDTO.setSalesmanName(finApPayVerApplyPayHeadSaveDTO.getBusinessName());
        finApPayVerApplyPayHeadSaveDTO.setSalesmanCode(finApPayVerApplyPayHeadSaveDTO.getSaleUser());
    }

    private void checkWriteOffParam(FinApPayVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinApPayVerApplyApHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getApHeadSaveList();
        Assert.notEmpty(finArRecVerApplyArHeadSaveDTOList, "应收单不能为空");
        finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "核销金额不能为空"));

        List<FinApPayVerApplyPayHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getPayHeadSaveList();
        Assert.notEmpty(finArRecVerApplyRecHeadSaveDTOList, "收款单不能为空");
        finArRecVerApplyRecHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "核销金额不能为空"));

        BigDecimal arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinApPayVerApplyApHeadSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinApPayVerApplyPayHeadSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        Assert.isTrue(arVerAmt.compareTo(recVerAmt) == 0, "应收单收款单核销金额不相等");

        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }
    private void checkWriteOffParamNew(FinApPayVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinApPayVerApplyApHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getApHeadSaveList();
        List<FinApPayVerApplyPayHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getPayHeadSaveList();
        if(CollectionUtils.isEmpty(finArRecVerApplyArHeadSaveDTOList)&&CollectionUtils.isEmpty(finArRecVerApplyRecHeadSaveDTOList)){
            throw new BusinessException("应收单和收款单不能同时为空");
        }
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadSaveDTOList)){
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "应收单核销金额不能为空"));
            arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinApPayVerApplyApHeadSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if(CollectionUtils.isNotEmpty(finArRecVerApplyRecHeadSaveDTOList)){
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "收款单核销金额不能为空"));
            recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinApPayVerApplyPayHeadSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Assert.isTrue(arVerAmt.compareTo(recVerAmt) == 0, "应收单收款单核销金额不相等");
        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }

    @Override
    @SysCodeProc
    public FinApPayVerApplyVO detail(Long id) {

        FinApPayVerApplyDO entity = findApplyOrder(id);

        FinApPayVerApplyVO result = FinApPayVerApplyConvert.INSTANCE.entity2Vo(entity);

        // 数查询核销申请 应收单、收款单明细
        result.setApList(finApPayVerApplyApService.listByMasIds(Collections.singletonList(id)));
        result.setPayList(finApPayVerApplyPayService.listByMasIds(Collections.singletonList(id)));

        return result;
    }

    @Override
    @SysCodeProc
    public FinApPayVerApplyVO writeOffDetail(Long id) {
        FinApPayVerApplyDO entity = findApplyOrder(id);

        FinApPayVerApplyVO result = FinApPayVerApplyConvert.INSTANCE.entity2Vo(entity);

        FinApPayVerApplyVO headAndDetailInfo = queryHeadAndDetailInfo(Lists.newArrayList(id));

        result.setApHeadList(headAndDetailInfo.getApHeadList());
        result.setPayHeadList(headAndDetailInfo.getPayHeadList());

        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinApPayVerApplyVO> page(FinApPayVerApplyQuery query) {
        List<Long> masIds = new ArrayList<>();
        List<Long> arIds = new ArrayList<>();
        List<Long> recIds = new ArrayList<>();
        List<FinApPayVerApplyApVO> arVOList = finApPayVerApplyApService.listByOutArDocNoOrDId(query);

        if(CollUtil.isNotEmpty(arVOList)){
            masIds.addAll(arVOList.stream().map(FinApPayVerApplyApVO::getMasId).distinct().collect(Collectors.toList()));
            arIds.addAll(arVOList.stream().map(FinApPayVerApplyApVO::getId).distinct().collect(Collectors.toList()));
        }

        List<FinApPayVerApplyPayVO> recVOList = finApPayVerApplyPayService.listByOutRecDocNoOrDId(query);

        if(CollUtil.isNotEmpty(recVOList)){
            masIds.addAll(recVOList.stream().map(FinApPayVerApplyPayVO::getMasId).distinct().collect(Collectors.toList()));
            recIds.addAll(recVOList.stream().map(FinApPayVerApplyPayVO::getId).distinct().collect(Collectors.toList()));
        }

        if(CollUtil.isNotEmpty(masIds)){
            query.setIds(masIds.stream().distinct().collect(Collectors.toList()));
        }

        // 如果有参数，但是查询不到结果则直接返回
        if( (StrUtil.isNotEmpty(query.getOutApDocNo()) || StrUtil.isNotEmpty(query.getOutApDId())
                || StrUtil.isNotEmpty(query.getOutPayDocNo()) || StrUtil.isNotEmpty(query.getOutPayDId()) ) && CollUtil.isEmpty(masIds)){
            return PagingVO.empty();
        }

        PagingVO<FinApPayVerApplyDO> page = finApPayVerApplyRepoProc.joinPage(query);

        if (page.isEmpty()) {
            return PagingVO.empty();
        }

        PagingVO<FinApPayVerApplyVO> result = page.map(FinApPayVerApplyConvert.INSTANCE::entity2Vo);

        // 查询核销申请 应收单、收款单明细
        List<Long> ids = result.getRecords().stream().map(FinApPayVerApplyVO::getId).collect(Collectors.toList());
        List<FinApPayVerApplyApVO> arList = finApPayVerApplyApService.listByQuery(FinApPayVerApplyApQuery.builder().ids(arIds).masIds(ids).build());
        List<FinApPayVerApplyPayVO> recList = finApPayVerApplyPayService.listByQuery(FinApPayVerApplyPayQuery.builder().ids(recIds).masIds(ids).build());

        if (arList.isEmpty() && recList.isEmpty()) {
            return result;
        }
        //处理核销方案
        List<ApVerConfigDTO> apVerConfigDTOS = apVerConfigDomainService.queryAll();
        Map<Long, String> apVerConfigMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(apVerConfigDTOS)){
            apVerConfigMap = apVerConfigDTOS.stream().collect(Collectors.toMap(ApVerConfigDTO::getId, ApVerConfigDTO::getSchemeName));
        }
        Map<Long, String> finApVerConfigMap = apVerConfigMap;
        result.getRecords().forEach(e -> {
            e.setSchemeName(finApVerConfigMap.get(e.getSchemeId()));
            e.setApList(arList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
            e.setPayList(recList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
        });
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinApPayVerApplyVO> writeOffPage(FinApPayVerApplyQuery query) {
        List<Long> apMasIds = new ArrayList<>();
        List<Long> payMasIds = new ArrayList<>();
        List<Long> totalMasIds = new ArrayList<>();
        List<Long> apIds = new ArrayList<>();
        List<Long> payIds = new ArrayList<>();
        boolean existArRecQueryConditionFlag=false;
        boolean existApPayQueryConditionFlag=false;
        List<FinApPayVerApplyApVO> apVOList = finApPayVerApplyApService.listByOutArDocNoOrDId(query);

        if(CollUtil.isNotEmpty(apVOList)){
            List<FinApPayVerApplyApHeadVO> finArRecVerApplyArHeadVOS = finApPayVerApplyApHeadService.listByIds(query,apVOList.stream().map(FinApPayVerApplyApVO::getMasId).distinct().collect(Collectors.toList()));
            if(CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)){
                apMasIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinApPayVerApplyApHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            apIds.addAll(apVOList.stream().map(FinApPayVerApplyApVO::getId).distinct().collect(Collectors.toList()));
        }
        if( (StrUtil.isNotEmpty(query.getApOrderNo())
                || StrUtil.isNotEmpty(query.getApOuCode()) ||null!=query.getApOperUserId()
                || null!=query.getApSuppId())){
            existArRecQueryConditionFlag=true;
            if(CollUtil.isEmpty(apMasIds)){
                return PagingVO.empty();
            }

        }

        List<FinApPayVerApplyPayVO> payVOList = finApPayVerApplyPayService.listByOutRecDocNoOrDId(query);

        if(CollUtil.isNotEmpty(payVOList)){
            List<FinApPayVerApplyPayHeadVO> finArRecVerApplyArHeadVOS = finApPayVerApplyPayHeadService.listByIds(query,payVOList.stream().map(FinApPayVerApplyPayVO::getMasId).distinct().collect(Collectors.toList()));
            if(CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)){
                payMasIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinApPayVerApplyPayHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            payIds.addAll(payVOList.stream().map(FinApPayVerApplyPayVO::getId).distinct().collect(Collectors.toList()));
        }
        if( (StrUtil.isNotEmpty(query.getPayOrderNo())
                || StrUtil.isNotEmpty(query.getApOuCode())
                ||null!=query.getPayOperUserId()||null!=query.getPaySuppId())){
            existApPayQueryConditionFlag=true;
            if(CollUtil.isEmpty(payMasIds)){
                return PagingVO.empty();
            }

        }
        if(existArRecQueryConditionFlag&&!existApPayQueryConditionFlag){
            totalMasIds=apMasIds;
        }else if(!existArRecQueryConditionFlag&&existApPayQueryConditionFlag){
            totalMasIds=payMasIds;
        }else if(existArRecQueryConditionFlag&&existApPayQueryConditionFlag){
            totalMasIds=apMasIds.stream()
                    .filter(payMasIds::contains)
                    .collect(Collectors.toList());
        }else{
            totalMasIds.addAll(apMasIds);
            totalMasIds.addAll(payMasIds);
        }
        if(CollUtil.isEmpty(totalMasIds)){
            return PagingVO.empty();
        }
        query.setIds(totalMasIds.stream().distinct().collect(Collectors.toList()));
        // 如果有参数，但是查询不到结果则直接返回
        PagingVO<FinApPayVerApplyDO> page = finApPayVerApplyRepoProc.writeOffJoinPage(query);
        if (page.isEmpty()) {
            return PagingVO.empty();
        }

        PagingVO<FinApPayVerApplyVO> result = page.map(FinApPayVerApplyConvert.INSTANCE::entity2Vo);

        // 查询核销申请 应收单、收款单明细
        List<Long> ids = result.getRecords().stream().map(FinApPayVerApplyVO::getId).collect(Collectors.toList());
        List<Long> schemeIds = result.getRecords().stream().filter(v->WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode().equals(v.getVerMode())&&
                v.getSchemeId()!=null).map(FinApPayVerApplyVO::getSchemeId).collect(Collectors.toList());
        FinApPayVerApplyVO headAndDetailInfo = queryHeadAndDetailInfoByQuery(apIds,payIds,ids);
        Map<Long, String> schemeNameMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(schemeIds)){
            List<ApVerConfigDTO> apVerConfigDTOS = apVerConfigDomainService.findByIds(schemeIds);
            if(CollectionUtils.isNotEmpty(apVerConfigDTOS)){
                schemeNameMap = apVerConfigDTOS.stream().collect(Collectors.toMap(ApVerConfigDTO::getId, ApVerConfigDTO::getSchemeName));
            }
        }
        Map<Long, String> schemeNameMapFinal = schemeNameMap;
        result.getRecords().forEach(record -> {
            record.setApHeadList(headAndDetailInfo.getApHeadList().stream()
                    .filter(finArRecVerApplyArHeadVO -> record.getId().equals(finArRecVerApplyArHeadVO.getMasId())).collect(Collectors.toList()));

            record.setPayHeadList(headAndDetailInfo.getPayHeadList().stream()
                    .filter(finArRecVerApplyRecHeadVO -> record.getId().equals(finArRecVerApplyRecHeadVO.getMasId())).collect(Collectors.toList()));
            if (WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode().equals(record.getVerMode())&&
                    record.getSchemeId()!=null) {
                record.setSchemeName(schemeNameMapFinal.get(record.getSchemeId()));
            }

        });
        return result;
    }

    /**
     * 根据查询条件查询核销明细
     * @param arIds 应收id
     * @param recIds 收款id
     * @param masIds 主表id
     * @return
     */

    private FinApPayVerApplyVO queryHeadAndDetailInfoByQuery(List<Long> arIds,List<Long> recIds,List<Long> masIds) {

        List<FinApPayVerApplyApHeadVO> finArRecVerApplyArHeadVOList = finApPayVerApplyApHeadService.listByMasIds(masIds);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyArHeadVOList, "查不到应收单申请单");
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(FinApPayVerApplyApHeadVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyApVO> finArRecVerApplyArVOList = finApPayVerApplyApService.listByQuery(FinApPayVerApplyApQuery.builder().masIds(arMasIds).ids(arIds).build());
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinApPayVerApplyApVO> resultList = finArRecVerApplyArVOList.stream()
                        .filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到应收单申请单明细");
                finArRecVerApplyArHeadVO.setApList(resultList);
            });
        }
        List<FinApPayVerApplyPayHeadVO> finArRecVerApplyRecHeadVOList = finApPayVerApplyPayHeadService.listByMasIds(masIds);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyRecHeadVOList, "查不到收款单申请单");
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(FinApPayVerApplyPayHeadVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyPayVO> finArRecVerApplyRecVOList = finApPayVerApplyPayService.listByQuery(FinApPayVerApplyPayQuery.builder().masIds(recMasIds).ids(recIds).build());
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinApPayVerApplyPayVO> resultList = finArRecVerApplyRecVOList.stream()
                        .filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到收款单申请单明细");
                finArRecVerApplyRecHead.setPayList(resultList);
            });

        }
        FinApPayVerApplyVO finArRecVerApplyVO = new FinApPayVerApplyVO();
        finArRecVerApplyVO.setApHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setPayHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    private FinApPayVerApplyVO queryHeadAndDetailInfo(Collection<Long> ids) {

        List<FinApPayVerApplyApHeadVO> finArRecVerApplyArHeadVOList = finApPayVerApplyApHeadService.listByMasIds(ids);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyArHeadVOList, "查不到应收单申请单");
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(FinApPayVerApplyApHeadVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyApVO> finArRecVerApplyArVOList = finApPayVerApplyApService.listByMasIds(arMasIds);
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinApPayVerApplyApVO> resultList = finArRecVerApplyArVOList.stream()
                        .filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到应收单申请单明细");
                finArRecVerApplyArHeadVO.setApList(resultList);
            });
        }
        List<FinApPayVerApplyPayHeadVO> finArRecVerApplyRecHeadVOList = finApPayVerApplyPayHeadService.listByMasIds(ids);
        if(CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)){
            //Assert.notEmpty(finArRecVerApplyRecHeadVOList, "查不到收款单申请单");
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(FinApPayVerApplyPayHeadVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyPayVO> finArRecVerApplyRecVOList = finApPayVerApplyPayService.listByMasIds(recMasIds);
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinApPayVerApplyPayVO> resultList = finArRecVerApplyRecVOList.stream()
                        .filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId()))
                        .collect(Collectors.toList());
                //Assert.notEmpty(resultList, "查不到收款单申请单明细");
                finArRecVerApplyRecHead.setPayList(resultList);
            });

        }
        FinApPayVerApplyVO finArRecVerApplyVO = new FinApPayVerApplyVO();
        finArRecVerApplyVO.setApHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setPayHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approve(FinApPayApplyApprovalDTO dto) {

        if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }

        List<FinApPayVerApplyDO> applyList = finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);

        // 更新单据信息
        finApPayVerApplyRepoProc.save(applyList);

        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO!=null?sysUserDTO.getLastName():principal.getUsername();
        // 更新核销金额，改为异步操作
        threadLocalCopyUtil.asyncTask(()->{
            CURRENT_USER.set(user);
            // 兼容系统域调用的时候不会带上租户id的问题
            final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();;
            TenantContextHolder.setCurrentTenant(sysTenantDTO);
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            try {
                // 更新核销金额
                //addVerAmt(applyList.stream().map(BaseModel::getId).collect(Collectors.toList()));
            }catch (Exception e){
                log.error("更新核销金额,推送nc失败,{}",e.getMessage());
                applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e->{
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
                //e.setErpLog(finalErpLog);
            });
            // 更新单据信息
            finApPayVerApplyRepoProc.save(applyList);
            //日志
            applyList.forEach(apply->{
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_OK,
                        BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
            // 用完清除
            CURRENT_USER.remove();

        });

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void writeOffApprove(FinApPayApplyApprovalDTO dto) {
       /* if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }
*/
        List<FinApPayVerApplyDO> applyList = finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);

        // 更新单据信息
        finApPayVerApplyRepoProc.save(applyList);


        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO!=null?sysUserDTO.getLastName():principal.getUsername();
        // 更新核销金额，改为异步操作
       /* threadLocalCopyUtil.asyncTask(()->{
            CURRENT_USER.set(user);*/

            // 兼容系统域调用的时候不会带上租户id的问题
            final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            try {
                updateAmount(applyList.stream().map(BaseModel::getId).collect(Collectors.toList()), FinArRecVerificationDTO.VerType.APPROVE);
            }catch (Exception e){
                log.error("更新核销金额失败",e);
                applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e->{
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
                //e.setErpLog(finalErpLog);
            });
            // 更新单据信息
            finApPayVerApplyRepoProc.save(applyList);
            applyList.forEach(apply -> {
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_OK,
                        BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
         /*   // 用完清除
            CURRENT_USER.remove();

        });*/

    }

    /**
     * 重推核销审批接口
     * @param id
     * @return
     */

    public ApiResult<String> reTryApprove(Long id){
        FinApPayVerApplyDO applyDO = finApPayVerApplyRepoProc.get(id);
        // 兼容系统域调用的时候不会带上租户id的问题
        final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();;
        TenantContextHolder.setCurrentTenant(sysTenantDTO);
        String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
        String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
        String erpLog = "";
        Boolean isSuccess = Boolean.TRUE;
        try {
            //updateAmount(CollUtil.newArrayList(applyDO.getId()), FinArRecVerificationDTO.VerType.APPROVE);
        }catch (Exception e){
            log.error("更新核销金额,推送nc失败,{}",e.getMessage());
            applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
            verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
            erpLog = e.getMessage();
            isSuccess = Boolean.FALSE;
        }
        String finalApplyState = applyState;
        String finalVerState = verState;
        String finalErpLog = erpLog;
        applyDO.setState(finalApplyState);
        applyDO.setVerState(finalVerState);
        //applyDO.setErpLog(finalErpLog);
        // 更新单据信息
        finApPayVerApplyRepoProc.save(applyDO);
        return isSuccess?ApiResult.ok("重推核销审批成功"):ApiResult.fail(erpLog);
    }

    /**
     * 核销接口重试
     * @param param
     * @return
     */

    /*public ApiResult<String> reTrySend2Nc(ReTryParam param){
		log.info("核销接口重试,{}", JSONUtil.toJsonStr(param));
		if(ObjUtil.isNull(param)){
			return ApiResult.ok("重试参数为空");
		}
		FinArRecVerApplyDO applyDO = finArRecVerApplyRepoProc.get(param.getId());
		if(ObjectUtil.isNull(applyDO)){
			return ApiResult.ok("查询核销单为空");
		}
		ApiResult<String> result = ApiResult.ok();

		if("APPROVE".equals(param.getBusinessType())){
			result = this.reTryApprove(param.getId());
		}else {
			try {
				this.writeOffCancel(param.getId());
			}catch (Exception e){
				log.error("核销接口重试失败，{}",e.getMessage());
				result = ApiResult.fail("核销接口重试失败" + e.getMessage());
			}
		}
		return result;
	}*/
    @Transactional(rollbackFor = Exception.class)
    public void updateAmount(Collection<Long> ids, String verType) {

        // 无效处理
        BigDecimal factor = BigDecimal.ONE;

        FinApPayVerApplyVO headAndDetailInfo = queryHeadAndDetailInfo(ids);

        List<Long> arMasIds = headAndDetailInfo.getApHeadList().stream().map(FinApPayVerApplyApHeadVO::getId).collect(Collectors.toList());

        List<Long> recMasIds = headAndDetailInfo.getPayHeadList().stream().map(FinApPayVerApplyPayHeadVO::getId).collect(Collectors.toList());


        // 进行 NC接口调用
        //sendNcVerRequest(ids, verType);

        // 更新应收单核销金额
        List<FinApPayVerApplyApVO> arVOList = finApPayVerApplyApService.listByMasIds(arMasIds);
        arVOList.forEach(e -> apOrderService.updateVerAmt(e.getApDId(), e.getVerAmt().multiply(factor), verType));

        // 更新收款单核销金额
        List<FinApPayVerApplyPayVO> recVOList = finApPayVerApplyPayService.listByMasIds(recMasIds);
        recVOList.forEach(e -> payOrderService.updateVerAmt(e.getPayDId(), e.getVerAmt().multiply(factor), verType));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void refuse(FinApPayApplyApprovalDTO dto) {

        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }

        List<FinApPayVerApplyDO> applyList = finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, "未查询到核销申请单");
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);

        // 释放核销中金额
        finApPayVerApplyApService.listByMasIds(masIds)
                .forEach(e -> apOrderService.updateMiddleVerAmt(e.getApDId(), e.getVerAmt().negate()));
        finApPayVerApplyPayService.listByMasIds(masIds)
                .forEach(e -> payOrderService.updateMiddleVerAmt(e.getPayDId(), e.getVerAmt().negate()));
        // 更新单据信息
        finApPayVerApplyRepoProc.save(applyList);
        applyList.forEach(apply->{
            operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT,
                BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT));
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void writeOffRefuse(FinApPayApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals(dto.getApprovalType())) {
            throw new BusinessException("非法的approvalType");
        }

        List<FinApPayVerApplyDO> applyList = finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, "未查询到核销申请单");
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());

        preCheckForApproval(dto.getApplyNos(), applyList);

        setApprovalMsg(dto, applyList);


        FinApPayVerApplyVO headAndDetailInfo = queryHeadAndDetailInfo(masIds);

        List<Long> arMasIds = headAndDetailInfo.getApHeadList().stream().map(FinApPayVerApplyApHeadVO::getId).collect(Collectors.toList());

        List<Long> recMasIds = headAndDetailInfo.getPayHeadList().stream().map(FinApPayVerApplyPayHeadVO::getId).collect(Collectors.toList());

        // 更新应收单核销金额
        finApPayVerApplyApService.listByMasIds(arMasIds).forEach(e -> apOrderService.updateMiddleVerAmt(e.getApDId(), e.getVerAmt().negate()));
        finApPayVerApplyPayService.listByMasIds(recMasIds).forEach(e -> payOrderService.updateMiddleVerAmt(e.getPayDId(), e.getVerAmt().negate()));

        // 更新单据信息
        finApPayVerApplyRepoProc.save(applyList);
        //日志
        applyList.forEach(apply->{
            operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT,
                BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT));
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancel(Long id) {

        FinApPayVerApplyDO entity = findApplyOrder(id);

        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(), WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());

        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("仅核销状态为已核销或者取消失败的单据可进行该操作!");
        }

        // 更新单据状态
        updateOrderForVerCancel(entity);

        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();

        String user = principal.getUsername();

        // 释放核销金额,更改为异步
        ThreadUtil.execute(()-> {
            CURRENT_USER.set(user);
            log.info("取消核销异步执行");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String erpLog = "";
            try {
                final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();;
                TenantContextHolder.setCurrentTenant(sysTenantDTO);
                // 释放核销金额
                //releaseVerAmt(Collections.singleton(id));
            }catch (Exception e){
                log.error("取消核销,推送nc失败,{}",e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
            //entity.setErpLog(erpLog);
            log.info("取消核销更新状态,{}",JSONUtil.toJsonStr(entity));
            // 更新单据信息
            finApPayVerApplyRepoProc.save(entity);
            CURRENT_USER.remove();
        });

        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.UPDATE,
            "取消核销");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void writeOffCancel(Long id) {

        FinApPayVerApplyDO entity = findApplyOrder(id);
        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(),
                WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());

        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("仅核销状态为已核销或者取消失败的单据可进行该操作!");
        }

        if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(entity.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()
                .equals(entity.getProposedStatus())) {
            throw new BusinessException("拟定状态必须为草稿或拟定失败");
        }


        // 更新单据状态
        updateOrderForVerCancel(entity);

        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();

        String user = principal.getUsername();

        // 释放核销金额,更改为异步
      /*  ThreadUtil.execute(()->{
            CURRENT_USER.set(user);
            log.info("取消核销异步执行");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String errlog = "";
            try {
                final SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
                TenantContextHolder.setCurrentTenant(sysTenantDTO);
                updateAmount(Collections.singleton(id), FinArRecVerificationDTO.VerType.CANCEL);
            }catch (Exception e){
                log.error("取消核销失败,{}",e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                errlog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
            entity.setErpLog(errlog);
            log.info("取消核销更新状态,{}",JSONUtil.toJsonStr(entity));
            // 更新单据信息
            finApPayVerApplyRepoProc.save(entity);
            CURRENT_USER.remove();
        });*/
        updateAmount(Collections.singleton(id), FinArRecVerificationDTO.VerType.CANCEL);
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.UPDATE,
                "取消核销");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        List<FinApPayVerApplyDO> list = finApPayVerApplyRepoProc.get(ids);
        Assert.notEmpty(list, "未查询到对应的数据信息");

        list.forEach(e -> {
            if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode().equals(e.getState())) {
                throw new BusinessException("单据无法进行删除，请核对单据状态");
            }
        });

        finApPayVerApplyRepoProc.delete(ids);
        finApPayVerApplyApService.deleteByMasId(ids);
        finApPayVerApplyPayService.deleteByMasId(ids);
    }

    @Override
    public List<FinApPayVerApplySettleVO> settleList(Long id) {
        return finApPayVerApplySettleService.listByMasIds(Collections.singletonList(id));
    }

    private void updateArMiddleVerAmt(List<FinApPayVerApplyApSaveDTO> list) {
        list.forEach(e -> apOrderService.updateMiddleVerAmt(e.getApDId(), e.getVerAmt()));
    }

    private void updateRecMiddleVerAmt(List<FinApPayVerApplyPaySaveDTO> list) {
        list.forEach(e -> payOrderService.updateMiddleVerAmt(e.getPayDId(), e.getVerAmt()));
    }

    private void updateOrderForVerCancel(FinApPayVerApplyDO entity) {
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode());
        finApPayVerApplyRepoProc.save(entity);
    }

    private static final BigDecimal ZERO = BigDecimal.ZERO;

    /*private void verifyData(FinApPayVerApplySaveDTO save) {

        List<FinApPayVerApplyApSaveDTO> arSaveList = save.getApSaveList();
        List<FinApPayVerApplyPaySaveDTO> recSaveList = save.getPaySaveList();

        // TODO 当前不考虑对冲情况
        if (arSaveList.isEmpty()) {
            throw new BusinessException("应收单核销明细不能为空!");
        }
        if (recSaveList.isEmpty()) {
            throw new BusinessException("核销单核销明细不能为空!");
        }

        save.setVerAmt(checkAndGetTotalVerAmt(arSaveList, recSaveList));

        // 查询应收单
        List<Long> arDIds = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getApDId).collect(Collectors.toList());
        List<ArOrderDtlExVo> arOrderDtlExVos = arOrderService.listArOrderDetail(FinArOrderDetailQuery.builder()
                .arDIds(arDIds)
                .build());
        if (arDIds.size() != arOrderDtlExVos.size()) {
            throw new BusinessException("请核对应收单单号");
        }
        // 校验应收单核销金额
        arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getArDId()))
                .findFirst()
                .ifPresent(ar -> {
                    if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                        throw new BusinessException("请校验应收单核销金额数据，单号:" + arSave.getArDocNo());
                    }
                    // 校验明细金额
                    if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                        throw new BusinessException("应收单核销金额大于未核销金额，单号:" + arSave.getArDocNo());
                    }
                }));

        // 查询收款单
        List<Long> recDId = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDId).collect(Collectors.toList());
        List<RecOrderDtlExVo> recOrderDtlExVos = recOrderExService.listRecOrderDetail(FinRecOrderDetailQuery.builder()
                .recDIds(recDId)
                .build());
        if (recOrderDtlExVos.size() != recDId.size()) {
            throw new BusinessException("请核对收款单单号");
        }
        // 校验收款单核销金额
        recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getRecDId()))
                .findFirst()
                .ifPresent(rec -> {
                    if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                        throw new BusinessException("请校验收款单核销金额数据，单号:" + recSave.getRecDocNo());
                    }
                    // 校验明细金额
                    if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                        throw new BusinessException("收款单核销金额大于未核销金额，单号:" + recSave.getRecDocNo());
                    }
                }));
    }*/
    private void verifyDataNew(FinApPayVerApplySaveDTO save) {
        List<FinApPayVerApplyApSaveDTO> arSaveList = save.getApSaveList();
        List<FinApPayVerApplyPaySaveDTO> recSaveList = save.getPaySaveList();
        if(CollectionUtils.isEmpty(arSaveList)&&CollectionUtils.isEmpty(recSaveList)){
            throw new BusinessException("应收单和收款单不能同时为空");
        }
        save.setVerAmt(checkAndGetTotalVerAmtNew(arSaveList, recSaveList));
        // 查询应收单
        if(CollectionUtils.isNotEmpty(arSaveList)){
            List<Long> arDIds = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getApDId).collect(Collectors.toList());
            List<ApOrderDtlVO> arOrderDtlExVos = apOrderService.listApOrderDetail(FinApOrderDetailQuery.builder()
                    .apDIds(arDIds)
                    .build());
            if (arDIds.size() != arOrderDtlExVos.size()) {
                throw new BusinessException("请核对应收单单号");
            }
            // 校验应收单核销金额
            arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getApDId()))
                    .findFirst()
                    .ifPresent(ar -> {
                        if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                            throw new BusinessException("请校验应收单核销金额数据，单号:" + arSave.getApDocNo());
                        }
                        // 校验明细金额
                        if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                            throw new BusinessException("应收单核销金额大于未核销金额，单号:" + arSave.getApDocNo());
                        }
                    }));
        }
        if(CollectionUtils.isNotEmpty(recSaveList)){
            // 查询收款单
            List<Long> recDId = recSaveList.stream().map(FinApPayVerApplyPaySaveDTO::getPayDId).collect(Collectors.toList());
            List<PayOrderDtlVO> recOrderDtlExVos = payOrderService.listPayOrderDetail(FinPayOrderDetailQuery.builder()
                    .payDIds(recDId)
                    .build());
            if (recOrderDtlExVos.size() != recDId.size()) {
                throw new BusinessException("请核对收款单单号");
            }
            // 校验收款单核销金额
            recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getPayDId()))
                    .findFirst()
                    .ifPresent(rec -> {
                        if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                            throw new BusinessException("请校验收款单核销金额数据，单号:" + recSave.getPayDocNo());
                        }
                        // 校验明细金额
                        if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                            throw new BusinessException("收款单核销金额大于未核销金额，单号:" + recSave.getPayDocNo());
                        }
                    }));
        }
    }

    /**
     * 校验应收单、收款单核销总金额是否相等，并返回核销总金额.
     *
     * @param arSaveList  应收单明细
     * @param recSaveList 收款单明细
     */

    private BigDecimal checkAndGetTotalVerAmt(List<FinApPayVerApplyApSaveDTO> arSaveList,
                                              List<FinApPayVerApplyPaySaveDTO> recSaveList) {

        BigDecimal arVerAmt = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal recVerAmt = recSaveList.stream().map(FinApPayVerApplyPaySaveDTO::getVerAmt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        if (arVerAmt.compareTo(recVerAmt) != 0) {
            throw new BusinessException("应收单收款单核销金额不相等");
        }
        return arVerAmt;
    }
    private BigDecimal checkAndGetTotalVerAmtNew(List<FinApPayVerApplyApSaveDTO> arSaveList,
                                              List<FinApPayVerApplyPaySaveDTO> recSaveList) {
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(arSaveList)){
            arSaveList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "应收单核销金额不能为空"));
            arVerAmt = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if(CollectionUtils.isNotEmpty(recSaveList)){
            recSaveList.stream().forEach(item -> Assert.notNull(item.getVerAmt(), "收款单核销金额不能为空"));
            recVerAmt = recSaveList.stream().map(FinApPayVerApplyPaySaveDTO::getVerAmt)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (arVerAmt.compareTo(recVerAmt) != 0) {
            throw new BusinessException("应收单收款单核销金额不相等");
        }
        return arVerAmt;
    }
    private void releaseVerAmt(Collection<Long> ids) {
        updateVerAmt(ids, FinArRecVerificationDTO.VerType.CANCEL);
    }

    private void addVerAmt(Collection<Long> ids) {
        updateVerAmt(ids, FinArRecVerificationDTO.VerType.APPROVE);
    }

    public void updateVerAmt(Collection<Long> ids, String verType) {
        // 进行 NC接口调用
      //  sendNcVerRequest(ids, verType);

        // 无效处理
        BigDecimal factor = BigDecimal.ONE;

        // 更新应收单核销金额
        List<FinApPayVerApplyApVO> arVOList = finApPayVerApplyApService.listByMasIds(ids);
        arVOList.forEach(e -> apOrderService.updateVerAmt(e.getApDId(), e.getVerAmt().multiply(factor), verType));

        // 更新收款单核销金额
        List<FinApPayVerApplyPayVO> recVOList = finApPayVerApplyPayService.listByMasIds(ids);
        recVOList.forEach(e -> payOrderService.updateVerAmt(e.getPayDId(), e.getVerAmt().multiply(factor), verType));

    }

    /**
     * 调用NC接口进行 通过核销/取消核销.
     *
     * @param ids     核销申请单主键
     * @param verType 操作类型
     *
     */
    /*private void sendNcVerRequest(Collection<Long> ids, String verType) {

        List<FinArRecVerApplySettleVO> settleList = finArRecVerApplySettleService.listByMasIds(ids);
        Assert.notEmpty(settleList, "明细拆分集合为空，请核对数据!");

        List<FinArRecVerificationDTO> requestParam = null;//new ArrayList<>(settleList.size());

        ids.forEach(id -> settleList.stream().filter(fi -> fi.getMasId().equals(id)).collect(Collectors.toList())
                .forEach(e -> requestParam.add(getBuilder(verType, e).build())));

        if (requestParam.isEmpty()) {
            throw new BusinessException("构建NC接口请求参数失败");
        }

        ApiResult<String> result = sendRequest(finArRecVerApplyRepoProc.get(ids).stream().map(FinArRecVerApplyDO::getApplyDocNo).distinct().collect(Collectors.joining(",")), verType, requestParam);
        if (null == result) {
            log.error("接口调用失败，请稍后再试");
            throw new BusinessException("接口调用失败，请稍后再试");
        }
        if (result.isFailed()) {
            log.error("NC核销通过/取消核销接口调用失败:{}", result.getMsg());
            throw new BusinessException("NC核销通过/取消核销接口调用失败:" + result.getMsg());
        }

        if (FinArRecVerificationDTO.VerType.APPROVE.equals(verType)) {
            String bachNo = result.getData();
            Assert.notEmpty(bachNo, "核销处理编号不能为空!");

            // 兼容红蓝对冲，返回的是list
            if (bachNo.startsWith("[{")) {
                JSONArray array = JSONUtil.parseArray(bachNo);

                array.forEach(e->{
                    NcFinResultVo ncFinResult = JSONUtil.toBean(e.toString(), NcFinResultVo.class);
                    // 成功则更新核销批次号
                    if("1".equals(ncFinResult.getFlag())){
                        if(StrUtil.isNotEmpty(ncFinResult.getRedbluevbillcode())) {
                            if (StrUtil.isNotEmpty(ncFinResult.getYsztmxid())) {
                                finArRecVerApplySettleService.updateBatchNoByArDid(ncFinResult.getYsztmxid(), ncFinResult.getRedbluevbillcode());
                            } else {
                                finArRecVerApplySettleService.updateBatchNoByRcDid(ncFinResult.getSkztmxid(), ncFinResult.getRedbluevbillcode());
                            }
                        }else {
                            finArRecVerApplySettleService.updateBatchNoByArDid(ncFinResult.getYsztmxid(), ncFinResult.getVbillcode());
                        }

                    }
                });
            }else {
                finArRecVerApplySettleService.updateBatchNo(ids, bachNo);
            }
        }else {
            finArRecVerApplySettleService.updateVerFlag(ids, "CANCEL");
        }
    }

    private FinApPayVerificationDTO.FinApPayVerificationDTOBuilder getBuilder(String verType, FinApPayVerApplySettleVO e) {
        // 查询应收收款核销申请单
        FinApPayVerApplyDO applyDO = finApPayVerApplyRepoProc.get(e.getMasId());
        Assert.notNull(applyDO, "未查询到对应的申请单信息，id:" + e.getMasId());

        FinApPayVerificationDTO.FinApPayVerificationDTOBuilder builder = FinApPayVerificationDTO.builder()
                .apOutNo(e.getOutApDocNo())
              *//*  .arCustCode(e.getApCustCode())*//*
                .apDId(e.getOutApDId())
                .apAmt(e.getApNotVerAmt())
                .payOutNo(e.getOutPayDocNo())
                .paySuppCode(e.getPaySuppCode())
                .payDId(e.getOutPayDId())
                .payAmt(e.getPayNotVerAmt())
                .verAmt(e.getVerAmt())
                .creator(applyDO.getApplyUserName())
                .verType(FinArRecVerificationDTO.VerType.CANCEL.equals(verType)?"2":"NORMA".equals(e.getVerFlag())?"1":"3");
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {
            builder.batchNo(e.getBatchNo());
        }
        return builder;
    }*/

  /*  private ApiResult<String> sendRequest(String bizKey, String verType, List<FinApPayVerificationDTO> param) {
        ApiResult<String> result;
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {
            // 如果是取消则取当前用户
            param.forEach(e -> e.setCreator(CURRENT_USER.get()));
            result = finApPayVerLocalService.cancel(bizKey, param);
        } else {
            result = finApPayVerLocalService.approve(bizKey, param);
        }
        return result;
    }*/

    private Long doUpdate(FinApPayVerApplySaveDTO save) {

        updateApplyOrder(save);

        // 删除核销单明细数据
        finApPayVerApplyApService.deleteByMasId(Collections.singleton(save.getId()));
        finApPayVerApplyPayService.deleteByMasId(Collections.singleton(save.getId()));

        // 插入核销单明细
        finApPayVerApplyApService.createBatch(save.getId(), save.getApSaveList());
        finApPayVerApplyPayService.createBatch(save.getId(), save.getPaySaveList());

        return save.getId();
    }

    @NotNull
    private FinApPayVerApplyDO findApplyOrder(Long id) {
        FinApPayVerApplyDO entity = finApPayVerApplyRepoProc.get(id);
        Assert.notNull(entity, "未查询到对应的申请单信息，id:" + id);
        return entity;
    }

    private Long doCreate(FinApPayVerApplySaveDTO save) {

        // 插入核销单数据
        long id = createApplyOrder(save);

        // 插入核销单明细
        finApPayVerApplyApService.createBatch(id, save.getApSaveList());
        finApPayVerApplyPayService.createBatch(id, save.getPaySaveList());

        return id;
    }

    private long createApplyOrder(FinApPayVerApplySaveDTO save) {
        FinApPayVerApplyDO entity = FinApPayVerApplyConvert.INSTANCE.save2Do(save);

        entity.setApplyDocNo(seqNumProvider.generateCode(com.elitesland.fin.Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
        entity.setState(save.getState() == null ? WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode() : save.getState());
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_NOT.getValueCode());
        entity.setApplyDate(LocalDateTime.now());

        entity.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());


        GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        entity.setApplyUserId(principal.getUserId());
        //entity.setApplyUserName(principal.getUsername());
        SysUserDTO user = principal.getUser();
        if(user!=null){
            entity.setApplyUserName(user.getLastName());
        }
        finApPayVerApplyRepoProc.save(entity);
        //日志
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.ADD,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.ADD));
        save.setApplyDocNo(entity.getApplyDocNo());
        return entity.getId();
    }

    private void updateApplyOrder(FinApPayVerApplySaveDTO save) {
        FinApPayVerApplyDO entity = finApPayVerApplyRepoProc.get(save.getId());
        Assert.notNull(entity, "未查询到对应的核销申请单，ID:" + save.getId());

        // 更新核销单信息
        FinApPayVerApplyConvert.INSTANCE.save2Do(save, entity);
        finApPayVerApplyRepoProc.save(entity);
        //日志
        operationLogService.simpleSendLog(BusinessObjectConstant.INTERACT_FIN_APPLY, entity.getId().toString(), OperationTypeEnum.UPDATE,
            BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.UPDATE));
    }

    private void setApprovalMsg(FinApPayApplyApprovalDTO dto, List<FinApPayVerApplyDO> applyList) {
        applyList.forEach(e -> {
            if (dto.getApprovalType() == FinApPayApplyApprovalDTO.ApprovalType.APPROVE) {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVALING.getValueCode());
//                e.setVerState(UdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());
            } else {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_REFUSE.getValueCode());
            }
            GeneralUserDetails principal = (GeneralUserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            e.setApprovalUserId(principal.getUserId());
            //e.setApprovalUserName(principal.getUsername());
            SysUserDTO user = principal.getUser();
            if(user!=null){
                e.setApprovalUserName(user.getLastName());
            }
            e.setApprovalDate(LocalDateTime.now());
            if (StringUtils.hasText(dto.getApprovalRemark())) {
                e.setApprovalRemark(dto.getApprovalRemark());
            }
        });
    }

    private void preCheckForApproval(List<String> applyNos, List<FinApPayVerApplyDO> applyList) {

        // 校验查询数据
        if (applyNos.size() > applyList.size()) {
            if (applyNos.removeAll(applyList.stream().map(FinApPayVerApplyDO::getApplyDocNo).collect(Collectors.toList()))) {
                throw new BusinessException("未查询到核销申请信息，请核对以下单号:" + applyNos);
            }
        }

        // 校验核销申请状态
        List<String> fiRes = applyList.stream()
                .filter(fi -> !WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(fi.getState()))
                .map(FinApPayVerApplyDO::getApplyDocNo)
                .collect(Collectors.toList());

        if (CollUtil.isNotEmpty(fiRes)) {
            throw new BusinessException("以下核销申请单无法进行当前操作:" + fiRes);
        }
    }

    private List<FinApPayVerApplySettleSaveDTO> settleApplyDetailList(List<FinApPayVerApplyApSaveDTO> ars, List<FinApPayVerApplyPaySaveDTO> recs) {

        List<FinApPayVerApplyApSaveDTO> arList = ars.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt))
                .collect(Collectors.toList());

        List<FinApPayVerApplyPaySaveDTO> recList = recs.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt))
                .collect(Collectors.toList());

        return doSettle(arList, recList);
    }
    private List<FinApPayVerApplySettleSaveDTO> settleApplyDetailListNew(List<FinApPayVerApplyApSaveDTO> ars, List<FinApPayVerApplyPaySaveDTO> recs) {
        List<FinApPayVerApplySettleSaveDTO> settles = new ArrayList<>();
        List<FinApPayVerApplyApSaveDTO> leftAllArlist = new ArrayList<>();
        List<FinApPayVerApplyPaySaveDTO> leftAllReclist = new ArrayList<>();
        List<FinApPayVerApplyApSaveDTO> zeroArlist = ars.stream().filter(ar->ar.getVerAmt().compareTo(BigDecimal.ZERO)==0).collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> zeroReclist = recs.stream().filter(rec->rec.getVerAmt().compareTo(BigDecimal.ZERO)==0).collect(Collectors.toList());
        //1.应收单是否有正负数核销金额
        List<FinApPayVerApplyApSaveDTO> arListPositive  = ars.stream().filter(ar->ar.getVerAmt().compareTo(BigDecimal.ZERO)>0).collect(Collectors.toList());
        List<FinApPayVerApplyApSaveDTO> arListNegative  = ars.stream().filter(ar->ar.getVerAmt().compareTo(BigDecimal.ZERO)<0).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(arListPositive)&&CollectionUtils.isNotEmpty(arListNegative)){
            List<FinApPayVerApplyApSaveDTO> leftArlist = doSettleForApOffset(arListPositive, arListNegative, settles);
            if(CollectionUtils.isNotEmpty(leftArlist)){
                leftAllArlist.addAll(leftArlist);
            }
        }else{
            if(CollectionUtils.isNotEmpty(arListPositive)){
                leftAllArlist.addAll(arListPositive);
            }
            if(CollectionUtils.isNotEmpty(arListNegative)){
                leftAllArlist.addAll(arListNegative);
            }
        }
        //2.收款单是否有正负数核销金额
        List<FinApPayVerApplyPaySaveDTO> recListPositive  = recs.stream().filter(rec->rec.getVerAmt().compareTo(BigDecimal.ZERO)>0).collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> recListNegative  = recs.stream().filter(rec->rec.getVerAmt().compareTo(BigDecimal.ZERO)<0).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(recListPositive)&&CollectionUtils.isNotEmpty(recListNegative)){
            List<FinApPayVerApplyPaySaveDTO> leftReclist = doSettleForPayOffset(recListPositive, recListNegative, settles);
            if(CollectionUtils.isNotEmpty(leftReclist)){
                leftAllReclist.addAll(leftReclist);
            }
        }else{
            if(CollectionUtils.isNotEmpty(recListPositive)){
                leftAllReclist.addAll(recListPositive);
            }
            if(CollectionUtils.isNotEmpty(recListNegative)){
                leftAllReclist.addAll(recListNegative);
            }
        }
        //一方为0，则说明另一方也为0，所以不用再进一步核销了
        if(CollectionUtils.isEmpty(leftAllArlist)||CollectionUtils.isEmpty(leftAllReclist)){
            return settles;
        }
        List<FinApPayVerApplyApSaveDTO> arList = leftAllArlist.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> recList = leftAllReclist.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt))
                .collect(Collectors.toList());
        settles.addAll(doSettleNew(arList,recList));
        return settles;
    }
    private List<FinApPayVerApplyApSaveDTO> doSettleForApOffset(List<FinApPayVerApplyApSaveDTO> arListPositive, List<FinApPayVerApplyApSaveDTO> arListNegative,List<FinApPayVerApplySettleSaveDTO> settles) {
           //设置原始核销金额
        arListPositive.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
        arListNegative.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
            //正数从小到大排序
        List<FinApPayVerApplyApSaveDTO> arListPositiveSorted = arListPositive.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        //负数从大到小排序
        List<FinApPayVerApplyApSaveDTO> arListNegativeSorted = arListNegative.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt))
                .collect(Collectors.toList());
        Collections.reverse(arListNegativeSorted);
        List<FinApPayVerApplyApSaveDTO> arListPositiveRm = new ArrayList<>();
        List<FinApPayVerApplyApSaveDTO> arListNegativeRm = new ArrayList<>();
        arListNegativeSorted.stream().forEach(arn -> arListPositiveSorted.stream().forEach(arp -> {
            //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
            boolean writeOffFlag = BigDecimal.ZERO.compareTo(arn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(arp.getVerAmt()) == 0;
            //本次循环是否继续
            if (writeOffFlag) {
                return;
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(buildSettleForApOffset(arp,null));
                arn.setVerAmt(arn.getVerAmt().add(arp.getVerAmt()));
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(buildSettleForApOffset(arn,null));
                settles.add(buildSettleForApOffset(arp,null));
                arn.setVerAmt(BigDecimal.ZERO);
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
                arListNegativeRm.add(arn);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(buildSettleForApOffset(arn,null));
                arp.setVerAmt(arp.getVerAmt().add(arn.getVerAmt()));
                arn.setVerAmt(BigDecimal.ZERO);
                arListNegativeRm.add(arn);
            }
        }));
        arListPositive.removeAll(arListPositiveRm);
        arListNegative.removeAll(arListNegativeRm);
        if(CollectionUtils.isNotEmpty(arListPositive)){
            Optional<FinApPayVerApplyApSaveDTO> first = arListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForApOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListPositive;
        }
        if(CollectionUtils.isNotEmpty(arListNegative)){
            Optional<FinApPayVerApplyApSaveDTO> first = arListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForApOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListNegative;
        }
        return null;
    }
    private List<FinApPayVerApplyPaySaveDTO> doSettleForPayOffset(List<FinApPayVerApplyPaySaveDTO> recListPositive, List<FinApPayVerApplyPaySaveDTO> recListNegative,List<FinApPayVerApplySettleSaveDTO> settles) {
        //设置原始核销金额
        recListPositive.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
        recListNegative.forEach(v->v.setOrigVerAmt(v.getVerAmt()));
        //正数从小到大排序
        List<FinApPayVerApplyPaySaveDTO> recListPositiveSorted = recListPositive.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt))
                .collect(Collectors.toList());
        //负数从大到小排序
        List<FinApPayVerApplyPaySaveDTO> recListNegativeSorted = recListNegative.stream()
                .sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt))
                .collect(Collectors.toList());
        Collections.reverse(recListNegativeSorted);
        List<FinApPayVerApplyPaySaveDTO> recListPositiveRm = new ArrayList<>();
        List<FinApPayVerApplyPaySaveDTO> recListNegativeRm = new ArrayList<>();
        recListNegativeSorted.stream().forEach(recn -> recListPositiveSorted.stream().forEach(recp -> {
            //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
            boolean writeOffFlag = BigDecimal.ZERO.compareTo(recn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(recp.getVerAmt()) == 0;
            //本次循环是否继续
            if (writeOffFlag) {
                return;
            }
            if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(buildSettleForPayOffset(recp,null));
                recn.setVerAmt(recn.getVerAmt().add(recp.getVerAmt()));
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
            }else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(buildSettleForPayOffset(recn,null));
                settles.add(buildSettleForPayOffset(recp,null));
                recn.setVerAmt(BigDecimal.ZERO);
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
                recListNegativeRm.add(recn);
            }else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(buildSettleForPayOffset(recn,null));
                recp.setVerAmt(recp.getVerAmt().add(recn.getVerAmt()));
                recn.setVerAmt(BigDecimal.ZERO);
                recListNegativeRm.add(recn);
            }
        }));
        recListPositive.removeAll(recListPositiveRm);
        recListNegative.removeAll(recListNegativeRm);
        if(CollectionUtils.isNotEmpty(recListPositive)){
            Optional<FinApPayVerApplyPaySaveDTO> first = recListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForPayOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListPositive;
        }
        if(CollectionUtils.isNotEmpty(recListNegative)){
            Optional<FinApPayVerApplyPaySaveDTO> first = recListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if(first.isPresent()){
                settles.add(buildSettleForPayOffset(first.get(),first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListNegative;
        }
        return null;
    }
    private List<FinApPayVerApplySettleSaveDTO> doSettle(List<FinApPayVerApplyApSaveDTO> arList, List<FinApPayVerApplyPaySaveDTO> recList) {
        List<FinApPayVerApplySettleSaveDTO> settles = new ArrayList<>();

        arList.stream().forEach(ar -> recList.stream().forEach(rec -> {

            //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
            boolean writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) &&
                    settles.size() != 0;

            //核销金额为0
            if (writeOffFlag) {
                return;
            }
            if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
            } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
                rec.setVerAmt(BigDecimal.ZERO);
            }else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                settles.add(buildSettle(ar, rec, rec.getVerAmt()));
                ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                rec.setVerAmt(BigDecimal.ZERO);
            }
        }));
        return settles;
    }
    private List<FinApPayVerApplySettleSaveDTO> doSettleNew(List<FinApPayVerApplyApSaveDTO> arList, List<FinApPayVerApplyPaySaveDTO> recList) {
        //确定正向、负向，通过对冲之后，只有一种情况，要么是正要么是负
        final boolean isPositive=arList.get(0).getVerAmt().compareTo(BigDecimal.ZERO)>0;
        List<FinApPayVerApplySettleSaveDTO> settles = new ArrayList<>();
        if(isPositive){
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
                boolean writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) &&
                        settles.size() != 0;
                //核销金额为0
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                }else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(buildSettle(ar, rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                }
            }));
        }else{
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                //明细核销和整单核销共用一个逻辑,核销金额为0并且已经计算过
                boolean writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) &&
                        settles.size() != 0;
                //核销金额为0
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(buildSettle(ar, rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                }else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(buildSettle(ar, rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                }
            }));
        }
        return settles;
    }
    private FinApPayVerApplySettleSaveDTO buildSettle(FinApPayVerApplyApSaveDTO ap, FinApPayVerApplyPaySaveDTO pay, BigDecimal verAmt) {
        FinApPayVerApplySettleSaveDTO settle = new FinApPayVerApplySettleSaveDTO();
        settle.setApId(ap.getApId());
        settle.setApDocNo(ap.getApDocNo());
        settle.setOutApDocNo(ap.getOutApDocNo());
        settle.setApDId(ap.getApDId());
        settle.setOutApDId(ap.getOutApDId());

        settle.setPayId(pay.getPayId());
        settle.setPayDocNo(pay.getPayDocNo());
        settle.setOutPayDocNo(pay.getOutPayDocNo());
        settle.setPayDId(pay.getPayDId());
        settle.setOutPayDId(pay.getOutPayDId());

        settle.setApCustCode(ap.getCustCode());
        settle.setPayCustCode(pay.getCustCode());
        settle.setApNotVerAmt(ap.getNotVerAmt());
        settle.setPayNotVerAmt(pay.getNotVerAmt());
        settle.setVerAmt(verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_NORMAL.getValueCode());
        return settle;
    }
    private FinApPayVerApplySettleSaveDTO buildSettleForApOffset(FinApPayVerApplyApSaveDTO apOffset,BigDecimal verAmt) {
        FinApPayVerApplySettleSaveDTO settle = new FinApPayVerApplySettleSaveDTO();
        settle.setApId(apOffset.getApId());
        settle.setApDocNo(apOffset.getApDocNo());
        settle.setOutApDocNo(apOffset.getOutApDocNo());
        settle.setApDId(apOffset.getApDId());
        settle.setOutApDId(apOffset.getOutApDId());

/*        settle.setRecId(rec.getRecId());
        settle.setRecDocNo(rec.getRecDocNo());
        settle.setOutRecDocNo(rec.getOutRecDocNo());
        settle.setRecDId(rec.getRecDId());
        settle.setOutRecDId(rec.getOutRecDId());*/

        settle.setApCustCode(apOffset.getCustCode());
        //settle.setRecCustCode(rec.getCustCode());
        settle.setApNotVerAmt(apOffset.getNotVerAmt());
        //settle.setRecNotVerAmt(rec.getNotVerAmt());
        settle.setVerAmt(verAmt==null?apOffset.getOrigVerAmt():verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }
    private FinApPayVerApplySettleSaveDTO buildSettleForPayOffset(FinApPayVerApplyPaySaveDTO payOffset, BigDecimal verAmt) {
        FinApPayVerApplySettleSaveDTO settle = new FinApPayVerApplySettleSaveDTO();
      /*  settle.setArId(arOffset.getArId());
        settle.setArDocNo(arOffset.getArDocNo());
        settle.setOutArDocNo(arOffset.getOutArDocNo());
        settle.setArDId(arOffset.getArDId());
        settle.setOutArDId(arOffset.getOutArDId());*/

        settle.setPayId(payOffset.getPayId());
        settle.setPayDocNo(payOffset.getPayDocNo());
        settle.setOutPayDocNo(payOffset.getOutPayDocNo());
        settle.setPayDId(payOffset.getPayDId());
        settle.setOutPayDId(payOffset.getOutPayDId());

        //settle.setArCustCode(arOffset.getCustCode());
        settle.setPayCustCode(payOffset.getCustCode());
        //settle.setArNotVerAmt(arOffset.getNotVerAmt());
        settle.setPayNotVerAmt(payOffset.getNotVerAmt());
        settle.setVerAmt(verAmt==null?payOffset.getOrigVerAmt():verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }
    @Override
    public Long autoWriteoff(List<WriteoffVO> writeoffVOS,Long schemeId){
        if(CollectionUtils.isEmpty(writeoffVOS)){
            return null;
        }
        FinApPayVerApplySaveDTO finApPayVerApplySaveDTO = new FinApPayVerApplySaveDTO();
        List<FinApPayVerApplyApHeadSaveDTO> apHeadSaveDTOS = new ArrayList<>();
        List<FinApPayVerApplyPayHeadSaveDTO> payHeadSaveDTOS = new ArrayList<>();
        finApPayVerApplySaveDTO.setApHeadSaveList(apHeadSaveDTOS);
        finApPayVerApplySaveDTO.setPayHeadSaveList(payHeadSaveDTOS);
        for (WriteoffVO writeoffVO : writeoffVOS) {
            if(writeoffVO instanceof ApOrderVO){
                ApOrderVO apOrderVO = (ApOrderVO) writeoffVO;
                FinApPayVerApplyApHeadSaveDTO finApPayVerApplyApHeadSaveDTO = ApOrderConvert.INSTANCE.convert2FinApPayVerApplyApHeadSaveDTO(apOrderVO);
                apHeadSaveDTOS.add(finApPayVerApplyApHeadSaveDTO);
            }else if(writeoffVO instanceof PayOrderVO){
                PayOrderVO payOrderVO=(PayOrderVO)writeoffVO;
                final FinApPayVerApplyPayHeadSaveDTO finApPayVerApplyPayHeadSaveDTO = PayOrderConvert.INSTANCE.convert2FinApPayVerApplyPayHeadSaveDTO(payOrderVO);
                payHeadSaveDTOS.add(finApPayVerApplyPayHeadSaveDTO);
            }
        }
        finApPayVerApplySaveDTO.setHeadFlag(true);
        finApPayVerApplySaveDTO.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode());
        finApPayVerApplySaveDTO.setSchemeId(schemeId);
        final Long id = this.writeOffSubmit(finApPayVerApplySaveDTO);
        return id;
    }
    @Override
    public void autoWriteoffAp(ApOrderDTO apOrderDTO) {
        log.info("自动核销应付单,--------开始");
        final Long apId= apOrderDTO.getId();
        if(apId==null){
            log.error("自动核销应付单,单据ID为空");
            throw new BusinessException("自动核销应付单,单据ID为空");
        }
        //1.根据ID查找应收单即明细信息
        final ApOrderDTO apOrderDTO1 = apOrderDomainService.get(apId);
        if(apOrderDTO1==null){
            log.error("自动核销应付单，查询应付单失败，单据ID：{}",apId);
            //throw new BusinessException(String.format("自动核销应付单，查询应付单失败，单据ID：%s",apId));
            return ;
        }
        if(BigDecimal.ZERO.equals(apOrderDTO1.getTotalAmt())){
            log.info("自动核销应付单，待核销金额0,无需核销，单据ID：{}",apId);
            return ;
        }
        ApOrderVO currApOrderVO = ApOrderConvert.INSTANCE.convert(apOrderDTO1);
        boolean positiveAmtFlag=apOrderDTO1.getTotalAmt().compareTo(BigDecimal.ZERO)>0;
        //2.查询核销方案列表
        final ApVerConfigDTO apVerConfigDTO = apVerConfigDomainService.queryDef();
        if(apVerConfigDTO==null){
            log.error("自动核销应付单，未查询到核销方案，单据编码：{}",apOrderDTO1.getApOrderNo());
            //throw new BusinessException(String.format("自动核销应付单，未查询到核销方案，单据编码：%s",apOrderDTO1.getApOrderNo()));
            return ;
        }
        Long schemeId = apVerConfigDTO.getId();
        final List<ApVerConfigDtlDTO> arVerConfigDtlDTOS = apVerConfigDtlRepoProc.queryByMasId(apVerConfigDTO.getId());
        if(CollectionUtils.isEmpty(arVerConfigDtlDTOS)){
            log.error("自动核销应付单，未查询到核销方案明细，单据编码：{}",apOrderDTO1.getApOrderNo());
            //throw new BusinessException(String.format("自动核销应付单，未查询到核销方案明细，单据编码：%s",apOrderDTO1.getApOrderNo()));
            return ;
        }
        //3.过滤出默认、且启用的
        //4.遍历查找field_no是so_doc_no的核销方案列表，找到即结束，为找到则记录报错日志，结束流程
        final Boolean redOffsetFlag = apVerConfigDTO.getRedOffsetFlag();
        final String writeoffOrder = apVerConfigDTO.getWriteoffOrder();
        String ou_code=null;
        Long ou_id=null;
        String supp_code=null;
        Long supp_id=null;
        String curr_code=null;
        String so_doc_no=null;
        for (ApVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if("ou_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                ou_code = apOrderDTO1.getOuCode();
                ou_id = apOrderDTO1.getOuId();
            }else if("supp_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                supp_id = apOrderDTO1.getSuppId();
                supp_code = apOrderDTO1.getSuppCode();
            }else if("curr_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                curr_code = apOrderDTO1.getCurrCode();
            }else if("do_doc_no".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                so_doc_no = apOrderDTO1.getSourceNo();
            }
        }
        //5.找出当前核销方案公司、客户、币种、来源单号的匹配标识
        //6.根据上步找到的匹配标识，和当前应收单信息，确定过滤参数值
        //7.查看红蓝对冲标识，若是红蓝对冲匹配，增加查询其他应收单
        //8.根据6,7参数值联合查询待核销应收单和收款单列表，并按核销方案排序标识进行排序，分页查询，按整单处理
        //如果支持红蓝对冲，查询应付单
        boolean asc=true;
        if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)){
            asc=true;
        }else if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)){
            asc=false;
        }
        final boolean finAsc=asc;
        List<OrderItem> orders = new ArrayList<>();
        OrderItem orderItem=new OrderItem();
        orderItem.setColumn("buDate");
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ApOrderVO> apOrderVOPagingVO=null;
        if(redOffsetFlag){
            ApOrderPageParam apOrderPageParam = new ApOrderPageParam();
            apOrderPageParam.setOuCode(ou_code);
            apOrderPageParam.setSuppCode(supp_code);
            apOrderPageParam.setCurrCode(curr_code);
            apOrderPageParam.setOrders(orders);
            apOrderPageParam.setSize(Integer.MAX_VALUE);
            if(positiveAmtFlag){
                apOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
            }else{
                apOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
            }
            apOrderVOPagingVO = apOrderService.writeoffPage(apOrderPageParam);
        }
        //查询收款款单
        PayOrderPageParam payOrderPageParam = new PayOrderPageParam();
        payOrderPageParam.setOuId(ou_id);
        payOrderPageParam.setSuppId(supp_id);
        payOrderPageParam.setCurrCode(curr_code);
        orderItem.setColumn("buDate");
        payOrderPageParam.setOrders(orders);
        payOrderPageParam.setSize(Integer.MAX_VALUE);
        if(positiveAmtFlag){
            payOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
        }else{
            payOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
        }
        final PagingVO<PayOrderVO> payOrderVOPagingVO = payOrderService.writeoffPage(payOrderPageParam);
        //一起排序
        List<WriteoffVO> allList = new ArrayList();
        List<ApOrderVO> apOrderVOS=null;
        if(apOrderVOPagingVO!=null&&CollectionUtils.isNotEmpty(apOrderVOPagingVO.getRecords())){
            apOrderVOS=apOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(apId)).collect(Collectors.toList());
            allList.addAll(apOrderVOS);
        }
        if(payOrderVOPagingVO!=null&&CollectionUtils.isNotEmpty(payOrderVOPagingVO.getRecords())){
            allList.addAll(payOrderVOPagingVO.getRecords());
        }
        if(CollectionUtils.isEmpty(allList)){
            log.error("自动核销应付单，未匹配到待核销单据，单据编码：{}",apOrderDTO1.getApOrderNo());
            //throw new BusinessException(String.format("自动核销应付单，未匹配到待核销单据，单据编码：%s",apOrderDTO1.getApOrderNo()));
            return ;
        }
        //联合排序
        CollUtil.sort(allList,(o1,o2)->{
            if(finAsc){
                return o1.getBuDate().compareTo(o2.getBuDate());
            }else{
                return o2.getBuDate().compareTo(o1.getBuDate());
            }
        });
        BigDecimal unVerAmtBalance= apOrderDTO1.getTotalAmt();
        List<WriteoffVO> matchList=new ArrayList<>();
        //主单匹配
       /* for (WriteoffVO writeoffVO : allList) {
            if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance)){
                writeoffVO.setVerAmt(unVerAmtBalance);
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                break;
            }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance)<0){
                writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getUnVerAmt());
            }else{
                writeoffVO.setVerAmt(unVerAmtBalance);
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                break;
            }
        }*/
        if(positiveAmtFlag){
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof ApOrderVO){
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }else{
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof ApOrderVO){
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }
        if(unVerAmtBalance.compareTo(BigDecimal.ZERO)!=0){
            log.info("自动核销应付单，未匹配到足够的核销金额，单据编码：{}",apOrderDTO1.getApOrderNo());
            //throw new BusinessException(String.format("自动核销应付单，未匹配到足够的核销金额，单据编码：%s",apOrderDTO1.getApOrderNo()));
            return ;
        }
        currApOrderVO.setVerAmt(currApOrderVO.getTotalAmt());
        matchList.add(currApOrderVO);
        //生成核销数据
        this.autoWriteoff(matchList,schemeId);
        log.info("自动核销应付单,--------结始");
    }
    @Override
    public void autoWriteoffPay(PayOrderDTO payOrderDTO) {
        log.info("自动核销付款单,id:{}--------开始",payOrderDTO.getId());
        final Long payId= payOrderDTO.getId();
        if(payId==null){
            log.error("自动核销付款单,单据ID为空");
            throw new BusinessException("自动核销付款单,单据ID为空");
        }
        //1.根据ID查找应收单即明细信息
        final PayOrderDTO payOrderDTO1 = payOrderDomainService.queryById(payId, false);
        if(payOrderDTO1==null){
            log.error("自动核销付款单，查询应付单失败，单据ID：{}",payId);
            //throw new BusinessException(String.format("自动核销付款单，查询应付单失败，单据ID：%s",payId));
            return ;
        }
        if(BigDecimal.ZERO.equals(payOrderDTO1.getTotalAmt())){
            log.info("自动核销付款单，待核销金额为0，无需核销，单据ID：{}",payId);
            return ;
        }
        PayOrderVO currPayOrderVO=PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO1);
        boolean positiveAmtFlag=payOrderDTO1.getTotalAmt().compareTo(BigDecimal.ZERO)>0;
        //2.查询核销方案列表
        final ApVerConfigDTO apVerConfigDTO = apVerConfigDomainService.queryDef();
        if(apVerConfigDTO==null){
            log.error("自动核销付款单，未查询到核销方案，单据编码：{}",payOrderDTO1.getPayOrderNo());
            //throw new BusinessException(String.format("自动核销付款单，未查询到核销方案，单据编码：%s",payOrderDTO1.getPayOrderNo()));
            return ;
        }
        Long schemeId = apVerConfigDTO.getId();
        final List<ApVerConfigDtlDTO> arVerConfigDtlDTOS = apVerConfigDtlRepoProc.queryByMasId(apVerConfigDTO.getId());
        if(CollectionUtils.isEmpty(arVerConfigDtlDTOS)){
            log.error("自动核销付款单，未查询到核销方案明细，单据编码：{}",payOrderDTO1.getPayOrderNo());
            //throw new BusinessException(String.format("自动核销付款单，未查询到核销方案明细，单据编码：%s",payOrderDTO1.getPayOrderNo()));
            return ;
        }
        //3.过滤出默认、且启用的
        //4.遍历查找field_no是so_doc_no的核销方案列表，找到即结束，为找到则记录报错日志，结束流程
        final Boolean redOffsetFlag = apVerConfigDTO.getRedOffsetFlag();
        final String writeoffOrder = apVerConfigDTO.getWriteoffOrder();
        String ou_code=null;
        Long ou_id=null;
        String supp_code=null;
        Long supp_id=null;
        String curr_code=null;
        String so_doc_no=null;
        for (ApVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if("ou_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                ou_code = payOrderDTO1.getOuCode();
                ou_id = payOrderDTO1.getOuId();
            }else if("supp_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                supp_id = payOrderDTO1.getSuppId();
                supp_code = payOrderDTO1.getSuppCode();
            }else if("curr_code".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                curr_code = payOrderDTO1.getCurrCode();
            }else if("do_doc_no".equals(arVerConfigDtlDTO.getFieldNo())&&arVerConfigDtlDTO.getMatchFlag()){
                so_doc_no = payOrderDTO1.getSourceNo();
            }
        }
        log.info("自动核销付款单,匹配参数,ou_id:{},ou_code{},supp_id:{},supp_code{},curr_code:{}", ou_id,ou_code,supp_id,supp_code,curr_code);
        //5.找出当前核销方案公司、客户、币种、来源单号的匹配标识
        //6.根据上步找到的匹配标识，和当前应收单信息，确定过滤参数值
        //7.查看红蓝对冲标识，若是红蓝对冲匹配，增加查询其他应收单
        //8.根据6,7参数值联合查询待核销应收单和收款单列表，并按核销方案排序标识进行排序，分页查询，按整单处理
        //如果支持红蓝对冲，查询应付单
        boolean asc=true;
        if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)){
            asc=true;
        }else if(WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)){
            asc=false;
        }
        final boolean finAsc=asc;
        List<OrderItem> orders = new ArrayList<>();
        OrderItem orderItem=new OrderItem();
        orderItem.setColumn("buDate");
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ApOrderVO> apOrderVOPagingVO=null;
        PagingVO<PayOrderVO> payOrderVOPagingVO=null;
        if(redOffsetFlag){
            //查询收款款单
            PayOrderPageParam payOrderPageParam = new PayOrderPageParam();
            payOrderPageParam.setOuId(ou_id);
            payOrderPageParam.setSuppId(supp_id);
            payOrderPageParam.setCurrCode(curr_code);
            orderItem.setColumn("buDate");
            payOrderPageParam.setOrders(orders);
            payOrderPageParam.setSize(Integer.MAX_VALUE);
            if(positiveAmtFlag){
                payOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
            }else{
                payOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
            }
            payOrderVOPagingVO = payOrderService.writeoffPage(payOrderPageParam);
        }
        ApOrderPageParam apOrderPageParam = new ApOrderPageParam();
        //apOrderPageParam.setOuCode(ou_code);
        apOrderPageParam.setOuId(ou_id);
        //apOrderPageParam.setSuppCode(supp_code);
        apOrderPageParam.setSuppId(supp_id);
        apOrderPageParam.setCurrCode(curr_code);
        apOrderPageParam.setOrders(orders);
        apOrderPageParam.setSize(Integer.MAX_VALUE);
        if(positiveAmtFlag){
            apOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_GT);
        }else{
            apOrderPageParam.setWriteOfFAmtCon(FinConstant.WRITE_OFF_AMT_CON_LT);
        }
        apOrderVOPagingVO = apOrderService.writeoffPage(apOrderPageParam);
        //一起排序
        List<WriteoffVO> allList = new ArrayList();
        List<PayOrderVO> payOrderVOS=null;
        if(payOrderVOPagingVO!=null&&CollectionUtils.isNotEmpty(payOrderVOPagingVO.getRecords())){
            payOrderVOS=payOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(payId)).collect(Collectors.toList());
            allList.addAll(payOrderVOS);
        }
        if(apOrderVOPagingVO!=null&&CollectionUtils.isNotEmpty(apOrderVOPagingVO.getRecords())){
            allList.addAll(apOrderVOPagingVO.getRecords());
        }
        if(CollectionUtils.isEmpty(allList)){
            log.error("自动核销付款单，未匹配到待核销单据，单据编码：{}",payOrderDTO1.getPayOrderNo());
            //throw new BusinessException(String.format("自动核销付款单，未匹配到待核销单据，单据编码：%s",payOrderDTO1.getPayOrderNo()));
            return ;
        }
        //联合排序
        CollUtil.sort(allList,(o1,o2)->{
            if(finAsc){
                return o1.getBuDate().compareTo(o2.getBuDate());
            }else{
                return o2.getBuDate().compareTo(o1.getBuDate());
            }
        });
        BigDecimal unVerAmtBalance= payOrderDTO1.getTotalAmt();
        List<WriteoffVO> matchList=new ArrayList<>();
        //主单匹配
       /* for (WriteoffVO writeoffVO : allList) {
            if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance)){
                writeoffVO.setVerAmt(unVerAmtBalance);
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                break;
            }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance)<0){
                writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
            }else{
                writeoffVO.setVerAmt(unVerAmtBalance);
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                break;
            }
        }*/
        if(positiveAmtFlag){
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof PayOrderVO){
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance)){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance)<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }else{
            for (WriteoffVO writeoffVO : allList) {
                if(writeoffVO instanceof PayOrderVO){
                    if(writeoffVO.getUnVerAmt().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }else if(writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                        break;
                    }
                }else{
                    if(writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance.abs())){
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }else if(writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance.abs())<0){
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                    }else{
                        writeoffVO.setVerAmt(unVerAmtBalance);
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        break;
                    }
                }
            }
        }
        if(unVerAmtBalance.compareTo(BigDecimal.ZERO)!=0){
            log.info("自动核销付款单，未匹配到足够的核销金额，单据编码：{}",payOrderDTO1.getPayOrderNo());
            //throw new BusinessException(String.format("自动核销付款单，未匹配到足够的核销金额，单据编码：%s",payOrderDTO1.getPayOrderNo()));
            return ;
        }
        currPayOrderVO.setVerAmt(currPayOrderVO.getTotalAmt());
        matchList.add(currPayOrderVO);
        //生成核销数据
        this.autoWriteoff(matchList,schemeId);
        log.info("自动核销付款单,-------结束");
    }
}
