package com.elitesland.fin.domain.entity.recorder;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 收款单主表扩展表
 * @author lucan.liu
 * @date 2023/9/8
 */
@Data
@Entity
@Table(name = "rec_order_ext")
@DynamicInsert
@DynamicUpdate
@Comment("收款单主表扩展表")
public class RecOrderExDo extends BaseModel implements Serializable {
    private static final long serialVersionUID = 5577704836331720581L;

    @ApiModelProperty("收款单主表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '收款单主表关联id'")
    private Long relateId;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("红冲标志")
    @Column(name = "red_flush_sign", columnDefinition = "tinyint(1)  comment '红冲标志'")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    @Column(name = "third_payment_assistance", columnDefinition = "varchar(32)  comment '第三方支付辅助'")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    @Column(name = "consumer_card_ssistance", columnDefinition = "varchar(32)  comment '消费卡辅助'")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    @Column(name = "credit_card_assistance", columnDefinition = "varchar(32)  comment '信用卡辅助'")
    private String creditCardAssistance;

    @ApiModelProperty("结算方式")
    @Column(name = "pay_type", columnDefinition = "varchar(32)  comment '结算方式'")
    private String payType;

    @ApiModelProperty("收款银行账户")
    @Column(name = "rec_bank", columnDefinition = "varchar(32)  comment '收款银行账户'")
    private String recBank;

    @ApiModelProperty("付款银行账户")
    @Column(name = "pay_bank", columnDefinition = "varchar(32)  comment '付款银行账户'")
    private String payBank;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "apply_ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmting;


}
