package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;
/**
 * 功能说明 实体类:应付付款核销申请单明细-应付单
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ap_pay_ver_apply_ap")
@DynamicInsert
@DynamicUpdate
@Comment("应付付款核销申请单明细-应付单")
@Getter
@Setter
@Accessors(chain = true)
public class FinApPayVerApplyApDO   extends BaseModel {
private static final long serialVersionUID =8319759660502664699L;

	/**
	 * 主表ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "mas_id", nullable = true)
	private Long masId;

	/**
	 * 外部应付单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部应付单ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "out_ap_id", nullable = true)
	private Long outApId;

	/**
	 * 应付单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_id", nullable = true)
	private Long apId;

	/**
	 * 应付单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单号")
	@Column(name = "ap_doc_no", nullable = true, length = 64)
	private String apDocNo;

	/**
	 * 第三方应付单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "第三方应付单号")
	@Column(name = "out_ap_doc_no", nullable = true, length = 64)
	private String outApDocNo;

	/**
	 * 应付单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_d_id", nullable = true)
	private Long apDId;

	/**
	 * 外部应付单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部应付单明细ID")
	@Column(name = "out_ap_d_id", nullable = true, length = 32)
	private String outApDId;

	/**
	 * 订单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "订单号")
	@Column(name = "order_no", nullable = true, length = 32)
	private String orderNo;

	/**
	 * 发货单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发货单号")
	@Column(name = "send_order", nullable = true, length = 32)
	private String sendOrder;

	/**
	 * 应付单类型ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_type_id", nullable = true)
	private Long apTypeId;

	/**
	 * 应付单类型编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型编码")
	@Column(name = "ap_type_code", nullable = true, length = 32)
	private String apTypeCode;

	/**
	 * 应付单类型名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型名称")
	@Column(name = "ap_type_name", nullable = true, length = 32)
	private String apTypeName;

	/**
	 * 公司ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ou_id", nullable = true)
	private Long ouId;

	/**
	 * 公司编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司编码")
	@Column(name = "ou_code", nullable = true, length = 32)
	private String ouCode;

	/**
	 * 公司名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司名称")
	@Column(name = "ou_name", nullable = true, length = 32)
	private String ouName;

	/**
	 * 部门ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "bu_id", nullable = true)
	private Long buId;

	/**
	 * 部门编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门编码")
	@Column(name = "bu_code", nullable = true, length = 32)
	private String buCode;

	/**
	 * 部门名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门名称")
	@Column(name = "bu_name", nullable = true, length = 32)
	private String buName;

	/**
	 * 业务员ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "salesman_id", nullable = true)
	private Long salesmanId;

	/**
	 * 业务员编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员编码")
	@Column(name = "salesman_code", nullable = true, length = 32)
	private String salesmanCode;

	/**
	 * 业务员名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员名称")
	@Column(name = "salesman_name", nullable = true, length = 32)
	private String salesmanName;

	/**
	 * 发票号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票号")
	@Column(name = "invoice_number", nullable = true, length = 32)
	private String invoiceNumber;

	/**
	 * 开票日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "开票日期")
	@Column(name = "inv_date", nullable = true)
	private LocalDateTime invDate;

	/**
	 * 发票类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票类型")
	@Column(name = "inv_type", nullable = true, length = 16)
	private String invType;

	/**
	 * 来源单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "来源单号")
	@Column(name = "source_no", nullable = true, length = 64)
	private String sourceNo;

	@Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
	private Integer sourceLine;
	/**
	 * 订货日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "订货日期")
	@Column(name = "orderer_date", nullable = true, length = 64)
	private String ordererDate;

	/**
	 * 订货人
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "订货人")
	@Column(name = "orderer_name", nullable = true, length = 100)
	private String ordererName;

	/**
	 * 订货人电话
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "订货人电话")
	@Column(name = "orderer_phone", nullable = true, length = 32)
	private String ordererPhone;

	/**
	 * ordererAddr
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "ordererAddr")
	@Column(name = "orderer_addr", nullable = true, length = 200)
	private String ordererAddr;

	/**
	 * 渠道类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "渠道类型")
	@Column(name = "chan_type", nullable = true, length = 32)
	private String chanType;

	/**
	 * 打款方式
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "打款方式")
	@Column(name = "payouts_type", nullable = true, length = 32)
	private String payoutsType;

	/**
	 * 供应商ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "supp_id", nullable = true)
	private Long suppId;

	/**
	 * 供应商编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商编号")
	@Column(name = "supp_code", nullable = true, length = 32)
	private String suppCode;

	/**
	 * 供应商名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商名称")
	@Column(name = "supp_name", nullable = true, length = 32)
	private String suppName;

	/**
	 * 商品ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "item_id", nullable = true)
	private Long itemId;

	/**
	 * 商品编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品编码")
	@Column(name = "item_code", nullable = true, length = 32)
	private String itemCode;

	/**
	 * 商品名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "商品名称")
	@Column(name = "item_name", nullable = true, length = 32)
	private String itemName;

	/**
	 * 规格型号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "规格型号")
	@Column(name = "item_type", nullable = true, length = 32)
	private String itemType;

	/**
	 * 数量
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "数量")
	@Column(name = "qty", nullable = true, length = 16)
	private Double qty;

	/**
	 * price
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "price")
	@Column(name = "price", nullable = true, length = 20)
	private Double price;

	/**
	 * totalAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "totalAmt")
	@Column(name = "total_amt", nullable = true, length = 20)
	private Double totalAmt;

	/**
	 * 应付单单据日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单单据日期")
	@Column(name = "ap_date", nullable = true)
	private LocalDateTime apDate;

	/**
	 * notVerAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "notVerAmt")
	@Column(name = "not_ver_amt", nullable = true, length = 20)
	private Double notVerAmt;

	/**
	 * verAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "verAmt")
	@Column(name = "ver_amt", nullable = true, length = 20)
	private Double verAmt;

	/**
	 * 所属组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "belong_org_id", nullable = true)
	private Long belongOrgId;

	/**
	 * 租户组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "tenant_org_id", nullable = true)
	private Long tenantOrgId;

	@Column(name = "uom", columnDefinition = "varchar(32) comment '计量单位'")
	private String uom;

	@Column(name = "uom_name", columnDefinition = "varchar(32) comment '计量单位名称'")
	private String uomName;
}
