package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
/**
 * 应付付款核销申请单明细拆分
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ap_pay_ver_apply_settle")
@DynamicInsert
@DynamicUpdate
@Comment("应付付款核销申请单明细拆分")
@Getter
@Setter
@Accessors(chain = true)
public class FinApPayVerApplySettleDO   extends BaseModel {
private static final long serialVersionUID =1201474159988949296L;

	/**
	 * 主表ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "mas_id", nullable = true)
	private Long masId;

	/**
	 * 应付单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_id", nullable = true)
	private Long apId;

	/**
	 * 外部应付单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部应付单ID")
	@Column(name = "out_ap_id", nullable = true, length = 32)
	private String outApId;

	/**
	 * 应付单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单号")
	@Column(name = "ap_doc_no", nullable = true, length = 32)
	private String apDocNo;

	/**
	 * 第三方应付单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "第三方应付单号")
	@Column(name = "out_ap_doc_no", nullable = true, length = 32)
	private String outApDocNo;

	/**
	 * 应付单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_d_id", nullable = true)
	private Long apDId;

	/**
	 * 外部应付单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部应付单明细ID")
	@Column(name = "out_ap_d_id", nullable = true, length = 32)
	private String outApDId;

	/**
	 * 付款单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_id", nullable = true)
	private Long payId;

	/**
	 * 外部付款单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部付款单ID")
	@Column(name = "out_pay_id", nullable = true, length = 32)
	private String outPayId;

	/**
	 * 付款单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单号")
	@Column(name = "pay_doc_no", nullable = true, length = 32)
	private String payDocNo;

	/**
	 * 第三方付款单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "第三方付款单号")
	@Column(name = "out_pay_doc_no", nullable = true, length = 32)
	private String outPayDocNo;

	/**
	 * 付款单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_d_id", nullable = true)
	private Long payDId;

	/**
	 * 外部付款单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部付款单明细ID")
	@Column(name = "out_pay_d_id", nullable = true, length = 32)
	private String outPayDId;

	/**
	 * 应付供应商编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付供应商编码")
	@Column(name = "ap_supp_code", nullable = true, length = 32)
	private String apSuppCode;

	/**
	 * 付款供应商编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款供应商编码")
	@Column(name = "pay_supp_code", nullable = true, length = 32)
	private String paySuppCode;

	/**
	 * 核销处理编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "核销处理编号")
	@Column(name = "batch_no", nullable = true, length = 32)
	private String batchNo;

	/**
	 * apNotVerAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "apNotVerAmt")
	@Column(name = "ap_not_ver_amt", nullable = true, length = 20)
	private Double apNotVerAmt;

	/**
	 * payNotVerAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "payNotVerAmt")
	@Column(name = "pay_not_ver_amt", nullable = true, length = 20)
	private Double payNotVerAmt;

	/**
	 * verAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "verAmt")
	@Column(name = "ver_amt", nullable = true, length = 20)
	private Double verAmt;

	/**
	 * 所属组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "belong_org_id", nullable = true)
	private Long belongOrgId;

	/**
	 * 租户组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "tenant_org_id", nullable = true)
	private Long tenantOrgId;

	/**
	 * 核销标记，NORMA：应付单和付款单核销，CANCEL：取消核销，INTERNAL：应付单和应付单对冲或付款单和付款单对冲
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "核销标记，NORMA：应付单和付款单核销，CANCEL：取消核销，INTERNAL：应付单和应付单对冲或付款单和付款单对冲")
	@Column(name = "ver_flag", nullable = true, length = 100)
	private String verFlag;

    @Comment("公司编码")
    @Column(columnDefinition = "varchar(32)")
    private String ouCode;

    @Comment("公司ID")
    @Column(columnDefinition = "bigint(20)")
    private Long ouId;

    @Comment("公司名称")
    @Column(columnDefinition = "varchar(32)")
    private String ouName;

	@Comment("应付单行号")
	@Column(name = "ap_source_line")
	private Integer apSourceLine;

	@Comment("付款单行号")
		@Column(name = "pay_source_line")
	private Integer paySourceLine;
}
