package com.elitesland.fin.domain.service.rectype;

import com.elitesland.fin.domain.entity.rectype.RecTypeOu;
import com.elitesland.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.fin.infr.dto.rectype.RecTypeOuDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:28
 */
public interface RecTypeOuDomainService {

    /**
     * 分页查询公司信息
     * @param param 查询参数
     * @return 公司信息
     */
    PagingVO<RecTypeOuDTO> page(RecTypeOuPageParam param);

    /**
     * 根据公司ID查询收款单ID
     * @param ouId 公司ID
     * @return 收款单ID
     */
    List<Long> queryByOuId(Long ouId);

    /**
     * 根据付款单ID查询公司数据
     * @param recTypeId 收款单ID
     * @return 公司信息
     */
    List<RecTypeOuDTO> queryByRecTypeIds(List<Long> recTypeId);

    /**
     * 取消分配公司 --删除
     * @param ids 主键ID
     * @return 主键ID
     */
    List<Long> cancelOu(List<Long> ids);

    /**
     * 分配公司
     * @param recTypeOus 公司信息
     * @return 新增数据ID
     */
    List<Long> addOu(List<RecTypeOu> recTypeOus);
}
