package com.elitesland.fin.domain.service.rectype;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.application.convert.rectype.RecTypeOuConvert;
import com.elitesland.fin.domain.entity.rectype.RecTypeOu;
import com.elitesland.fin.domain.entity.rectype.RecTypeOuDO;
import com.elitesland.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.fin.infr.dto.rectype.RecTypeOuDTO;
import com.elitesland.fin.infr.repo.rectype.RecTypeOuRepo;
import com.elitesland.fin.infr.repo.rectype.RecTypeOuRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:28
 */
@Service
@RequiredArgsConstructor
public class RecTypeOuDomainServiceImpl implements RecTypeOuDomainService {

    private final RecTypeOuRepo recTypeOuRepo;

    private final RecTypeOuRepoProc reTypeOuRepoProc;

    @Override
    public PagingVO<RecTypeOuDTO> page(RecTypeOuPageParam param) {
        return reTypeOuRepoProc.page(param);
    }

    @Override
    public List<Long> queryByOuId(Long ouId) {
        return reTypeOuRepoProc.queryByOuId(ouId);
    }

    @Override
    public List<RecTypeOuDTO> queryByRecTypeIds(List<Long> recTypeId) {
        return reTypeOuRepoProc.queryByRecTypeIds(recTypeId);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> cancelOu(List<Long> ids) {
        reTypeOuRepoProc.deleteByIds(ids);
        return ids;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> addOu(List<RecTypeOu> recTypeOus) {
        if (CollUtil.isEmpty(recTypeOus)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "分配公司获取数据为空");
        } else {
            recTypeOus.forEach(RecTypeOu::checkNotNull);
            Long payTypeId = recTypeOus.get(0).getRecTypeId();
            List<Long> ids = reTypeOuRepoProc.queryByRecTypeIds(List.of(payTypeId))
                    .stream().map(RecTypeOuDTO::getOuId).collect(Collectors.toList());
            //只保留之前没有分配过的公司
            List<RecTypeOu> needSave = recTypeOus.stream().
                    filter(ou -> !ids.contains(ou.getOuId())).collect(Collectors.toList());
            List<RecTypeOuDO> doList = RecTypeOuConvert.INSTANCE.convert(needSave);
            return recTypeOuRepo.saveAll(doList).stream().
                    map(RecTypeOuDO::getId).collect(Collectors.toList());
        }
    }
}
