package com.elitesland.fin.entity.creditaccount;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Entity
@Table(name = "credit_account_ioc")
@org.hibernate.annotations.Table(appliesTo = "credit_account_ioc", comment = "信用账户事务码")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "credit_account_ioc", description = "信用账户事务码")
@Where(clause = "delete_flag = 0")
public class CreditAccountIocDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -3863295502838107507L;

    @ApiModelProperty("事务码")
    @Column(name = "io_code", columnDefinition = "varchar(32)  comment '事务码'")
    private String ioCode;

    @ApiModelProperty("事务码名称")
    @Column(name = "io_name", columnDefinition = "varchar(32)  comment '事务码名称'")
    private String ioName;

    @ApiModelProperty("事务类型 [UDC]FIN:IO_TYPE")
    @Column(name = "io_type", columnDefinition = "varchar(32)  comment '事务类型 [UDC]FIN:CREDIT_IO_TYPE'")
    private String ioType;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @Column(name = "status", columnDefinition = "varchar(32) default 'ACTIVE'  comment '是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS'")
    private String status;
}

