package com.elitesland.fin.infr.repo.artype;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.domain.entity.artype.QArTypeDO;
import com.elitesland.fin.domain.entity.artype.QArTypeDtlDO;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.artype
 * @date 2022/4/11 13:53
 */
@Component
@RequiredArgsConstructor
public class ArTypeRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArTypeDO qArTypeDO = QArTypeDO.arTypeDO;
    private final QArTypeDtlDO qArTypeDtlDO = QArTypeDtlDO.arTypeDtlDO;

    public <T> JPAQuery<T> select(Class<T> T) {
        return jpaQueryFactory.select(Projections.bean(T,
                qArTypeDO.id,
                qArTypeDO.arTypeCode,
                qArTypeDO.arTypeName,
                qArTypeDO.enableFlag,
                qArTypeDO.defaultFlag,
                qArTypeDO.autoAudit,
                qArTypeDO.sourceDoc,
                qArTypeDO.sourceDocType,
                qArTypeDO.sourceDocStatus,
                qArTypeDO.remark,
                qArTypeDO.deleteFlag,
                qArTypeDO.createTime,
                qArTypeDO.creator,
                qArTypeDO.createUserId,
                qArTypeDO.modifyTime,
                qArTypeDO.modifyUserId,
                qArTypeDO.updater
        ))
                .from(qArTypeDO);
    }

    public Boolean queryIsAutoAudit(Long id){
        return jpaQueryFactory.select(qArTypeDO.autoAudit)
                .from(qArTypeDO)
                .where(qArTypeDO.id.eq(id))
                .fetchOne();
    }

    public Boolean existsName(String arTypeName) {

        long res = select(ArTypeDTO.class)
                .where(qArTypeDO.arTypeName.like("%" + arTypeName + "%"))
                .fetchCount();
        return res > 0;
    }

    public Boolean existsCode(String arTypeCode) {

        long res = select(ArTypeDTO.class)
                .where(qArTypeDO.arTypeCode.like("%" + arTypeCode + "%"))
                .fetchCount();
        return res > 0;
    }

    public ArTypeDTO get(Long id) {
        return select(ArTypeDTO.class)
                .where(qArTypeDO.id.eq(id))
                .fetchOne();
    }

    public PagingVO<ArTypeDTO> page(ArTypePageParam arTypePageParam, List<Long> artypeIds) {
        List<Predicate> predicates = new ArrayList<>();
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getArTypeName())) {
            predicates.add(qArTypeDO.arTypeName.like("%" + arTypePageParam.getArTypeName() + "%"));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getArTypeCode())) {
            predicates.add(qArTypeDO.arTypeCode.like("%" + arTypePageParam.getArTypeCode() + "%"));
        }
        if (null != arTypePageParam.getOuId()) {
            if (CollUtil.isNotEmpty(artypeIds)) {
                predicates.add(qArTypeDO.id.in(artypeIds));
            } else {
                return new PagingVO<>();
            }
        }

        /*if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDoc())) {
            predicates.add(qArTypeDO.sourceDoc.eq(arTypePageParam.getSourceDoc()));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDocType())) {
            predicates.add(qArTypeDO.sourceDocType.eq(arTypePageParam.getSourceDocType()));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDocStatus())) {
            predicates.add(qArTypeDO.sourceDocStatus.eq(arTypePageParam.getSourceDocStatus()));
        }*/

        if (CollectionUtil.isNotEmpty(arTypePageParam.getIdList())){
            predicates.add(qArTypeDO.id.in(arTypePageParam.getIdList()));
        }
        predicates.add(qArTypeDO.deleteFlag.eq(0));
        JPAQuery<ArTypeDTO> query = select(ArTypeDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        arTypePageParam.setPaging(query);
        arTypePageParam.fillOrders(query, qArTypeDO);
        return new PagingVO<>(query.fetchCount(), query.fetch());
    }

    public List<ArTypeDTO> findByIds(List<Long> ids) {
        return select(ArTypeDTO.class)
                .where(qArTypeDO.id.in(ids))
                .fetch();
    }

    public void updateEnableFlag(List<Long> ids, boolean enable) {
        jpaQueryFactory.update(qArTypeDO)
                .set(qArTypeDO.enableFlag, enable)
                .where(qArTypeDO.id.in(ids))
                .execute();
    }

    public Boolean isFir() {
        long res = jpaQueryFactory.select(qArTypeDO.id)
                .from(qArTypeDO)
                .fetchCount();
        return res == 0;

    }

    public void updateDef() {
        jpaQueryFactory.update(qArTypeDO)
                .set(qArTypeDO.defaultFlag, false)
                .where(qArTypeDO.defaultFlag.eq(true))
                .execute();
    }

    public Long updateDefById(Long id) {
        return jpaQueryFactory.update(qArTypeDO)
                .set(qArTypeDO.defaultFlag, true)
                .where(qArTypeDO.id.eq(id))
                .execute();
    }

    public ArTypeDTO findById(Long id) {
        return select(ArTypeDTO.class)
                .where(qArTypeDO.id.eq(id))
                .fetchOne();
    }

    public Long del(Long id) {
        return jpaQueryFactory.delete(qArTypeDO)
                .where(qArTypeDO.id.eq(id))
                .execute();
    }

    public List<ArTypeDTO> getList() {
        return select(ArTypeDTO.class)
                .where(qArTypeDO.deleteFlag.eq(0))
                .where(qArTypeDO.enableFlag.eq(true))
                .fetch();
    }

    public ArTypeDTO getDef() {
        return select(ArTypeDTO.class)
                .where(qArTypeDO.deleteFlag.eq(0))
                .where(qArTypeDO.enableFlag.isTrue())
                .where(qArTypeDO.defaultFlag.eq(true))
                .fetchOne();
    }

    public List<ArTypeDTO> arOrderAutoSelectMatchByParam(ArTypePageParam arTypePageParam) {
        List<Predicate> predicates = new ArrayList<>();
       /* if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDoc())) {
            predicates.add(qArTypeDO.sourceDoc.eq(arTypePageParam.getSourceDoc()));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDocType())) {
            predicates.add(qArTypeDO.sourceDocType.eq(arTypePageParam.getSourceDocType()));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDocStatus())) {
            predicates.add(qArTypeDO.sourceDocStatus.eq(arTypePageParam.getSourceDocStatus()));
        }*/

        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDoc())) {
            predicates.add(qArTypeDtlDO.sourceDoc.eq(arTypePageParam.getSourceDoc()));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDocType())) {
            predicates.add(qArTypeDtlDO.sourceDocType.eq(arTypePageParam.getSourceDocType()));
        }
        if (CharSequenceUtil.isNotBlank(arTypePageParam.getSourceDocStatus())) {
            predicates.add(qArTypeDtlDO.sourceDocStatus.eq(arTypePageParam.getSourceDocStatus()));
        }
        predicates.add(qArTypeDO.enableFlag.eq(true));
        predicates.add(qArTypeDO.deleteFlag.eq(0));

       /* JPAQuery<ArTypeDTO> query = select(ArTypeDTO.class)
                .where(ExpressionUtils.allOf(predicates));*/


        JPAQuery<ArTypeDTO> query = jpaQueryFactory.select(Projections.bean(
                ArTypeDTO.class,
                qArTypeDO.id,
                qArTypeDO.arTypeCode,
                qArTypeDO.arTypeName,
                qArTypeDO.enableFlag,
                qArTypeDO.defaultFlag,
                qArTypeDO.createTime,
                qArTypeDO.autoAudit
        )).from(qArTypeDO)
                .leftJoin(qArTypeDtlDO)
                .on(qArTypeDO.id.eq(qArTypeDtlDO.masId))
                .where(ExpressionUtils.allOf(predicates))
                .groupBy(qArTypeDO.id);

        return query.fetch();
    }

}
