package com.elitesland.fin.provider.creditaccountflow;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.param.creditaccountflow.CreditAccountFlowRpcParam;
import com.elitesland.fin.service.creditaccountflow.CreditAccountFlowRpcService;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + AccountFlowRpcService.PATH)
@Slf4j
public class CreditAccountFlowRpcServiceImpl implements CreditAccountFlowRpcService {

    public final CreditAccountFlowService creditAccountFlowService;

    @Override
    public ApiResult<Boolean> generateCreditAccountFlow(CreditAccountFlowRpcParam creditAccountFlowRpcParam) {
        CreditAccountFlowParam creditAccountFlowParam = CreditAccountFlowConvert.INSTANCE
                .creditAccountFlowRpcParam2CreditAccountFlowParam(creditAccountFlowRpcParam);
        creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
        return ApiResult.ok();
    }
}
