package com.elitesland.fin.repo.creditaccount;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAutoRepaymentConditionQueryParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAutoRepaymentConditionRespVO;
import com.elitesland.fin.entity.creditaccount.QCreditAutoRepaymentConditionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/01/08
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class CreditAutoRepaymentConditionRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    private final QCreditAutoRepaymentConditionDO jpaQDo = QCreditAutoRepaymentConditionDO.creditAutoRepaymentConditionDO;


    public PagingVO<CreditAutoRepaymentConditionRespVO> page(CreditAutoRepaymentConditionQueryParam queryParam) {
        List<Predicate> where = where(queryParam);
        JPAQuery<CreditAutoRepaymentConditionRespVO> query = select(CreditAutoRepaymentConditionRespVO.class).where(ExpressionUtils.allOf(where));
        queryParam.setPaging(query);
        queryParam.fillOrders(query, jpaQDo);
        return PagingVO.<CreditAutoRepaymentConditionRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<CreditAutoRepaymentConditionRespVO> selectListByParam(CreditAutoRepaymentConditionQueryParam queryParam) {
        List<Predicate> where = where(queryParam);
        JPAQuery<CreditAutoRepaymentConditionRespVO> query = select(CreditAutoRepaymentConditionRespVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(CreditAutoRepaymentConditionQueryParam queryParam) {
        List<Predicate> predicates = new ArrayList<>();

        if (Objects.nonNull(queryParam.getId())) {
            predicates.add(jpaQDo.id.eq(queryParam.getId()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getIdList())) {
            predicates.add(jpaQDo.id.in(queryParam.getIdList()));
        }
        if (Objects.nonNull(queryParam.getMasId())) {
            predicates.add(jpaQDo.masId.eq(queryParam.getMasId()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getMasIdList())) {
            predicates.add(jpaQDo.masId.in(queryParam.getMasIdList()));
        }
        if (Objects.nonNull(queryParam.getSerialNum())) {
            predicates.add(jpaQDo.serialNum.eq(queryParam.getSerialNum()));
        }
        if (StringUtils.isNotBlank(queryParam.getColumnNameKeyword())) {
            predicates.add(jpaQDo.columnName.like("%" + queryParam.getColumnNameKeyword() + "%"));
        }
        if (StringUtils.isNotBlank(queryParam.getColumnName())) {
            predicates.add(jpaQDo.columnName.eq(queryParam.getColumnName()));
        }
        if (StringUtils.isNotBlank(queryParam.getTableNameKeyword())) {
            predicates.add(jpaQDo.tableName.like("%" + queryParam.getTableNameKeyword() + "%"));
        }
        if (StringUtils.isNotBlank(queryParam.getTableName())) {
            predicates.add(jpaQDo.tableName.eq(queryParam.getTableName()));
        }

        if (!StringUtils.isEmpty(queryParam.getConditionType())) {
            predicates.add(jpaQDo.conditionType.eq(queryParam.getConditionType()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getConditionTypeList())) {
            predicates.add(jpaQDo.conditionType.in(queryParam.getConditionTypeList()));
        }


        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                jpaQDo.id,
                jpaQDo.masId,
                jpaQDo.serialNum,
                jpaQDo.tableName,
                jpaQDo.columnName,
                jpaQDo.conditionType,
                jpaQDo.valueFrom,
                jpaQDo.valueTo,
                jpaQDo.createUserId,
                jpaQDo.creator,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.updater,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.tenantId,
                jpaQDo.auditDataVersion,
                jpaQDo.remark
        )).from(jpaQDo);
    }

}
