package com.elitesland.fin.repo.flow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.entity.flow.QAccountFlowDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class AccountFlowRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAccountFlowDO qAccountFlowDO = QAccountFlowDO.accountFlowDO;

    public PagingVO<AccountFlowVO> page(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.<AccountFlowVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public AccountFlowVO selectByAccCode(String accCode) {
        return select(AccountFlowVO.class)
                .where(qAccountFlowDO.accountCode.eq(accCode))
                .where(qAccountFlowDO.deleteFlag.eq(0).or(qAccountFlowDO.deleteFlag.isNull()))
                .orderBy(qAccountFlowDO.createTime.desc())
                .fetchFirst();
    }

    public List<AccountFlowVO> selectListByParam(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> predicates = new ArrayList<>();

        //开户主体名称
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccountHolderName())) {
            predicates.add(qAccountFlowDO.accountHolderName.eq(accountFlowPageParam.getAccountHolderName()));
        }
        if(CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountHolderNameList())){
            predicates.add(qAccountFlowDO.accountHolderName.in(accountFlowPageParam.getAccountHolderNameList()));
        }

        //账户名称
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccountName())) {
            predicates.add(qAccountFlowDO.accountName.like(accountFlowPageParam.getAccountName()));
        }
        if(CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountNameList())){
            predicates.add(qAccountFlowDO.accountName.in(accountFlowPageParam.getAccountNameList()));
        }
        if(CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountCodeList())){
            predicates.add(qAccountFlowDO.accountCode.in(accountFlowPageParam.getAccountCodeList()));
        }
        //交易类型
        if (!StringUtils.isEmpty(accountFlowPageParam.getTransactionType())) {
            predicates.add(qAccountFlowDO.transactionType.eq(accountFlowPageParam.getTransactionType()));
        }

        //开始交易日期
        if (accountFlowPageParam.getTransactionTimeS() != null) {
            predicates.add(qAccountFlowDO.transactionTime.goe(accountFlowPageParam.getTransactionTimeS()));
        }

        //结束交易日期
        if (accountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add(qAccountFlowDO.transactionTime.loe(accountFlowPageParam.getTransactionTimeE()));
        }

        //发生金额
        if (accountFlowPageParam.getAmountFrom() != null) {
            predicates.add(qAccountFlowDO.amount.goe(accountFlowPageParam.getAmountFrom()));
        }

        //发生金额
        if (accountFlowPageParam.getAmountTo() != null) {
            predicates.add(qAccountFlowDO.amount.loe(accountFlowPageParam.getAmountTo()));
        }

        //归属加盟商
        if (!StringUtils.isEmpty(accountFlowPageParam.getSecFranchiseeCode())) {
            predicates.add(qAccountFlowDO.secFranchiseeCode.eq(accountFlowPageParam.getSecFranchiseeCode()));
        }

        // 账户类型
        if (StrUtil.isNotBlank(accountFlowPageParam.getAccountType())) {
            predicates.add(qAccountFlowDO.accountType.eq(accountFlowPageParam.getAccountType()));
        }

        // 来源单号
        if (StrUtil.isNotBlank(accountFlowPageParam.getSourceNo())) {
            predicates.add(qAccountFlowDO.sourceNo.like("%" + accountFlowPageParam.getSourceNo() + "%"));
        }

        // 来源单号
        if (StrUtil.isNotBlank(accountFlowPageParam.getFlowNo())) {
            predicates.add(qAccountFlowDO.flowNo.like("%" + accountFlowPageParam.getFlowNo() + "%"));
        }

        // 来源单据类型
        if (CollectionUtil.isNotEmpty(accountFlowPageParam.getSourceDocList())) {
            predicates.add(qAccountFlowDO.sourceDoc.in(accountFlowPageParam.getSourceDocList()));
        }

        //old
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getIds())) {
            predicates.add(qAccountFlowDO.id.in(accountFlowPageParam.getIds()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccType())) {
            predicates.add(qAccountFlowDO.accountType.eq(accountFlowPageParam.getAccType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccTypeList())) {
            predicates.add(qAccountFlowDO.accountType.in(accountFlowPageParam.getAccTypeList()));
        }

        if (!CollectionUtils.isEmpty(accountFlowPageParam.getFlowNoList())) {
            predicates.add(qAccountFlowDO.flowNo.in(accountFlowPageParam.getFlowNoList()));
        }

        if (!CollectionUtils.isEmpty(accountFlowPageParam.getTransactionTypeList())) {
            predicates.add(qAccountFlowDO.transactionType.in(accountFlowPageParam.getTransactionTypeList()));
        }

        if (!StringUtils.isEmpty(accountFlowPageParam.getAccKeyword())) {
            predicates.add(qAccountFlowDO.accountCode.like("%" + accountFlowPageParam.getAccKeyword() + "%").or(qAccountFlowDO.accountName.like("%" + accountFlowPageParam.getAccKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccCode())) {
            predicates.add(qAccountFlowDO.accountCode.eq(accountFlowPageParam.getAccCode()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccCodeList())) {
            predicates.add(qAccountFlowDO.accountCode.in(accountFlowPageParam.getAccCodeList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getAccName())) {
            predicates.add(qAccountFlowDO.accountName.like("%" + accountFlowPageParam.getAccName() + "%"));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getSourceNoEq())) {
            predicates.add(qAccountFlowDO.sourceNo.eq(accountFlowPageParam.getSourceNoEq()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceNoList())) {
            predicates.add(qAccountFlowDO.sourceNo.in(accountFlowPageParam.getSourceNoList()));
        }
        if (!StringUtils.isEmpty(accountFlowPageParam.getSourceDoc())) {
            predicates.add(qAccountFlowDO.sourceDoc.eq(accountFlowPageParam.getSourceDoc()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(accountFlowPageParam.getConditions(), AccountFlowDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
        //增加扩展字段查询条件end
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAccountFlowDO.id,
                qAccountFlowDO.accountType,
                qAccountFlowDO.flowNo,
                qAccountFlowDO.transactionType,
                qAccountFlowDO.amount,
                qAccountFlowDO.transactionTime,
                qAccountFlowDO.accountCode,
                qAccountFlowDO.accountName,
                qAccountFlowDO.accountAmount,
                qAccountFlowDO.accountOccupancyAmount,
                qAccountFlowDO.sourceNo,
                qAccountFlowDO.sourceDoc,
                qAccountFlowDO.remark,
                qAccountFlowDO.createTime,
                qAccountFlowDO.createUserId,
                qAccountFlowDO.creator,
                qAccountFlowDO.modifyTime,
                qAccountFlowDO.modifyUserId,
                qAccountFlowDO.updater,
                qAccountFlowDO.deleteFlag,
                qAccountFlowDO.companyCode,
                qAccountFlowDO.secFranchiseeCode,
                qAccountFlowDO.accountType,
                qAccountFlowDO.accountCode,
                qAccountFlowDO.accountName,
                qAccountFlowDO.accountAmount,
                qAccountFlowDO.accountOccupancyAmount,
                qAccountFlowDO.accountAvailableAmount,
                qAccountFlowDO.auditUserId,
                qAccountFlowDO.auditUserName,
                qAccountFlowDO.auditDate,
                qAccountFlowDO.orderState,
                qAccountFlowDO.accountHolderName,
                qAccountFlowDO.ruleCode,
                qAccountFlowDO.priorityNo,
                qAccountFlowDO.extensionInfo
        )).from(qAccountFlowDO);
    }

    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> query = dealerSelect(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.<AccountFlowVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAccountFlowDO.id,
                qAccountFlowDO.flowNo,
                qAccountFlowDO.transactionType,
                qAccountFlowDO.amount,
                qAccountFlowDO.transactionTime,
                qAccountFlowDO.accountCode,
                qAccountFlowDO.accountName,
                qAccountFlowDO.sourceNo,
                qAccountFlowDO.sourceDoc
        )).from(qAccountFlowDO);
    }


    public List<AccountFlowVO> dealerSelectAmt(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = where(accountFlowPageParam);
        JPAQuery<AccountFlowVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AccountFlowVO.class,
                qAccountFlowDO.id,
                qAccountFlowDO.amount
        )).from(qAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public void approveAccountFlow(AccountFlowParam accountFlowParam) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.orderState, accountFlowParam.getOrderState())
                .set(qAccountFlowDO.auditUserId, accountFlowParam.getAuditUserId())
                .set(qAccountFlowDO.auditUserName, accountFlowParam.getAuditUserName())
                .set(qAccountFlowDO.auditDate, accountFlowParam.getAuditDate())
                .where(qAccountFlowDO.id.eq(accountFlowParam.getId()))
                .execute();
    }

    public List<AccountFlowVO> queryByAccountFlowQueryParam(AccountFlowQueryParam accountFlowQueryParam) {
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class);
        if (accountFlowQueryParam.getSourceId() != null) {
            query.where(qAccountFlowDO.sourceId.eq(accountFlowQueryParam.getSourceId()));
        }
        if (accountFlowQueryParam.getSourceNo() != null) {
            query.where(qAccountFlowDO.sourceNo.eq(accountFlowQueryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty(accountFlowQueryParam.getSourceDoc())) {
            query.where(qAccountFlowDO.sourceDoc.eq(accountFlowQueryParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty(accountFlowQueryParam.getSourceDocStatus())) {
            query.where(qAccountFlowDO.sourceDocStatus.eq(accountFlowQueryParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty(accountFlowQueryParam.getAccountType())) {
            query.where(qAccountFlowDO.accountType.eq(accountFlowQueryParam.getAccountType()));
        }
        if (StringUtils.isNotEmpty(accountFlowQueryParam.getAccountCode())) {
            query.where(qAccountFlowDO.accountCode.eq(accountFlowQueryParam.getAccountCode()));
        }

        return query.fetch();
    }

    public void updateAccountFlowAmount(AccountFlowParam accountFlowParam) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.accountAmount, accountFlowParam.getAccountAmount())
                .set(qAccountFlowDO.accountOccupancyAmount, accountFlowParam.getAccountOccupancyAmount())
                .set(qAccountFlowDO.accountAvailableAmount, accountFlowParam.getAccountAvailableAmount())
                .where(qAccountFlowDO.accountCode.eq(accountFlowParam.getAccountCode())
                        .and(qAccountFlowDO.orderState.eq(accountFlowParam.getOrderState())))
                .execute();
    }
    public void updateAccountFlowAmountById(AccountFlowParam accountFlowParam) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.accountAmount, accountFlowParam.getAccountAmount())
                .set(qAccountFlowDO.accountOccupancyAmount, accountFlowParam.getAccountOccupancyAmount())
                .set(qAccountFlowDO.accountAvailableAmount, accountFlowParam.getAccountAvailableAmount())
                .set(qAccountFlowDO.orderState, accountFlowParam.getOrderState())
                .set(qAccountFlowDO.auditUserId, accountFlowParam.getAuditUserId())
                .set(qAccountFlowDO.auditUserName, accountFlowParam.getAuditUserName())
                .set(qAccountFlowDO.auditDate, accountFlowParam.getAuditDate())
                .where(qAccountFlowDO.id.eq(accountFlowParam.getId())
                        .and(qAccountFlowDO.orderState.eq(accountFlowParam.getOrderState())))
                .execute();
    }

    public List<AccountFlowVO> selectListByQueryParam(AccountFlowQueryParam queryParam) {
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class);

        if (StringUtils.isNotEmpty(queryParam.getSourceNo())) {
            query.where(qAccountFlowDO.sourceNo.eq(queryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty(queryParam.getAccountType())) {
            query.where(qAccountFlowDO.accountType.eq(queryParam.getAccountType()));
        }
        if (StringUtils.isNotEmpty(queryParam.getFlowNo())) {
            query.where(qAccountFlowDO.flowNo.eq(queryParam.getFlowNo()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getFlowNoList())) {
            query.where(qAccountFlowDO.flowNo.in(queryParam.getFlowNoList()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getAccountCodeList())) {
            query.where(qAccountFlowDO.accountCode.in(queryParam.getAccountCodeList()));
        }
        return query.fetch();
    }

    public AccountFlowVO selectPreviousRepairAmtByParam(AccountFlowQueryParam flowQueryParam) {
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class);
        if (!StringUtils.isEmpty(flowQueryParam.getAccountCode())) {
            query.where(qAccountFlowDO.accountCode.eq(flowQueryParam.getAccountCode()));
        }
        query.where(qAccountFlowDO.auditDate.isNotNull());

        return query.orderBy(qAccountFlowDO.auditDate.desc())
                .fetchFirst();
    }


    public List<AccountFlowVO> selectRepairAfterPage(AccountFlowPageParam flowPageParam) {
        List<Predicate> where = selectRepairAfterPageWhere(flowPageParam);
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(qAccountFlowDO.auditDate.desc());
        flowPageParam.setPaging(query);

        return query.fetch();
    }

    private List<Predicate> selectRepairAfterPageWhere(AccountFlowPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add(qAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add(qAccountFlowDO.auditDate.gt(pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty(pageParam.getAccountCode())) {
            predicates.add(qAccountFlowDO.accountCode.eq(pageParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getAccountCodeList())) {
            predicates.add(qAccountFlowDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        return predicates;
    }

    public List<AccountFlowVO> selectRepairAfter(AccountFlowPageParam flowPageParam) {
        List<Predicate> where = selectRepairAfterWhere(flowPageParam);
        JPAQuery<AccountFlowVO> query = select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(qAccountFlowDO.auditDate.desc());

        return query.fetch();
    }

    private List<Predicate> selectRepairAfterWhere(AccountFlowPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add(qAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add(qAccountFlowDO.auditDate.goe(pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty(pageParam.getAccountCode())) {
            predicates.add(qAccountFlowDO.accountCode.eq(pageParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getAccountCodeList())) {
            predicates.add(qAccountFlowDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        return predicates;
    }

    public void updateOccupancyAndAvailableAndAmountById(BigDecimal accountOccupancyAmount,BigDecimal accountAvailableAmount,
                                                         BigDecimal amount, Long id) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.accountOccupancyAmount, accountOccupancyAmount)
                .set(qAccountFlowDO.accountAvailableAmount, accountAvailableAmount)
                .set(qAccountFlowDO.amount, amount)
                .where(qAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateAccountAndAvailableAndAmountById(BigDecimal accountAmount,BigDecimal accountAvailableAmount,
                                                         BigDecimal amount, Long id) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.accountAmount, accountAmount)
                .set(qAccountFlowDO.accountAvailableAmount, accountAvailableAmount)
                .set(qAccountFlowDO.amount, amount)
                .where(qAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateOccupancyAndAvailableById(BigDecimal accountOccupancyAmount,BigDecimal accountAvailableAmount,
                                                         Long id) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.accountOccupancyAmount, accountOccupancyAmount)
                .set(qAccountFlowDO.accountAvailableAmount, accountAvailableAmount)
                .where(qAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateAccountAndAvailableById(BigDecimal accountAmount,BigDecimal accountAvailableAmount,
                                                       Long id) {
        jpaQueryFactory.update(qAccountFlowDO)
                .set(qAccountFlowDO.accountAmount, accountAmount)
                .set(qAccountFlowDO.accountAvailableAmount, accountAvailableAmount)
                .where(qAccountFlowDO.id.eq(id))
                .execute();
    }


}
