package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderExPageParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderExVo;
import com.elitesland.fin.domain.entity.arorder.*;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 应收单.
 *
 * @author shihao.ma
 * @since 2023/9/14
 */
@Repository
public class ArOrderExRepoProc extends BaseRepoProc<ArOrderExDo> {

    private static final QArOrderExDo QDO = QArOrderExDo.arOrderExDo;
    private static final QArOrderDO QMas = QArOrderDO.arOrderDO;
    private static final QArOrderDtlDO qArOrderDtlDO = QArOrderDtlDO.arOrderDtlDO;
    private static final QArOderExDtlDo qArOderExDtlDo = QArOderExDtlDo.arOderExDtlDo;
    //private static final QSalDoDO qSalDoDO = QSalDoDO.salDoDO;
    //private static final QSalSoDO qSalSoDO = QSalSoDO.salSoDO;

    protected ArOrderExRepoProc() {
        super(QDO);
    }

    /**
     * 查询应收单明细、明细扩展集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    public PagingVO<ArOrderExVo> page(ArOrderExPageParam query) {

        Predicate predicate = PredicateBuilder.builder()
                .andLike(QMas.arOrderNo, query.getArOrderNo())
                .andEq(QMas.ouCode, query.getOuCode())
                .andEq(QMas.custCode, query.getCustCode())
                .andGoe(QMas.totalAmt, query.getTotalAmtStart())
                .andLoe(QMas.totalAmt, query.getTotalAmtEnd())
                .andEq(QMas.saleUser, query.getBusinessCode())
                .andEq(qArOderExDtlDo.currCode, query.getCurrCode())
                .andEq(QDO.invType, query.getInvType())
                .andBetween(QDO.invDate, query.getInvStartDate(), query.getInvEndDate())
                .andBetween(QDO.createTime, query.getCreateTimeStart(), query.getCreateTimeEnd())
                .andLike(QDO.invoiceNumber, query.getInvoiceNumber())
                .andLike(QDO.remark, query.getRemark())
                .andLike(QMas.sourceNo, query.getSourceNo())
                .andEq(QMas.initFlag, query.getInitFlag())
                .andEq(QDO.redFlushSign, query.getRedFlushSign())
                .andEq(QMas.verState, query.getVerState())
                .andIn(QMas.verState, query.getVerStateList())
                .andIn(QMas.id, query.getIds())
                .build();

        JPAQuery<ArOrderExVo> select = jpaQueryFactory.select(Projections.bean(ArOrderExVo.class,
                QDO.id.as("extId"),
                QDO.orderCustomer,
                QDO.relateId,
                QDO.invoiceNumber,
                QDO.invDate,
                QDO.invType,
                QDO.startDate,
                QDO.redFlushSign,
                QDO.thirdPaymentAssistance,
                QDO.consumerCardSsistance,
                QDO.creditCardAssistance,
                QDO.remark,
                QMas.sourceNo,
                QMas.arOrderNo,
                QMas.ouCode,
                QMas.orderState,
                QMas.buDate,
                QMas.totalAmt,
                QMas.custCode,
                QMas.currName,
                QMas.currCode,
                QMas.initFlag,
                QMas.buCode,
                QMas.createTime,
                QMas.creator,
                QMas.id,
                QMas.saleUser))
                .from(QDO)
                .leftJoin(qArOderExDtlDo).on(QDO.id.eq(qArOderExDtlDo.masId))
                .where(predicate)
                .groupBy(QDO.id);
        return super.queryByPage(select, query.getPageRequest(), QDO.createTime.desc());
    }

    public PagingVO<ArOrderDtlExVo> detailPage(ArOrderDtlExPageParam query) {

        JPAQuery<ArOrderDtlExVo> select = jpaQueryFactory.select(Projections.bean(ArOrderDtlExVo.class,
                qArOderExDtlDo.id,
                qArOderExDtlDo.masId,
                qArOderExDtlDo.relateId,
                qArOderExDtlDo.orderCustomer,
                qArOderExDtlDo.invoiceNumber,
                qArOderExDtlDo.sendOrder,
                qArOderExDtlDo.thirdOrderDtId,
                qArOderExDtlDo.applicationDtId,
                qArOderExDtlDo.currCode,
                qArOderExDtlDo.unitpriceBeforeTax,
                qArOderExDtlDo.taxCode,
                qArOderExDtlDo.invoiceType,
                qArOderExDtlDo.reciveAgreement,
                qArOderExDtlDo.businessCode,
                qArOderExDtlDo.exchangeRate,
                qArOderExDtlDo.startDate,
                qArOderExDtlDo.paymentDueDate,
                qArOderExDtlDo.startDate,
                qArOderExDtlDo.unVerAmt,
                qArOderExDtlDo.applyVerAmTing,
                qArOderExDtlDo.verAmt,
                qArOderExDtlDo.deleteFlag,
                qArOderExDtlDo.tenantId,
                qArOderExDtlDo.belongOrgId,
                qArOderExDtlDo.tenantOrgId,
                qArOderExDtlDo.createTime,
                qArOderExDtlDo.updater,
                qArOderExDtlDo.modifyTime,
                qArOderExDtlDo.creator,
                qArOderExDtlDo.remark,
                qArOderExDtlDo.salSoDocNo,
                QMas.sourceNo,
                QMas.ouCode,
                QMas.buCode.as("masBuCode"),
                QMas.totalAmt.as("mainTotalAmt"),
                //qSalSoDO.saleChannel.as("soSource"),
                qArOrderDtlDO.id.as("arDId"),
                qArOrderDtlDO.itemCode,
                qArOrderDtlDO.price,
                qArOrderDtlDO.totalAmt,
                qArOrderDtlDO.qty,
                qArOrderDtlDO.taxRate,
                qArOrderDtlDO.taxAmt,
                qArOrderDtlDO.exclTaxAmt,
                QMas.saleUser,
                QMas.id.as("arOrderId"),
                QMas.arOrderNo,
                QDO.invoiceNumber,
                QDO.invDate,
                QDO.invType,
                //qSalDoDO.recvContactName,
                        //qSalDoDO.recvContactTel,
                        //qSalDoDO.recvDetailaddr.as("recDetailaddr"),
                        //qSalDoDO.payMethod,
                        //qSalDoDO.relateDocNo.as("orderNo"),
                qArOderExDtlDo.custCode
                        //qSalSoDO.custName,
                        //qSalSoDO.saleChannel.as("soSource"),
                        //qSalSoDO.agentName.as("businessName"),
                        //qSalSoDO.ouName,
                //qSalSoDO.buName
                ))
                .from(qArOderExDtlDo)
                .leftJoin(QDO).on(QDO.id.eq(qArOderExDtlDo.masId))
                .leftJoin(qArOrderDtlDO).on(qArOrderDtlDO.relateId.eq(qArOderExDtlDo.relateId))
                //.leftJoin(qSalDoDO).on(qSalDoDO.docNo.eq(qArOderExDtlDo.sendOrder))
                //.leftJoin(qSalSoDO).on(qSalDoDO.relateDocId.eq(qSalSoDO.id))
                .where(ExpressionUtils.allOf(getPredicate(query)));

        return super.queryByPage(select, query.getPageRequest(), QDO.createTime.desc());
    }

    private List<Predicate> getPredicate(ArOrderDtlExPageParam param) {

        List<Predicate> predicates = new ArrayList<>();
        // 应收单主键
        if (CollectionUtils.isNotEmpty(param.getMasIds())) {
            predicates.add(QMas.id.in(param.getMasIds()));
        }
        // 应收单主键
        if (null != param.getMasId()) {
            predicates.add(QMas.id.eq(param.getMasId()));
        }
        // 第三方应收单号
        if (StringUtils.isNotBlank(param.getThirdOrderNum())) {
            predicates.add(QMas.sourceNo.like("%" + param.getThirdOrderNum() + "%"));
        }
        // 销售公司
        if (StringUtils.isNotBlank(param.getOuCode())) {
            predicates.add(QMas.ouCode.eq(param.getOuCode()));
        }
        // 业务员
        if (StringUtils.isNotBlank(param.getBusinessCode())) {
            predicates.add(qArOderExDtlDo.businessCode.eq(param.getBusinessCode()));
        }
        // 开票日期
        if (null != param.getInvStartDate() && null != param.getInvEndDate()) {
            predicates.add(QDO.invDate.between(param.getInvStartDate(), param.getInvEndDate()));
        }
        // 发票号码
        if (StringUtils.isNotBlank(param.getInvoiceNumber())) {
            predicates.add(QDO.invoiceNumber.like("%" + param.getInvoiceNumber() + "%"));
        }
        // 订单号
        if (StringUtils.isNotBlank(param.getOrderNo())) {
            predicates.add(qArOderExDtlDo.salSoDocNo.like("%" + param.getOrderNo() + "%"));
        }
        // 订单日期
       /* if (null != param.getOrderStartDate() && null != param.getOrderEndDate()) {
            predicates.add(qSalDoDO.docDate.between(param.getOrderStartDate(), param.getOrderEndDate()));
        }*/
        // 主客户编码
        if (StringUtils.isNotBlank(param.getCustCode())) {
            predicates.add(qArOderExDtlDo.custCode.eq(param.getCustCode()));
        }
        // 子客户编码
       /* if (StringUtils.isNotBlank(param.getSubCustCode())) {
            predicates.add(qSalSoDO.custCode.eq(param.getSubCustCode()));
        }*/
        // 渠道类型
       /* if (StringUtils.isNotBlank(param.getSoSource())) {
            predicates.add(qSalDoDO.soSource.like("%" + param.getSoSource() + "%"));
        }*/
        // 商品名称
        if (StringUtils.isNotBlank(param.getItemCode())) {
            predicates.add(qArOrderDtlDO.itemCode.eq(param.getItemCode()));
        }
        if (null != param.getItemId()) {
            predicates.add(qArOrderDtlDO.itemId.eq(param.getItemId()));
        }
        // 单据日期
        if (null != param.getCreateTimeStart() && null != param.getCreateTimeEnd()) {
            predicates.add(QDO.createTime.between(param.getCreateTimeStart(), param.getCreateTimeEnd()));
        }
        // 备注
        if (StringUtils.isNotBlank(param.getRemark())) {
            predicates.add(qArOderExDtlDo.remark.like("%" + param.getRemark() + "%"));
        }

        // 过滤为0的
        if (CollectionUtils.isEmpty(param.getMasIds()) && param.getMasId() == null) {
            predicates.add(qArOderExDtlDo.unVerAmt.ne(BigDecimal.ZERO));
        }

        return predicates;
    }
}
